/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.ui.internal.search;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.ui.internal.Activator;
import com.ibm.etools.references.ui.internal.nls.Messages;
import com.ibm.etools.references.ui.internal.search.FileTreeContentProvider;
import com.ibm.etools.references.ui.internal.search.IReferenceContentProvider;
import com.ibm.etools.references.ui.internal.search.ReferencesLabelProvider;
import com.ibm.etools.references.ui.internal.search.ReferencesSearchQuery;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;

public class ReferenceSearchResultPage
extends AbstractTextSearchViewPage {
    private int fDisplayLimit = 0;
    private IReferenceContentProvider fContentProvider;
    private final DoubleClickListener doubleClick = new DoubleClickListener();

    public Integer getElementLimit() {
        return this.fDisplayLimit;
    }

    public String getLabel() {
        String label = super.getLabel();
        if (this.getElementLimit() >= 0) {
            int matchCount = 0;
            int total = 0;
            AbstractTextSearchResult input = this.getInput();
            if (input != null) {
                matchCount = input.getMatchCount();
                total = ((ReferencesSearchQuery)input.getQuery()).getTotalResultSize();
                return NLS.bind((String)Messages.XfilterMatchedYofZitems, (Object[])new String[]{label, Integer.valueOf(Math.min(matchCount, this.getElementLimit())).toString(), Integer.valueOf(total).toString()});
            }
        }
        return label;
    }

    public void setElementLimit(Integer limit) {
        this.fDisplayLimit = limit;
        super.setElementLimit(limit);
        Activator.getDefault().getPreferenceStore().setValue("com.ibm.etools.references.ui.search.displayLimit", limit.intValue());
    }

    public ReferenceSearchResultPage() {
        super(3);
        this.fDisplayLimit = Activator.getDefault().getPreferenceStore().getInt("com.ibm.etools.references.ui.search.displayLimit");
    }

    protected void clear() {
        this.getViewer().refresh();
    }

    protected void configureTableViewer(TableViewer viewer) {
        this.fContentProvider = new FileTreeContentProvider((ColumnViewer)viewer, false);
        viewer.setContentProvider((IContentProvider)((IStructuredContentProvider)this.fContentProvider));
        DecoratingStyledCellLabelProvider labelProvider = new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ReferencesLabelProvider(viewer.getTable().getDisplay()), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null);
        viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        viewer.addDoubleClickListener((IDoubleClickListener)this.doubleClick);
        viewer.setComparator((ViewerComparator)new ILinkComparator());
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        this.fContentProvider = new FileTreeContentProvider((ColumnViewer)viewer, true);
        viewer.setContentProvider((IContentProvider)((IStructuredContentProvider)this.fContentProvider));
        DecoratingStyledCellLabelProvider labelProvider = new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ReferencesLabelProvider(viewer.getTree().getDisplay()), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null);
        viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        viewer.addDoubleClickListener((IDoubleClickListener)this.doubleClick);
        viewer.setComparator((ViewerComparator)new ILinkComparator());
    }

    protected void elementsChanged(Object[] objects) {
        if (this.fContentProvider != null) {
            this.fContentProvider.elementsChanged(objects);
        }
    }

    private class DoubleClickListener
    implements IDoubleClickListener {
        private DoubleClickListener() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void doubleClick(DoubleClickEvent event) {
            IStructuredSelection ss = (IStructuredSelection)ReferenceSearchResultPage.this.getViewer().getSelection();
            if (ss == null) return;
            Object o = ss.getFirstElement();
            if (o instanceof ILink) {
                IResource resource;
                ILink link = (ILink)o;
                LinkNode container = link.getContainer();
                if (container == null || (resource = container.getResource()) == null || resource.getType() != 1) return;
                IEditorPart part = null;
                try {
                    part = IDE.openEditor((IWorkbenchPage)ReferenceSearchResultPage.this.getSite().getPage(), (IFile)((IFile)resource));
                    if (part == null) return;
                    IMarker marker = resource.createMarker("org.eclipse.core.resources.textmarker");
                    marker.setAttribute("charStart", link.getLinkLocation().getOffset());
                    marker.setAttribute("charEnd", link.getLinkLocation().getOffset() + link.getLinkLocation().getLength());
                    IGotoMarker gotom = (IGotoMarker)part.getAdapter(IGotoMarker.class);
                    if (gotom == null) return;
                    gotom.gotoMarker(marker);
                    return;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error opening editor", e);
                }
            }
            if (!(o instanceof IFile)) return;
            try {
                IDE.openEditor((IWorkbenchPage)ReferenceSearchResultPage.this.getSite().getPage(), (IFile)((IFile)o));
                return;
            }
            catch (PartInitException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class ILinkComparator
    extends ViewerComparator {
        private ILinkComparator() {
        }

        public int category(Object element) {
            if (element instanceof IFolder) {
                return 0;
            }
            if (element instanceof IFile) {
                return 1;
            }
            return 2;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            if (e1 instanceof ILink && e2 instanceof ILink) {
                ILink l1 = (ILink)e1;
                ILink l2 = (ILink)e2;
                int fcompare = l1.getPath().toString().compareTo(l2.getPath().toString());
                if (fcompare == 0) {
                    return l1.getContextLocation().getOffset() - l2.getContextLocation().getOffset();
                }
                return fcompare;
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

