/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.ui.internal.search;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.ui.internal.Activator;
import com.ibm.etools.references.ui.internal.search.ReferencesSearchQuery;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class ReferenceSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    private final ReferencesSearchQuery query;

    public ReferenceSearchResult(ReferencesSearchQuery query) {
        this.query = query;
    }

    public ImageDescriptor getImageDescriptor() {
        return Activator.getImageDescriptor("icons/obj16/link_reuslt.gif");
    }

    public String getLabel() {
        return this.query.getLabel();
    }

    public ISearchQuery getQuery() {
        return this.query;
    }

    public String getTooltip() {
        return "";
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        IEditorInput ei = editor.getEditorInput();
        if (ei instanceof IFileEditorInput) {
            IFileEditorInput fi = (IFileEditorInput)ei;
            ILink link = (ILink)match.getElement();
            if (link.getContainer() == null) {
                return false;
            }
            if (link.getContainer().getResource() != null) {
                return link.getContainer().getResource().equals((Object)fi.getFile());
            }
        }
        return false;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        IEditorInput ei = editor.getEditorInput();
        if (ei instanceof IFileEditorInput) {
            IFileEditorInput fi = (IFileEditorInput)ei;
            return this.computeContainedMatches(result, fi.getFile());
        }
        return new Match[0];
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        Object[] elements;
        ArrayList<Match> matches = new ArrayList<Match>();
        Object[] objectArray = elements = this.getElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IResource linkFile;
            Object object = objectArray[n2];
            ILink link = (ILink)object;
            if (link.isValid() && link.getContainer() != null && (linkFile = link.getContainer().getResource()).equals((Object)file)) {
                matches.addAll(Arrays.asList(this.getMatches(link)));
            }
            ++n2;
        }
        return matches.toArray(new Match[matches.size()]);
    }

    public IFile getFile(Object element) {
        if (element instanceof ILink) {
            if (((ILink)element).getContainer() == null) {
                return null;
            }
            IResource file = ((ILink)element).getContainer().getResource();
            if (file.getType() == 1) {
                return (IFile)file;
            }
        }
        return null;
    }
}

