/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.ui.internal.search;

import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.ui.internal.nls.Messages;
import com.ibm.etools.references.ui.internal.search.ReferencesSearchQuery;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;

public class ReferenceSearchPage
extends DialogPage
implements ISearchPage {
    private ISearchPageContainer container;
    private Button caseSensitive;
    private Text searchstring;
    private Button incoming;

    public ReferenceSearchPage() {
    }

    public ReferenceSearchPage(String title) {
        super(title);
    }

    public ReferenceSearchPage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public boolean performAction() {
        ArrayList<Object> resources = new ArrayList<Object>();
        if (this.container.getSelectedScope() == 3) {
            int i = 0;
            while (i < this.container.getSelectedProjectNames().length) {
                String name = this.container.getSelectedProjectNames()[i];
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                resources.add(project);
                ++i;
            }
        } else if (this.container.getSelectedScope() == 2) {
            IWorkingSet[] sets = this.container.getSelectedWorkingSets();
            int i = 0;
            while (i < sets.length) {
                IWorkingSet workingSet = sets[i];
                IAdaptable[] adaptables = workingSet.getElements();
                int j = 0;
                while (j < adaptables.length) {
                    IAdaptable adaptable = adaptables[j];
                    IResource r = (IResource)adaptable.getAdapter(IResource.class);
                    if (r != null) {
                        resources.add(r);
                    }
                    ++j;
                }
                ++i;
            }
        } else if (this.container.getSelectedScope() == 1) {
            ISelection s = this.container.getSelection();
            if (s instanceof IStructuredSelection) {
                for (Object object : (IStructuredSelection)s) {
                    IResource r;
                    if (!(object instanceof IAdaptable) || (r = (IResource)((IAdaptable)object).getAdapter(IResource.class)) == null) continue;
                    resources.add(r);
                }
            }
        } else if (this.container.getSelectedScope() == 0) {
            resources.add(ResourcesPlugin.getWorkspace().getRoot());
        }
        if (!resources.isEmpty()) {
            SearchScope scope = SearchEngine.createSearchScope(resources);
            ReferencesSearchQuery query = new ReferencesSearchQuery(scope, this.searchstring.getText(), this.incoming.getSelection(), this.caseSensitive.getSelection());
            NewSearchUI.runQueryInForeground((IRunnableContext)this.container.getRunnableContext(), (ISearchQuery)query);
        }
        return true;
    }

    public void setContainer(ISearchPageContainer container) {
        this.container = container;
        this.container.equals(container);
    }

    public void createControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        Label l = new Label(c, 0);
        l.setText(Messages.search_pagelink_text_search_string);
        Composite col2 = new Composite(c, 0);
        col2.setLayout((Layout)new GridLayout(2, false));
        this.searchstring = new Text(col2, 2048);
        GridDataFactory.defaultsFor((Control)this.searchstring).applyTo((Control)this.searchstring);
        this.caseSensitive = new Button(col2, 32);
        this.caseSensitive.setText(Messages.search_pagecase_sensitive);
        this.caseSensitive.setSelection(true);
        this.caseSensitive.setEnabled(false);
        Group dir = new Group(c, 0);
        dir.setText(Messages.search_pagedirection);
        Button outgoing = new Button((Composite)dir, 16);
        outgoing.setText(Messages.search_pageoutgoing_links);
        outgoing.setSelection(true);
        this.incoming = new Button((Composite)dir, 16);
        this.incoming.setText(Messages.search_pageincoming_links);
        GridLayoutFactory.swtDefaults().applyTo((Composite)dir);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)dir);
        GridLayoutFactory.swtDefaults().applyTo(c);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)c);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)col2);
        this.setControl((Control)parent);
    }
}

