/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.ui.internal.quickfix;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.ui.quickfix.ReferenceQuickFix;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class QuickFixRegistry {
    public static boolean hasQuickFix(int providerId) {
        IConfigurationElement[] quickFixes;
        String resolverId = InternalAPI.getRefResolverId((int)providerId);
        if (resolverId == null) {
            return false;
        }
        IConfigurationElement[] iConfigurationElementArray = quickFixes = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.etools.references.ui", "referenceQuickFix");
        int n = quickFixes.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] applicableRefResolvers;
            IConfigurationElement refQuickFix = iConfigurationElementArray[n2];
            IConfigurationElement[] iConfigurationElementArray2 = applicableRefResolvers = refQuickFix.getChildren("resolverIdRef");
            int n3 = applicableRefResolvers.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement rId = iConfigurationElementArray2[n4];
                String ref = rId.getAttribute("ref");
                if (resolverId.equals(ref)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public static Set<ReferenceQuickFix> getQuickFix(int providerId) {
        IConfigurationElement[] quickFixes;
        HashSet<ReferenceQuickFix> fixes = new HashSet<ReferenceQuickFix>();
        String resolverId = InternalAPI.getRefResolverId((int)providerId);
        if (resolverId == null) {
            return fixes;
        }
        IConfigurationElement[] iConfigurationElementArray = quickFixes = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.etools.references.ui", "referenceQuickFix");
        int n = quickFixes.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement refQuickFix = iConfigurationElementArray[n2];
            IConfigurationElement[] applicableRefResolvers = refQuickFix.getChildren("resolverIdRef");
            boolean created = false;
            IConfigurationElement[] iConfigurationElementArray2 = applicableRefResolvers;
            int n3 = applicableRefResolvers.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement rId = iConfigurationElementArray2[n4];
                String ref = rId.getAttribute("ref");
                if (resolverId.equals(ref)) {
                    created = true;
                    try {
                        ReferenceQuickFix quickFix = (ReferenceQuickFix)((Object)refQuickFix.createExecutableExtension("class"));
                        quickFix.setProviderId(providerId);
                        fixes.add(quickFix);
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not create class ", e);
                    }
                }
                ++n4;
            }
            if (created) break;
            ++n2;
        }
        return fixes;
    }
}

