/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.ui.internal.preferences;

import com.ibm.etools.references.events.IReferenceListener;
import com.ibm.etools.references.events.ReferenceEvent;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.ui.internal.Activator;
import com.ibm.etools.references.ui.internal.BuildUtil;
import com.ibm.etools.references.ui.internal.nls.Messages;
import com.ibm.etools.references.ui.internal.preferences.FilePatternListEditor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class ReferencesPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
IEclipsePreferences.IPreferenceChangeListener,
IReferenceListener {
    private static int ERROR_TYPE_NONE = 0;
    private static int ERROR_TYPE_FATALERROR = 1;
    private static int ERROR_TYPE_SUSPENDED = 1;
    private List<FieldEditor> fields;
    private final IEclipsePreferences instancePrefs;
    private boolean warningShowing = false;
    private Button rebuild;
    private Composite warningComposite;
    private FilePatternListEditor filePatterns;

    public ReferencesPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        InstanceScope scope = new InstanceScope();
        this.instancePrefs = scope.getNode("com.ibm.etools.references");
        this.instancePrefs.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        ReferenceManager.getReferenceManager().addReferenceListener((IReferenceListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
    }

    protected void adjustGridLayout() {
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        if (ReferenceManager.getReferenceManager().hasFatalError()) {
            this.updateWarningSection(ERROR_TYPE_FATALERROR);
        } else if (ReferenceManager.getReferenceManager().isSuspended()) {
            this.updateWarningSection(ERROR_TYPE_SUSPENDED);
        } else {
            this.updateWarningSection(ERROR_TYPE_NONE);
        }
        return c;
    }

    public void dispose() {
        super.dispose();
        this.instancePrefs.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        ReferenceManager.getReferenceManager().removeReferenceListener((IReferenceListener)this);
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (this.fields != null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    for (FieldEditor editor : ReferencesPreferencePage.this.fields) {
                        editor.load();
                    }
                }
            });
        }
    }

    protected void addField(FieldEditor editor) {
        if (this.fields == null) {
            this.fields = new ArrayList<FieldEditor>();
        }
        this.fields.add(editor);
        super.addField(editor);
    }

    public void createFieldEditors() {
        new PreferenceLinkArea(this.getFieldEditorParent(), 0, "org.eclipse.ui.editors.preferencePages.HyperlinkDetectorsPreferencePage", Messages.SeeXToControlLinkDisplay, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        new PreferenceLinkArea(this.getFieldEditorParent(), 0, "com.ibm.etools.references.ui.preferences.ReferencesValidationPreferencePage", Messages.SeeXToControlLinkValidation, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        Group general = new Group(this.getFieldEditorParent(), 0);
        general.setText(Messages.General);
        this.addField((FieldEditor)new BooleanFieldEditor("jdtSearchParticipant", Messages.pref_participant_javasearch, 0, (Composite)general));
        GridLayoutFactory.createFrom((GridLayout)((GridLayout)general.getLayout())).margins(LayoutConstants.getMargins()).applyTo((Composite)general);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)general);
        Group ignored = new Group(this.getFieldEditorParent(), 0);
        ignored.setText(Messages.ignoredresources);
        this.filePatterns = new FilePatternListEditor("referenceIgnoredPaths", Messages.containspathstoexclude, (Composite)ignored);
        this.addField(this.filePatterns);
        this.addField((FieldEditor)new BooleanFieldEditor("referneceIgnoreDerived", Messages.ignorederived, 0, (Composite)ignored));
        GridLayoutFactory.createFrom((GridLayout)((GridLayout)ignored.getLayout())).margins(LayoutConstants.getMargins()).numColumns(2).applyTo((Composite)ignored);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)ignored);
        this.rebuild = new Button(this.getFieldEditorParent(), 8);
        this.rebuild.setText(Messages.prefs_rebuild_link_database_button);
        this.rebuild.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildUtil.rebuildDatabase();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        GridDataFactory.defaultsFor((Control)this.rebuild).align(1, 1).grab(false, false).applyTo((Control)this.rebuild);
    }

    private void updateWarningSection(int warningType) {
        if (this.getFieldEditorParent().isDisposed()) {
            return;
        }
        if (!this.warningShowing && warningType > ERROR_TYPE_NONE) {
            Point dsize = this.getFieldEditorParent().computeSize(-1, -1);
            this.warningShowing = true;
            this.warningComposite = new Composite(this.getFieldEditorParent(), 0x280000);
            this.warningComposite.moveAbove((Control)this.rebuild);
            this.warningComposite.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    e.gc.setForeground(JFaceColors.getErrorBorder((Display)e.display));
                    e.gc.setBackground(e.display.getSystemColor(29));
                    Rectangle r = ReferencesPreferencePage.this.warningComposite.getBounds();
                    e.gc.fillRoundRectangle(0, 0, r.width - 1, r.height - 1, 10, 10);
                    e.gc.drawRoundRectangle(0, 0, r.width - 1, r.height - 1, 10, 10);
                }
            });
            final Label warning = new Label(this.warningComposite, 0);
            warning.setBackground(this.warningComposite.getDisplay().getSystemColor(29));
            GridDataFactory.swtDefaults().align(1, 128).applyTo((Control)warning);
            warning.setImage(this.warningComposite.getDisplay().getSystemImage(8));
            final Label warningText = new Label(this.warningComposite, 64);
            warningText.setBackground(this.warningComposite.getDisplay().getSystemColor(29));
            GridDataFactory.swtDefaults().align(4, 1).grab(true, false).applyTo((Control)warningText);
            GridLayoutFactory.swtDefaults().margins(10, 10).spacing(10, 10).numColumns(2).applyTo(this.warningComposite);
            GridDataFactory.swtDefaults().align(4, 1).grab(true, false).applyTo((Control)this.warningComposite);
            this.warningComposite.addListener(11, new Listener(){
                boolean reentrant = false;

                public void handleEvent(Event event) {
                    if (!this.reentrant) {
                        this.reentrant = true;
                        int width = ((ReferencesPreferencePage)ReferencesPreferencePage.this).warningComposite.getClientArea().width - warning.getBounds().width;
                        Rectangle rect = warningText.getBounds();
                        rect.width = width;
                        warningText.setBounds(rect);
                        this.reentrant = false;
                    }
                }
            });
            GridDataFactory.fillDefaults().grab(true, false).hint(dsize.x, -1).applyTo((Control)warningText);
            if (warningType == ERROR_TYPE_SUSPENDED) {
                warningText.setText(Messages.errorMsg_LinksIndexerHasBeenSuspended);
            } else if (warningType == ERROR_TYPE_FATALERROR) {
                warningText.setText(Messages.linkIndexerDisabled);
            }
            this.getFieldEditorParent().layout(true);
        }
        if (this.warningShowing && warningType == ERROR_TYPE_NONE) {
            this.warningComposite.dispose();
            this.warningShowing = false;
            this.getFieldEditorParent().layout(true);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        this.instancePrefs.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        boolean result = super.performOk();
        this.instancePrefs.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        return result;
    }

    protected void performApply() {
        super.performApply();
    }

    public void init(IWorkbench workbench) {
    }

    public void handleReferenceEvents(List<ReferenceEvent> events) {
        for (ReferenceEvent referenceEvent : events) {
            if (referenceEvent.getKind() == ReferenceEvent.Kind.FATAL_ERROR) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ReferencesPreferencePage.this.updateWarningSection(ERROR_TYPE_FATALERROR);
                    }
                });
            }
            if (referenceEvent.getKind() != ReferenceEvent.Kind.RESET) continue;
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ReferencesPreferencePage.this.updateWarningSection(ERROR_TYPE_NONE);
                }
            });
        }
    }
}

