/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.ui.internal.preferences;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.ui.internal.nls.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class FilePatternListEditor
extends FieldEditor {
    private Table table;
    private CheckboxTableViewer tableView;
    private Composite buttonBox;
    private Button addButton;
    private Button removeButton;
    private Composite warningcomposite;
    private SelectionListener selectionListener;
    private boolean dirty;
    private Label descriptionValue;
    private Font boldFont;
    private Label descriptionLabel;

    protected FilePatternListEditor() {
    }

    public FilePatternListEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    public void dispose() {
        super.dispose();
        this.boldFont.dispose();
    }

    private void addPressed() {
        InternalAPI.ResourceApprovalEntry[] oldItems = this.getPaths(this.getTable());
        this.setPresentsDefaultValue(false);
        String input = this.getNewInputObject();
        if (input != null) {
            InternalAPI.ResourceApprovalEntry[] resourceApprovalEntryArray = oldItems;
            int n = oldItems.length;
            int n2 = 0;
            while (n2 < n) {
                InternalAPI.ResourceApprovalEntry resourceApprovalEntry = resourceApprovalEntryArray[n2];
                if (resourceApprovalEntry.stringItem != null && resourceApprovalEntry.stringItem.equals(input)) {
                    return;
                }
                ++n2;
            }
            InternalAPI.ResourceApprovalEntry newItem = new InternalAPI.ResourceApprovalEntry();
            newItem.type = 0;
            newItem.stringItem = input;
            newItem.enabled = true;
            this.tableView.add((Object)newItem);
            InternalAPI.ResourceApprovalEntry[] newItems = this.getPaths(this.getTable());
            this.selectionChanged();
            this.fireValueChanged(this.getPreferenceName(), oldItems, newItems);
            this.dirty = true;
            this.updateChecks();
            this.updateWarningSection();
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.table.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    private void createButtons(Composite box) {
        this.addButton = this.createPushButton(box, "ListEditor.add");
        this.removeButton = this.createPushButton(box, "ListEditor.remove");
    }

    private Button createPushButton(Composite parent, String key) {
        Button button = new Button(parent, 8);
        button.setText(JFaceResources.getString((String)key));
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == FilePatternListEditor.this.addButton) {
                    FilePatternListEditor.this.addPressed();
                } else if (widget == FilePatternListEditor.this.removeButton) {
                    FilePatternListEditor.this.removePressed();
                } else if (widget == FilePatternListEditor.this.table) {
                    FilePatternListEditor.this.selectionChanged();
                }
            }
        };
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        this.table = this.getTableControl(parent);
        gd = GridDataFactory.fillDefaults().grab(true, true).create();
        this.table.setLayoutData((Object)gd);
        this.buttonBox = this.getButtonBoxControl(parent);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.buttonBox.setLayoutData((Object)gd);
        Composite twoSpan = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)twoSpan);
        GridLayoutFactory.fillDefaults().extendedMargins(this.convertHorizontalDLUsToPixels((Control)parent, 1), this.convertHorizontalDLUsToPixels((Control)parent, 1), this.convertVerticalDLUsToPixels((Control)parent, 1), this.convertVerticalDLUsToPixels((Control)parent, 10)).numColumns(2).applyTo(twoSpan);
        this.descriptionLabel = new Label(twoSpan, 0);
        this.boldFont = JFaceResources.getDialogFontDescriptor().setStyle(1).createFont((Device)parent.getDisplay());
        this.descriptionLabel.setFont(this.boldFont);
        this.descriptionValue = new Label(twoSpan, 64);
    }

    protected void doLoad() {
        if (this.table != null) {
            this.tableView.setInput((Object)this.getPreferenceStore().getString(this.getPreferenceName()));
            this.updateChecks();
        }
        this.dirty = false;
        this.updateWarningSection();
    }

    protected void doLoadDefault() {
        if (this.table != null) {
            this.tableView.setInput((Object)this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
            this.updateChecks();
        }
        this.dirty = true;
        this.updateWarningSection();
    }

    private void updateChecks() {
        if (this.table != null) {
            ArrayList<InternalAPI.ResourceApprovalEntry> checked = new ArrayList<InternalAPI.ResourceApprovalEntry>();
            TableItem[] items = this.table.getItems();
            int i = 0;
            while (i < items.length) {
                TableItem tableItem = items[i];
                InternalAPI.ResourceApprovalEntry item = (InternalAPI.ResourceApprovalEntry)tableItem.getData();
                if (item.enabled) {
                    checked.add(item);
                }
                ++i;
            }
            this.tableView.setCheckedElements((Object[])checked.toArray(new InternalAPI.ResourceApprovalEntry[checked.size()]));
        }
    }

    private void updateWarningSection() {
        Table list = this.getTable();
        if (list == null) {
            return;
        }
        InternalAPI.ResourceApprovalEntry[] items = this.getPaths(this.getTable());
        boolean hasStar = false;
        InternalAPI.ResourceApprovalEntry[] resourceApprovalEntryArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            InternalAPI.ResourceApprovalEntry string = resourceApprovalEntryArray[n2];
            if (string.stringItem != null && "*".equals(string.stringItem.trim())) {
                hasStar = true;
                break;
            }
            ++n2;
        }
        if (hasStar) {
            if (this.warningcomposite == null) {
                Point dsize = list.getParent().computeSize(-1, -1);
                this.warningcomposite = new Composite(list.getParent(), 0x280000);
                this.warningcomposite.moveBelow((Control)this.removeButton);
                this.warningcomposite.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent e) {
                        e.gc.setForeground(JFaceColors.getErrorBorder((Display)e.display));
                        e.gc.setBackground(e.display.getSystemColor(29));
                        Rectangle r = FilePatternListEditor.this.warningcomposite.getBounds();
                        e.gc.fillRoundRectangle(0, 0, r.width - 1, r.height - 1, 10, 10);
                        e.gc.drawRoundRectangle(0, 0, r.width - 1, r.height - 1, 10, 10);
                    }
                });
                final Label warning = new Label(this.warningcomposite, 0);
                warning.setBackground(this.warningcomposite.getDisplay().getSystemColor(29));
                GridDataFactory.swtDefaults().align(1, 128).applyTo((Control)warning);
                warning.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
                final Label warningText = new Label(this.warningcomposite, 64);
                warningText.setBackground(this.warningcomposite.getDisplay().getSystemColor(29));
                GridDataFactory.swtDefaults().align(4, 1).grab(true, false).applyTo((Control)warningText);
                GridLayoutFactory.swtDefaults().margins(10, 10).spacing(10, 10).numColumns(2).applyTo(this.warningcomposite);
                GridDataFactory.swtDefaults().align(4, 1).grab(true, false).span(3, 1).applyTo((Control)this.warningcomposite);
                this.warningcomposite.addListener(11, new Listener(){
                    boolean reentrant = false;

                    public void handleEvent(Event event) {
                        if (!this.reentrant) {
                            this.reentrant = true;
                            int width = ((FilePatternListEditor)FilePatternListEditor.this).warningcomposite.getClientArea().width - warning.getBounds().width;
                            Rectangle rect = warningText.getBounds();
                            rect.width = width;
                            warningText.setBounds(rect);
                            this.reentrant = false;
                        }
                    }
                });
                GridDataFactory.fillDefaults().grab(true, false).hint(dsize.x, -1).applyTo((Control)warningText);
                warningText.setText(Messages.warning_for_asterisk);
                this.warningcomposite.getParent().layout(true);
            }
        } else {
            if (this.warningcomposite != null) {
                this.warningcomposite.dispose();
                this.warningcomposite = null;
            }
            list.getParent().layout();
        }
    }

    protected void doStore() {
        InternalAPI.ResourceApprovalEntry[] items = this.getPaths(this.getTable());
        String s = InternalAPI.serializeResourceApprovalPrefs((InternalAPI.ResourceApprovalEntry[])items);
        if (s != null) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), s);
        }
    }

    public void store() {
        super.store();
        this.dirty = false;
    }

    public Composite getButtonBoxControl(Composite parent) {
        if (this.buttonBox == null) {
            this.buttonBox = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.buttonBox.setLayout((Layout)layout);
            this.createButtons(this.buttonBox);
            this.buttonBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    FilePatternListEditor.this.addButton = null;
                    FilePatternListEditor.this.removeButton = null;
                    FilePatternListEditor.this.buttonBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.buttonBox, parent);
        }
        this.selectionChanged();
        return this.buttonBox;
    }

    public Table getTableControl(Composite parent) {
        if (this.table == null) {
            this.table = new Table(parent, 68384);
            this.table.setFont(parent.getFont());
            this.table.addSelectionListener(this.getSelectionListener());
            this.table.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    FilePatternListEditor.this.table = null;
                }
            });
            final TableColumn col1 = new TableColumn(this.table, 16384);
            this.table.addControlListener(new ControlListener(){

                public void controlResized(ControlEvent e) {
                    col1.setWidth(((FilePatternListEditor)FilePatternListEditor.this).table.getClientArea().width);
                }

                public void controlMoved(ControlEvent e) {
                }
            });
            this.tableView = new CheckboxTableViewer(this.table);
            this.tableView.setAllChecked(true);
            DecoratingStyledCellLabelProvider decorated = new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ListLabelProvider(), null, null);
            this.tableView.setLabelProvider((IBaseLabelProvider)decorated);
            this.tableView.setContentProvider((IContentProvider)new ListContentProvider());
            this.tableView.setSorter(new ViewerSorter(){

                public int category(Object element) {
                    InternalAPI.ResourceApprovalEntry l = (InternalAPI.ResourceApprovalEntry)element;
                    return l.type;
                }

                public int compare(Viewer viewer, Object e1, Object e2) {
                    InternalAPI.ResourceApprovalEntry l1 = (InternalAPI.ResourceApprovalEntry)e1;
                    InternalAPI.ResourceApprovalEntry l2 = (InternalAPI.ResourceApprovalEntry)e2;
                    return l1.stringItem.compareTo(l2.stringItem);
                }
            });
            this.tableView.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    FilePatternListEditor.this.selectionChanged();
                }
            });
            this.tableView.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    InternalAPI.ResourceApprovalEntry item = (InternalAPI.ResourceApprovalEntry)event.getElement();
                    item.enabled = event.getChecked();
                    InternalAPI.ResourceApprovalEntry[] newItems = FilePatternListEditor.this.getPaths(FilePatternListEditor.this.getTable());
                    FilePatternListEditor.this.fireValueChanged(FilePatternListEditor.this.getPreferenceName(), newItems, newItems);
                }
            });
        } else {
            this.checkParent((Control)this.table, parent);
        }
        return this.table;
    }

    protected Table getTable() {
        return this.table;
    }

    public int getNumberOfControls() {
        return 2;
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    protected Shell getShell() {
        if (this.addButton == null) {
            return null;
        }
        return this.addButton.getShell();
    }

    private InternalAPI.ResourceApprovalEntry[] getPaths(Table table) {
        TableItem[] items = table.getItems();
        ArrayList<InternalAPI.ResourceApprovalEntry> resourceApprovalEntries = new ArrayList<InternalAPI.ResourceApprovalEntry>();
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem i = tableItemArray[n2];
            InternalAPI.ResourceApprovalEntry item = (InternalAPI.ResourceApprovalEntry)i.getData();
            resourceApprovalEntries.add(item);
            ++n2;
        }
        return resourceApprovalEntries.toArray(new InternalAPI.ResourceApprovalEntry[resourceApprovalEntries.size()]);
    }

    private void removePressed() {
        this.setPresentsDefaultValue(false);
        InternalAPI.ResourceApprovalEntry[] oldItems = this.getPaths(this.getTable());
        int[] indexs = this.table.getSelectionIndices();
        if (indexs.length > 0) {
            this.table.remove(indexs);
            this.dirty = true;
            this.selectionChanged();
            InternalAPI.ResourceApprovalEntry[] newItems = this.getPaths(this.getTable());
            this.fireValueChanged(this.getPreferenceName(), oldItems, newItems);
        }
        this.updateWarningSection();
    }

    private void selectionChanged() {
        boolean removeButtonEnabled;
        int index = this.table.getSelectionIndex();
        boolean bl = removeButtonEnabled = index >= 0;
        if (index >= 0) {
            this.descriptionLabel.setText(Messages.description);
            InternalAPI.ResourceApprovalEntry item = (InternalAPI.ResourceApprovalEntry)this.table.getItem(index).getData();
            if (item.type == 0) {
                Point dsize = this.descriptionValue.getParent().computeSize(-1, -1);
                GridDataFactory.fillDefaults().grab(true, false).hint(dsize.x, -1).applyTo((Control)this.descriptionValue);
                this.descriptionValue.setText(NLS.bind((String)Messages.ignores_resources_matching_x, (Object)InternalAPI.getStringMatterText((String)item.stringItem)));
                this.descriptionValue.getParent().layout();
            } else {
                this.descriptionValue.setText(InternalAPI.getApproverDescription((String)item.approverId));
                this.descriptionValue.getParent().layout();
                removeButtonEnabled = false;
            }
        } else {
            if (this.descriptionLabel != null) {
                this.descriptionLabel.setText("");
                this.descriptionLabel.getParent().layout();
            }
            if (this.descriptionValue != null) {
                this.descriptionValue.setText("");
                this.descriptionValue.getParent().layout();
            }
        }
        this.removeButton.setEnabled(removeButtonEnabled);
    }

    public void setFocus() {
        if (this.table != null) {
            this.table.setFocus();
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getTableControl(parent).setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
    }

    protected String getNewInputObject() {
        InputDialog dialog = new InputDialog(this.getShell(), Messages.addignorepattern, Messages.enternameorpathpattern, null, null){

            protected Control createDialogArea(Composite parent) {
                Control control = super.createDialogArea(parent);
                this.getText().addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        String text = this.getText().getText();
                        if ("enabledebug".equalsIgnoreCase(text)) {
                            Shell s = this.getShell();
                            InternalAPI.Tweaks.ENABLE_DEBUG_OVERRIDE = true;
                            MessageDialog.openInformation((Shell)s, (String)"Debug", (String)"Debug enabled");
                            this.cancelPressed();
                        } else if ("credits".equalsIgnoreCase(text)) {
                            Shell s = this.getShell();
                            MessageDialog.openInformation((Shell)s, (String)"Credits", (String)"The indexer framework was developed by Min Idzelis.");
                        }
                    }
                });
                return control;
            }
        };
        int o = dialog.open();
        if (o == 0) {
            return dialog.getValue().trim();
        }
        return null;
    }

    private class ListContentProvider
    implements IStructuredContentProvider {
        private ListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<InternalAPI.ResourceApprovalEntry> items = new ArrayList<InternalAPI.ResourceApprovalEntry>(Arrays.asList(InternalAPI.deserializeResourceApprovalPrefs((String)((String)inputElement))));
            return items.toArray(new InternalAPI.ResourceApprovalEntry[items.size()]);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class ListLabelProvider
    implements ILabelProvider,
    DelegatingStyledCellLabelProvider.IStyledLabelProvider,
    IColorProvider {
        private ListLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            InternalAPI.ResourceApprovalEntry resourceApprovalEntry = (InternalAPI.ResourceApprovalEntry)element;
            if (resourceApprovalEntry.type == 0) {
                return TextProcessor.process((String)resourceApprovalEntry.stringItem);
            }
            if (resourceApprovalEntry.type == 1) {
                return InternalAPI.getApproverName((String)resourceApprovalEntry.approverId);
            }
            Assert.isLegal((boolean)false, (String)"Unsupported element");
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public StyledString getStyledText(Object element) {
            InternalAPI.ResourceApprovalEntry resourceApprovalEntry = (InternalAPI.ResourceApprovalEntry)element;
            if (resourceApprovalEntry.type == 0) {
                return new StyledString(this.getText(element));
            }
            if (resourceApprovalEntry.type == 1) {
                String name = this.getText(element);
                return new StyledString(name, new StyledString.Styler(){

                    public void applyStyles(TextStyle textStyle) {
                        textStyle.background = FilePatternListEditor.this.getShell().getDisplay().getSystemColor(29);
                    }
                });
            }
            return null;
        }

        public Color getBackground(Object element) {
            InternalAPI.ResourceApprovalEntry resourceApprovalEntry = (InternalAPI.ResourceApprovalEntry)element;
            if (resourceApprovalEntry.type == 1) {
                return FilePatternListEditor.this.getShell().getDisplay().getSystemColor(29);
            }
            return null;
        }

        public Color getForeground(Object element) {
            return null;
        }
    }
}

