/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.ui.internal.hyperlink;

import com.ibm.etools.references.management.BrokenStatus;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.SpecializedType;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.ui.AbstractOpenAdapter;
import com.ibm.etools.references.ui.internal.hyperlink.HyperlinkOpenAdapterRegistry;
import com.ibm.etools.references.ui.internal.nls.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;

public class ReferenceHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        try {
            IDocument doc = textViewer.getDocument();
            ITextFileBuffer buffer = ITextFileBufferManager.DEFAULT.getTextFileBuffer(doc);
            if (buffer != null) {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(buffer.getLocation());
                IPath path = file.getFullPath();
                String ext = path.getFileExtension();
                if (ext != null && "JAVA".equals(ext.toUpperCase())) {
                    return null;
                }
                ReferenceManager.getReferenceManager().userInitiatedAccess();
                SearchEngine.setSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
                LinkNode node = ReferenceManager.getReferenceManager().getLinkNode(file);
                Collection links = node.getLinks(null, SpecializedType.Depth.ZERO, null);
                ArrayList<IResolvedReference> targets = new ArrayList<IResolvedReference>();
                for (ILink link : links) {
                    if (!link.getLinkLocation().contains(region.getOffset())) continue;
                    List refs = link.getReferenceTypes();
                    for (String refType : refs) {
                        Collection references = link.resolveReference(refType, null);
                        for (IResolvedReference resolvedReference : references) {
                            TextRange absoluteFragmentLocation;
                            IResolvedReference rr = resolvedReference;
                            if (!refType.equals(rr.getReferenceType()) || !EnumSet.of(BrokenStatus.NOTBROKEN, BrokenStatus.IGNORED).contains(rr.getBrokenStatus()) || rr.getTarget() == null || (absoluteFragmentLocation = rr.getAbsoluteFragmentLocation()) == null || !absoluteFragmentLocation.contains(region.getOffset()) || this.exists(targets, rr)) continue;
                            targets.add(rr);
                        }
                    }
                }
                if (!targets.isEmpty()) {
                    ArrayList<WebHyperlink> thelinks = new ArrayList<WebHyperlink>();
                    if (canShowMultipleHyperlinks) {
                        for (IResolvedReference resolvedReference : targets) {
                            thelinks.add(new WebHyperlink(textViewer.getTextWidget(), Collections.singletonList(resolvedReference)));
                        }
                        Collections.sort(thelinks);
                        IHyperlink[] iHyperlinkArray = thelinks.toArray(new IHyperlink[thelinks.size()]);
                        return iHyperlinkArray;
                    }
                    IHyperlink[] iHyperlinkArray = new IHyperlink[]{new WebHyperlink(textViewer.getTextWidget(), targets)};
                    return iHyperlinkArray;
                }
            }
        }
        catch (ReferenceException referenceException) {
        }
        finally {
            SearchEngine.clearSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
        }
        return null;
    }

    private boolean exists(List<IResolvedReference> targets, IResolvedReference rr) {
        for (IResolvedReference r : targets) {
            if (r.getTarget() != rr.getTarget()) continue;
            return true;
        }
        return false;
    }

    private void gotoMarker(ILink target, IEditorPart part) throws CoreException {
        if (part != null && target.getContainer() != null) {
            IMarker marker = target.getContainer().getResource().createMarker("org.eclipse.core.resources.textmarker");
            TextRange location = target.getContextLocation();
            if (location != null) {
                marker.setAttribute("charStart", location.getOffset());
                marker.setAttribute("charEnd", location.getOffset() + location.getLength());
                IGotoMarker gotom = (IGotoMarker)part.getAdapter(IGotoMarker.class);
                if (gotom != null) {
                    gotom.gotoMarker(marker);
                }
            }
        }
    }

    protected void openTargetLink(ILink target) {
        IFile file;
        AbstractOpenAdapter openAdapter = HyperlinkOpenAdapterRegistry.getOpenAdapter(target.getSpecializedType().getId());
        if (openAdapter != null) {
            try {
                IEditorPart part = openAdapter.openLink(target);
                this.gotoMarker(target, part);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (target.getContainer() == null) {
            return;
        }
        IResource resource = target.getContainer().getResource();
        IFile iFile = file = resource.getType() == 1 ? (IFile)resource : null;
        if (file != null) {
            IEditorPart part = null;
            try {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorDescriptor desc = IDE.getEditorDescriptor((IFile)file);
                if (desc.isInternal()) {
                    part = page.openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
                    this.gotoMarker(target, part);
                } else {
                    part = page.openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public class MultiTooltip
    extends ToolTip {
        private final List<WebHyperlinkDisplayElement> targetsContainers;
        FormToolkit toolkit;

        public MultiTooltip(Control control, List<WebHyperlinkDisplayElement> targetsContainers) {
            super(control, 2, true);
            this.toolkit = null;
            this.setHideOnMouseDown(false);
            this.targetsContainers = targetsContainers;
            Collections.sort(this.targetsContainers);
        }

        protected void afterHideToolTip(Event event) {
            super.afterHideToolTip(event);
            if (this.toolkit != null) {
                this.toolkit.dispose();
            }
        }

        protected Composite createToolTipContentArea(Event event, Composite parent) {
            this.toolkit = new FormToolkit(parent.getDisplay());
            this.toolkit.setBackground(parent.getDisplay().getSystemColor(29));
            Composite c = this.toolkit.createComposite(parent);
            c.setLayout((Layout)new GridLayout());
            this.toolkit.createLabel(c, Messages.hyperlinks_multiple_targets);
            HashMap<IPath, Integer> paths = new HashMap<IPath, Integer>();
            for (WebHyperlinkDisplayElement tc : this.targetsContainers) {
                IPath p = tc.getResolvedReference().getTarget().getPath();
                Integer i = (Integer)paths.get(p);
                if (i == null) {
                    paths.put(p, 1);
                    continue;
                }
                int inc = i + 1;
                paths.put(p, inc);
            }
            for (WebHyperlinkDisplayElement tc : this.targetsContainers) {
                final ILink target = tc.getResolvedReference().getTarget();
                String text = tc.getHyperlinkText();
                Hyperlink link = this.toolkit.createHyperlink(c, text, 0);
                link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        ReferenceHyperlinkDetector.this.openTargetLink(target);
                        MultiTooltip.this.hide();
                    }
                });
            }
            return parent;
        }
    }

    public class WebHyperlink
    implements IHyperlink,
    Comparable<WebHyperlink> {
        private final List<WebHyperlinkDisplayElement> targetsContainers;
        private final StyledText display;

        public WebHyperlink(StyledText styledText, List<IResolvedReference> targets) {
            this.display = styledText;
            this.targetsContainers = new ArrayList<WebHyperlinkDisplayElement>();
            for (IResolvedReference r : targets) {
                this.targetsContainers.add(new WebHyperlinkDisplayElement(r));
            }
        }

        public IRegion getHyperlinkRegion() {
            IResolvedReference rr = this.targetsContainers.get(0).getResolvedReference();
            if (rr == null) {
                return new Region(0, 0);
            }
            return new Region(rr.getFragmentLocation().getOffset() + rr.getSource().getLinkLocation().getOffset(), rr.getFragmentLocation().getLength());
        }

        public String getHyperlinkText() {
            if (this.targetsContainers.size() == 1) {
                String text = this.targetsContainers.iterator().next().getHyperlinkText();
                text = NLS.bind((String)Messages.open_target, (Object)text);
                return text;
            }
            return Messages.hyperlinks_goto_target;
        }

        public String getTypeLabel() {
            return Messages.hyperlinks_web_hyperlink;
        }

        public void open() {
            if (this.targetsContainers.size() == 1) {
                ILink target = this.targetsContainers.get(0).getResolvedReference().getTarget();
                ReferenceHyperlinkDetector.this.openTargetLink(target);
            } else {
                MultiTooltip tip = new MultiTooltip((Control)this.display, this.targetsContainers);
                tip.show(this.display.toControl(this.display.getDisplay().getCursorLocation()));
            }
        }

        @Override
        public int compareTo(WebHyperlink o) {
            if (this.targetsContainers.size() == 1 && o.targetsContainers.size() == 1) {
                return this.targetsContainers.iterator().next().compareTo(o.targetsContainers.iterator().next());
            }
            return 0;
        }
    }

    private class WebHyperlinkDisplayElement
    implements Comparable<WebHyperlinkDisplayElement> {
        private final IResolvedReference resolvedReference;

        public WebHyperlinkDisplayElement(IResolvedReference resolvedReference) {
            this.resolvedReference = resolvedReference;
        }

        public String getHyperlinkText() {
            ILink target = this.resolvedReference.getTarget();
            IPath p = target.getPath();
            String text = p.toString();
            if (target.getName() != null && target.getName().trim().length() > 0) {
                text = target.getName();
            }
            return text;
        }

        public IResolvedReference getResolvedReference() {
            return this.resolvedReference;
        }

        @Override
        public int compareTo(WebHyperlinkDisplayElement arg0) {
            return this.getHyperlinkText().compareTo(arg0.getHyperlinkText());
        }

        public boolean equals(Object obj) {
            if (obj instanceof WebHyperlinkDisplayElement) {
                WebHyperlinkDisplayElement otherWHDE = (WebHyperlinkDisplayElement)obj;
                return this.resolvedReference.getTarget() == otherWHDE.getResolvedReference().getTarget();
            }
            return false;
        }

        public int hashCode() {
            return this.resolvedReference.getTarget().hashCode();
        }

        public String toString() {
            return this.getHyperlinkText();
        }
    }
}

