/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.ui.internal.filebuffers;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.TextRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;

public class LinkPosition
extends Position {
    private final ILink link;
    private final boolean context;
    private final IDocument doc;

    public LinkPosition(int offset, int length, ILink link, boolean context, IDocument doc) {
        super(offset, length);
        this.link = link;
        this.context = context;
        this.doc = doc;
    }

    public int getLinkId() {
        return this.link.getId();
    }

    public ILink getLink() {
        return this.link;
    }

    public boolean isContext() {
        return this.context;
    }

    public TextRange toTextRange() throws BadLocationException {
        int lines = this.doc.getNumberOfLines(0, this.getOffset() + this.getLength());
        return new TextRange(this.getOffset(), this.getLength(), lines);
    }

    public String getText() throws BadLocationException {
        return this.doc.get(this.getOffset(), this.getLength());
    }

    public String toString() {
        try {
            return "[" + this.getText() + "] (" + this.toTextRange().getLinenumber() + ":" + this.offset + ":" + this.length + ") isContext: " + this.isContext();
        }
        catch (BadLocationException badLocationException) {
            return "Bad location exception (" + this.offset + ":" + this.length + ")";
        }
    }
}

