/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.ui.internal.filebuffers;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.Logger;
import com.ibm.etools.references.events.IReferenceListener;
import com.ibm.etools.references.events.ReferenceEvent;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.LinkPositionInfo;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.ResourceChange;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchRequestor;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.ui.internal.annotations.AnnotationUpdater;
import com.ibm.etools.references.ui.internal.filebuffers.LinkPosition;
import com.ibm.etools.references.ui.internal.filebuffers.ThreadSafePositionUpdater;
import com.ibm.etools.references.ui.internal.nls.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.DocumentRewriteSessionEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentRewriteSessionListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.MultiEditorInput;

public class FileBufferListener
extends InternalAPI.AbstractAnnotationModelDocumentProvider {
    private static final String LINK_POSITION_CATEGORY = "linkPositionCategory";
    private static final ReferenceManager MANAGER = ReferenceManager.getReferenceManager();
    private final FileBufListener listener = new FileBufListener();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock read = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock write = this.lock.writeLock();
    private final HashMap<IDocument, DocListener> docToListenerMap = new HashMap();
    private final HashMap<IDocument, ITextFileBuffer> docToBufferMap = new HashMap();
    private final HashMap<IDocument, Long> docToLastChangeMap = new HashMap();
    private final HashMap<IFile, TrackingInfo> tracking = new HashMap();
    private final AddToProcessingQueue addToProcessingQueue = new AddToProcessingQueue();
    private final InternalAPI.ReferencesJob fileBufferListenerJob = new InternalAPI.ReferencesJob(new Runnable(){

        @Override
        public void run() {
            FileBufferListener.this.requestReIndexing(null, false);
        }
    });
    private final AnnotationUpdater updater;

    void scheduleReIndexing() {
        this.fileBufferListenerJob.schedule(750L, TimeUnit.MILLISECONDS);
    }

    public void clearChanges(IProgressMonitor monitor) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        mon.subTask(Messages.FileBufferListener_RemovePendingIndexRequests);
        this.fileBufferListenerJob.cancelJoin();
        try {
            this.write.lock();
            this.docToBufferMap.clear();
        }
        finally {
            this.write.unlock();
        }
    }

    void requestReIndexing(IProgressMonitor monitor, boolean flush) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (flush) {
            this.fileBufferListenerJob.cancelJoin();
        }
        boolean proceed = true;
        while (proceed) {
            List<Info> refreshList = this.processLoop(flush, mon);
            if (Thread.interrupted()) {
                return;
            }
            ArrayList<ResourceChange> changes = new ArrayList<ResourceChange>(refreshList.size());
            Iterator<Info> iterator = refreshList.iterator();
            while (iterator.hasNext()) {
                IFile file = iterator.next().file;
                changes.add(new ResourceChange((IResource)file, 4));
            }
            MANAGER.requestChangeAnalysis(changes, (IProgressMonitor)mon.newChild(1));
            if (!flush) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
            boolean bl = proceed = !this.isEmpty();
        }
    }

    private boolean isEmpty() {
        boolean empty;
        try {
            this.write.lock();
            empty = this.docToLastChangeMap.isEmpty();
        }
        finally {
            this.write.unlock();
        }
        return empty;
    }

    private List<Info> processLoop(boolean flush, SubMonitor mon) {
        ArrayList<Info> docsToRefresh = new ArrayList<Info>();
        try {
            this.write.lock();
            SubMonitor part1 = mon.newChild(1);
            part1.beginTask("", this.docToLastChangeMap.size());
            if (!this.docToLastChangeMap.isEmpty()) {
                if (flush) {
                    part1.subTask(Messages.FileBufferListener_FlushPendingIndexRequests);
                } else {
                    part1.subTask(Messages.FileBufferListener_IndexOpenDocuments);
                }
            }
            Iterator<Map.Entry<IDocument, Long>> itr = this.docToLastChangeMap.entrySet().iterator();
            while (itr.hasNext()) {
                boolean processEntry;
                Map.Entry<IDocument, Long> entry = itr.next();
                if (flush) {
                    processEntry = true;
                } else {
                    long lastEdit;
                    long current = System.currentTimeMillis();
                    boolean bl = processEntry = current - (lastEdit = entry.getValue().longValue()) > 1000L;
                }
                if (processEntry) {
                    IPath path;
                    IDocument doc = entry.getKey();
                    IFileBuffer buf = (IFileBuffer)this.docToBufferMap.get(doc);
                    if (buf != null && (path = buf.getLocation()) != null) {
                        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                        Info i = new Info();
                        i.file = file;
                        docsToRefresh.add(i);
                    }
                    itr.remove();
                }
                part1.worked(1);
            }
        }
        finally {
            this.write.unlock();
        }
        return docsToRefresh;
    }

    public FileBufferListener(AnnotationUpdater updater) {
        this.updater = updater;
        DocListener.class.getName();
        updater.setFileBufferListener(this);
    }

    private IDocument getMatchingDoc(IFileBuffer fileBuffer, IFile file) {
        if (fileBuffer instanceof ITextFileBuffer) {
            IFileStore store = ((ITextFileBuffer)fileBuffer).getFileStore();
            if (fileBuffer.getLocation() != null && store.toURI().equals(file.getLocationURI())) {
                return ((ITextFileBuffer)fileBuffer).getDocument();
            }
        }
        return null;
    }

    public List<LinkPositionInfo> getActivePositions(IFile file) {
        IFileBuffer[] buffers = ITextFileBufferManager.DEFAULT.getFileBuffers();
        IDocument doc = null;
        IFileBuffer[] iFileBufferArray = buffers;
        int n = buffers.length;
        int n2 = 0;
        while (n2 < n) {
            IFileBuffer fileBuffer = iFileBufferArray[n2];
            doc = this.getMatchingDoc(fileBuffer, file);
            if (doc != null) break;
            ++n2;
        }
        if (doc != null) {
            List<LinkPositionInfo> linkpos = this.createPositionInfo(doc);
            return linkpos;
        }
        return Collections.emptyList();
    }

    List<LinkPositionInfo> createPositionInfo(IDocument doc) {
        ThreadSafePositionUpdater updater = null;
        List<String> cats = Arrays.asList(doc.getPositionCategories());
        if (cats.contains(LINK_POSITION_CATEGORY)) {
            long newStamp;
            long fModificationStamp;
            long updateCount;
            long newCount;
            IPositionUpdater[] updaters;
            IPositionUpdater[] iPositionUpdaterArray = updaters = doc.getPositionUpdaters();
            int n = updaters.length;
            int n2 = 0;
            while (n2 < n) {
                IPositionUpdater positionUpdater = iPositionUpdaterArray[n2];
                if (positionUpdater instanceof ThreadSafePositionUpdater) {
                    updater = (ThreadSafePositionUpdater)positionUpdater;
                    break;
                }
                ++n2;
            }
            if (updater == null) {
                return Collections.emptyList();
            }
            List<LinkPositionInfo> linkpos = null;
            do {
                updateCount = updater.getUpdateCount();
                fModificationStamp = 0L;
                if (doc instanceof IDocumentExtension4) {
                    fModificationStamp = ((IDocumentExtension4)doc).getModificationStamp();
                }
                ArrayList<LinkPosition> positions = new ArrayList<LinkPosition>();
                try {
                    Position[] pos = doc.getPositions(LINK_POSITION_CATEGORY);
                    LinkPosition[] links = new LinkPosition[pos.length];
                    System.arraycopy(pos, 0, links, 0, pos.length);
                    positions.addAll(Arrays.asList(links));
                }
                catch (BadPositionCategoryException badPositionCategoryException) {}
                linkpos = this.retrievePositionInfos(positions);
            } while ((newCount = updater.getUpdateCount()) != updateCount || doc instanceof IDocumentExtension4 && fModificationStamp != (newStamp = ((IDocumentExtension4)doc).getModificationStamp()));
            return linkpos;
        }
        return Collections.emptyList();
    }

    private List<LinkPositionInfo> retrievePositionInfos(List<LinkPosition> pos) {
        PosInfoCompare compare = new PosInfoCompare();
        Collections.sort(pos, compare);
        ArrayList<LinkPositionInfo> linkpos = new ArrayList<LinkPositionInfo>();
        LinkPosition last = null;
        Iterator<LinkPosition> iterator = pos.iterator();
        while (iterator.hasNext()) {
            LinkPositionInfo info;
            if (last == null) {
                last = iterator.next();
                if (!last.isDeleted()) continue;
                break;
            }
            LinkPosition current = iterator.next();
            if (current.isDeleted()) break;
            if (current.getLinkId() == last.getLinkId()) {
                try {
                    info = new LinkPositionInfo(current.toTextRange(), current.getText(), last.toTextRange(), last.getText(), last.getLink());
                    linkpos.add(info);
                }
                catch (BadLocationException badLocationException) {}
                last = null;
                continue;
            }
            if (last.isContext()) {
                try {
                    info = new LinkPositionInfo(TextRange.EMPTY, last.getLink().getLinkText(), last.toTextRange(), last.getText(), last.getLink());
                    linkpos.add(info);
                }
                catch (BadLocationException badLocationException) {}
            }
            last = current;
        }
        return linkpos;
    }

    public void flushChanges(IProgressMonitor monitor) {
        this.addToProcessingQueue.schedule(true, true);
        this.requestReIndexing(monitor, true);
    }

    public void connect() {
        ITextFileBufferManager.DEFAULT.addFileBufferListener((IFileBufferListener)this.listener);
    }

    public void disconnect() {
        ITextFileBufferManager.DEFAULT.removeFileBufferListener((IFileBufferListener)this.listener);
        this.flushChanges(null);
    }

    private Item newItem(IFileBuffer buffer, int kind, boolean dirty) {
        Item item = new Item();
        item.isDirty = dirty;
        item.buffer = buffer;
        item.document = ((ITextFileBuffer)buffer).getDocument();
        item.kind = kind;
        item.timestamp = System.currentTimeMillis();
        return item;
    }

    public InternalAPI.AnnotationModelDocumentPair getAnnotationModel(IFile resource) {
        return this.getAnnotationModel(resource, true);
    }

    public InternalAPI.AnnotationModelDocumentPair getAnnotationModel(IFile resource, boolean doFlush) {
        if (doFlush) {
            this.addToProcessingQueue.schedule(true, true);
        }
        try {
            this.read.lock();
            for (Map.Entry<IDocument, ITextFileBuffer> entry : this.docToBufferMap.entrySet()) {
                try {
                    ITextFileBuffer buffer = entry.getValue();
                    IPath location = buffer.getLocation();
                    if (location == null || !location.equals((Object)resource.getFullPath())) continue;
                    IAnnotationModel model = buffer.getAnnotationModel();
                    InternalAPI.AnnotationModelDocumentPair pair = new InternalAPI.AnnotationModelDocumentPair();
                    pair.setAnnotationModel(model);
                    pair.setDocument(entry.getKey());
                    pair.setBuffer(buffer);
                    InternalAPI.AnnotationModelDocumentPair annotationModelDocumentPair = pair;
                    return annotationModelDocumentPair;
                }
                catch (RuntimeException e) {
                    Status status = new Status(2, "com.ibm.etools.references.ui", Messages.errorMsg_FileBufferListener_unexpectederror, (Throwable)e);
                    Logger.log((Logger.Category)Logger.Category.DEBUG, (Logger.Severity)Logger.Severity.WARNING, (Logger.Mode)Logger.Mode.DEV_MANDATORY, (IStatus)status);
                }
            }
        }
        finally {
            this.read.unlock();
        }
        return null;
    }

    public List<IAnnotationModel> getAllAnotationModels() {
        ArrayList<IAnnotationModel> models = new ArrayList<IAnnotationModel>();
        try {
            this.read.lock();
            Collection<ITextFileBuffer> buffers = this.docToBufferMap.values();
            for (ITextFileBuffer buffer : buffers) {
                try {
                    IAnnotationModel model = buffer.getAnnotationModel();
                    if (model == null) continue;
                    models.add(model);
                }
                catch (RuntimeException e) {
                    Status status = new Status(2, "com.ibm.etools.references.ui", Messages.errorMsg_FileBufferListener_unexpectederror, (Throwable)e);
                    Logger.log((Logger.Category)Logger.Category.DEBUG, (Logger.Severity)Logger.Severity.WARNING, (Logger.Mode)Logger.Mode.DEV_MANDATORY, (IStatus)status);
                }
            }
        }
        finally {
            this.read.unlock();
        }
        return models;
    }

    public boolean hasAnnotationsModels() {
        try {
            this.read.lock();
            boolean bl = !this.docToBufferMap.isEmpty();
            return bl;
        }
        finally {
            this.read.unlock();
        }
    }

    private void beginTrackingFile(IFile file) {
        if (file == null) {
            return;
        }
        try {
            IContentType type;
            IContentDescription desc = file.getContentDescription();
            if (desc != null && (type = desc.getContentType()) != null && "org.eclipse.jdt.core.javaSource".equals(type.getId())) {
                return;
            }
        }
        catch (CoreException coreException) {}
        try {
            this.write.lock();
            TrackingInfo info = this.tracking.get(file);
            if (info == null) {
                IFileBuffer[] buffers;
                info = new TrackingInfo();
                info.count = 1;
                boolean found = false;
                IFileBuffer[] iFileBufferArray = buffers = ITextFileBufferManager.DEFAULT.getFileBuffers();
                int n = buffers.length;
                int n2 = 0;
                while (n2 < n) {
                    IFileBuffer fileBuffer = iFileBufferArray[n2];
                    IDocument doc = this.getMatchingDoc(fileBuffer, file);
                    if (doc != null) {
                        info.buffer = fileBuffer;
                        found = true;
                        break;
                    }
                    ++n2;
                }
                if (!found) {
                    IFileBuffer[] fileStoreBuffers;
                    IFileBuffer[] iFileBufferArray2 = fileStoreBuffers = ITextFileBufferManager.DEFAULT.getFileStoreFileBuffers();
                    int n3 = fileStoreBuffers.length;
                    n = 0;
                    while (n < n3) {
                        IFileBuffer fileBuffer = iFileBufferArray2[n];
                        IDocument doc = this.getMatchingDoc(fileBuffer, file);
                        if (doc != null) {
                            info.buffer = fileBuffer;
                            found = true;
                            break;
                        }
                        ++n;
                    }
                }
                if (found) {
                    this.tracking.put(file, info);
                    this.addToProcessingQueue.addItem(this.newItem(info.buffer, 1, false));
                }
            } else {
                ++info.count;
            }
        }
        finally {
            this.write.unlock();
        }
    }

    private void endTrackingFile(IFile file) {
        try {
            this.write.lock();
            TrackingInfo info = this.tracking.get(file);
            if (info != null) {
                --info.count;
                if (info.count <= 0) {
                    this.tracking.remove(file);
                    this.addToProcessingQueue.addItem(this.newItem(info.buffer, 2, false));
                }
            }
        }
        finally {
            this.write.unlock();
        }
    }

    public void editorOpened(IEditorPart part) {
        IEditorInput input = part.getEditorInput();
        if (input instanceof MultiEditorInput) {
            IEditorInput[] inputs;
            MultiEditorInput multi = (MultiEditorInput)input;
            IEditorInput[] iEditorInputArray = inputs = multi.getInput();
            int n = inputs.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorInput editorInput = iEditorInputArray[n2];
                IFile file = ResourceUtil.getFile((IEditorInput)editorInput);
                this.beginTrackingFile(file);
                ++n2;
            }
        } else {
            IFile file = ResourceUtil.getFile((IEditorInput)part.getEditorInput());
            this.beginTrackingFile(file);
        }
    }

    public void editorClosed(IEditorPart part) {
        IEditorInput input = part.getEditorInput();
        if (input instanceof MultiEditorInput) {
            IEditorInput[] inputs;
            MultiEditorInput multi = (MultiEditorInput)input;
            IEditorInput[] iEditorInputArray = inputs = multi.getInput();
            int n = inputs.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorInput editorInput = iEditorInputArray[n2];
                IFile file = ResourceUtil.getFile((IEditorInput)editorInput);
                this.endTrackingFile(file);
                ++n2;
            }
        } else {
            IFile file = ResourceUtil.getFile((IEditorInput)part.getEditorInput());
            this.endTrackingFile(file);
        }
    }

    class AddToProcessingQueue
    implements Runnable {
        private final AtomicInteger mySize = new AtomicInteger(0);
        private final ConcurrentLinkedQueue<Item> itemQueue = new ConcurrentLinkedQueue();
        private final InternalAPI.ReferencesJob procQueueJob = new InternalAPI.ReferencesJob((Runnable)this);

        public boolean addItem(Item item) {
            return !this.addItems(Collections.singleton(item)).isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<Item> addItems(Collection<Item> items) {
            Collection<Item> newItems;
            HashSet<IDocument> canceledDocs = new HashSet<IDocument>();
            boolean doSchedule = false;
            AddToProcessingQueue addToProcessingQueue = this;
            synchronized (addToProcessingQueue) {
                boolean justDirty = true;
                for (Item item : items) {
                    justDirty &= item.kind == 3;
                }
                if (justDirty) {
                    newItems = items;
                } else {
                    ArrayList<Item> canceledOutItems = new ArrayList<Item>();
                    for (Item qItem : this.itemQueue) {
                        if (qItem.kind != 1) continue;
                        for (Item item : items) {
                            if (item.kind != 2 || qItem.document != item.document) continue;
                            canceledOutItems.add(item);
                            canceledDocs.add(qItem.document);
                        }
                    }
                    newItems = new ArrayList<Item>(items);
                    newItems.removeAll(canceledOutItems);
                    Iterator<Item> iterator = this.itemQueue.iterator();
                    while (iterator.hasNext()) {
                        Item qItem;
                        qItem = iterator.next();
                        if (!canceledDocs.contains(qItem.document)) continue;
                        iterator.remove();
                    }
                }
                this.itemQueue.addAll(newItems);
                this.mySize.addAndGet(newItems.size());
                doSchedule = !this.itemQueue.isEmpty();
            }
            if (!canceledDocs.isEmpty()) {
                try {
                    FileBufferListener.this.write.lock();
                    for (IDocument document : canceledDocs) {
                        this.endTrackingDocument(document);
                    }
                }
                finally {
                    FileBufferListener.this.write.unlock();
                }
            }
            if (doSchedule) {
                this.schedule();
            }
            return newItems;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean canRun() {
            AddToProcessingQueue addToProcessingQueue = this;
            synchronized (addToProcessingQueue) {
                return !this.itemQueue.isEmpty();
            }
        }

        private void schedule() {
            this.schedule(false, false);
        }

        private void schedule(boolean immediate, boolean wait) {
            if (this.canRun()) {
                if (immediate) {
                    this.procQueueJob.cancel();
                    this.procQueueJob.schedule(0L, TimeUnit.NANOSECONDS);
                } else {
                    this.procQueueJob.schedule(2L, TimeUnit.SECONDS);
                }
            }
            if (wait) {
                this.procQueueJob.get();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Item getNextItem() {
            Item item;
            AddToProcessingQueue addToProcessingQueue = this;
            synchronized (addToProcessingQueue) {
                item = this.itemQueue.poll();
                if (item != null) {
                    this.mySize.decrementAndGet();
                }
            }
            return item;
        }

        @Override
        public void run() {
            this.run(null);
        }

        private boolean beginTrackingDocument(IDocument document, ITextFileBuffer buffer) {
            if (document == null || buffer == null) {
                return false;
            }
            ITextFileBuffer old = FileBufferListener.this.docToBufferMap.put(document, buffer);
            if (old == null) {
                DocListener listener = new DocListener(document, buffer);
                if (document instanceof IDocumentExtension4) {
                    ((IDocumentExtension4)document).addDocumentRewriteSessionListener((IDocumentRewriteSessionListener)listener);
                }
                document.addDocumentListener((IDocumentListener)listener);
                FileBufferListener.this.docToListenerMap.put(document, listener);
                return true;
            }
            return false;
        }

        private void endTrackingDocument(IDocument document) {
            DocListener listener = (DocListener)FileBufferListener.this.docToListenerMap.remove(document);
            if (listener != null) {
                listener.dispose();
                document.removeDocumentListener((IDocumentListener)listener);
                if (document instanceof IDocumentExtension4) {
                    ((IDocumentExtension4)document).removeDocumentRewriteSessionListener((IDocumentRewriteSessionListener)listener);
                }
            }
            FileBufferListener.this.docToBufferMap.remove(document);
        }

        protected IStatus run(IProgressMonitor monitor) {
            HashSet<Item> dirtyDocs = new HashSet<Item>();
            boolean shouldSchedule = false;
            Item item = this.getNextItem();
            while (item != null) {
                try {
                    IDocument document;
                    FileBufferListener.this.write.lock();
                    if (item.kind == 1) {
                        if (item.buffer instanceof ITextFileBuffer) {
                            document = item.document;
                            this.beginTrackingDocument(document, (ITextFileBuffer)item.buffer);
                        }
                    } else if (item.kind == 2) {
                        if (item.buffer instanceof ITextFileBuffer) {
                            IPath path;
                            document = item.document;
                            this.endTrackingDocument(document);
                            if (item.buffer.isDirty() && (path = item.buffer.getLocation()) != null) {
                                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                                InternalAPI.removeMarkersFor((IFile)file);
                                MANAGER.requestChangeAnalysis(new ResourceChange((IResource)file, 4), null);
                            }
                        }
                    } else if (item.kind == 3) {
                        dirtyDocs.add(item);
                        if (item.isDirty) {
                            boolean newlyTracked;
                            if (item.buffer instanceof ITextFileBuffer && (newlyTracked = this.beginTrackingDocument(document = item.document, (ITextFileBuffer)item.buffer))) {
                                FileBufferListener.this.docToLastChangeMap.put(document, item.timestamp);
                                shouldSchedule = true;
                                if (Logger.SHOULD_TRACE_ACTIVE_DOC_REINDEXING) {
                                    Logger.trace((Logger.Category)Logger.Category.ACTIVE_DOC_REINDEXING, (String)("Document [" + item.buffer.getLocation() + "] was dirtied, and wasn't tracked: scheduling reindexing"), (Throwable[])new Throwable[]{null});
                                }
                            }
                        } else if (item.buffer instanceof ITextFileBuffer && (document = item.document) != null) {
                            FileBufferListener.this.docToLastChangeMap.put(document, item.timestamp);
                            shouldSchedule = true;
                            if (Logger.SHOULD_TRACE_ACTIVE_DOC_REINDEXING) {
                                Logger.trace((Logger.Category)Logger.Category.ACTIVE_DOC_REINDEXING, (String)("Document [" + item.buffer.getLocation() + "] was saved: scheduling reindexing"), (Throwable[])new Throwable[]{null});
                            }
                        }
                    }
                    item = this.getNextItem();
                }
                finally {
                    FileBufferListener.this.write.unlock();
                }
            }
            for (Item i : dirtyDocs) {
                IFile file;
                IPath path = i.buffer.getLocation();
                if (path == null || (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) == null) continue;
                FileBufferListener.this.updater.dirtyStateChanged(i.document, file, i.isDirty);
            }
            if (shouldSchedule) {
                FileBufferListener.this.scheduleReIndexing();
            }
            return Status.OK_STATUS;
        }
    }

    private class DocListener
    implements IDocumentListener,
    IDocumentRewriteSessionListener,
    IReferenceListener {
        boolean suspend = false;
        boolean changedWhileSuspended = false;
        int changecount = 0;
        private final IDocument document;
        private IFile file;
        private List<LinkPosition> originalPositions = new ArrayList<LinkPosition>();
        private volatile boolean disposed;

        public DocListener(IDocument document, ITextFileBuffer buffer) {
            IPath location;
            this.document = document;
            if (buffer != null && (location = buffer.getLocation()) != null && location.segmentCount() >= 2) {
                this.file = ResourcesPlugin.getWorkspace().getRoot().getFile(location);
            }
            if (this.file != null) {
                MANAGER.addReferenceListener((IReferenceListener)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void documentRewriteSessionChanged(DocumentRewriteSessionEvent event) {
            if (this.disposed) {
                return;
            }
            if (event.getChangeType() == DocumentRewriteSessionEvent.SESSION_START) {
                this.suspend = true;
            } else if (event.getChangeType() == DocumentRewriteSessionEvent.SESSION_STOP) {
                this.suspend = false;
                if (this.changedWhileSuspended) {
                    DocListener docListener = this;
                    synchronized (docListener) {
                        this.updatePositions(false, this.originalPositions);
                    }
                }
                this.changedWhileSuspended = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleReferenceEvents(List<ReferenceEvent> events) {
            if (this.disposed) {
                return;
            }
            if (this.changecount > 0) {
                HashSet<ILink> addedLinks = new HashSet<ILink>();
                HashSet<ILink> removedLinks = new HashSet<ILink>();
                for (ReferenceEvent referenceEvent : events) {
                    ILink link;
                    if (referenceEvent.getKind() == ReferenceEvent.Kind.RESET || referenceEvent.getKind() == ReferenceEvent.Kind.FATAL_ERROR) {
                        DocListener docListener = this;
                        synchronized (docListener) {
                            this.removeAllPositions();
                            this.changecount = 0;
                        }
                    }
                    if (referenceEvent.getKind() == ReferenceEvent.Kind.ADD && referenceEvent.getChangedElement().getElementType() == IReferenceElement.ElementType.LINK) {
                        link = (ILink)referenceEvent.getChangedElement();
                        if (link.getContainer() == null || !this.file.equals((Object)link.getContainer().getResource())) continue;
                        addedLinks.add(link);
                        continue;
                    }
                    if (referenceEvent.getKind() != ReferenceEvent.Kind.REMOVE || referenceEvent.getOriginalElement().getElementType() != IReferenceElement.ElementType.LINK || (link = (ILink)referenceEvent.getOriginalElement()).getContainer() == null || !this.file.equals((Object)link.getContainer().getResource())) continue;
                    removedLinks.add(link);
                }
                if (!addedLinks.isEmpty() || !removedLinks.isEmpty()) {
                    DocListener docListener = this;
                    synchronized (docListener) {
                        ArrayList<LinkPosition> positionsToRemove = new ArrayList<LinkPosition>();
                        for (ILink removedLink : removedLinks) {
                            Iterator<LinkPosition> iterator = this.originalPositions.iterator();
                            while (iterator.hasNext()) {
                                LinkPosition linkPosition = iterator.next();
                                if (linkPosition.getLink().getId() != removedLink.getId()) continue;
                                iterator.remove();
                                positionsToRemove.add(linkPosition);
                            }
                        }
                        this.removePositions(positionsToRemove);
                        List<LinkPosition> newAddedLinksFromEvents = this.createPositionsFromLinks(addedLinks);
                        this.addPositions(newAddedLinksFromEvents);
                        this.originalPositions.addAll(newAddedLinksFromEvents);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void documentAboutToBeChanged(DocumentEvent event) {
            if (this.disposed) {
                return;
            }
            if (this.changecount == 0) {
                DocListener docListener = this;
                synchronized (docListener) {
                    this.originalPositions = this.updatePositions(true, null);
                }
            }
            ++this.changecount;
            if (this.suspend) {
                this.changedWhileSuspended = true;
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeAllPositions() {
            DocListener docListener = this;
            synchronized (docListener) {
                List<String> cats = Arrays.asList(this.document.getPositionCategories());
                if (cats.contains(FileBufferListener.LINK_POSITION_CATEGORY)) {
                    try {
                        this.document.removePositionCategory(FileBufferListener.LINK_POSITION_CATEGORY);
                    }
                    catch (BadPositionCategoryException badPositionCategoryException) {}
                }
            }
        }

        private void ensureCategoryExists() {
            List<String> cats = Arrays.asList(this.document.getPositionCategories());
            if (!cats.contains(FileBufferListener.LINK_POSITION_CATEGORY)) {
                this.document.addPositionCategory(FileBufferListener.LINK_POSITION_CATEGORY);
            }
            boolean found = false;
            IPositionUpdater[] iPositionUpdaterArray = this.document.getPositionUpdaters();
            int n = iPositionUpdaterArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPositionUpdater positionUpdater = iPositionUpdaterArray[n2];
                if (positionUpdater instanceof ThreadSafePositionUpdater) {
                    found = true;
                    break;
                }
                ++n2;
            }
            if (!found) {
                this.document.addPositionUpdater((IPositionUpdater)new ThreadSafePositionUpdater(FileBufferListener.LINK_POSITION_CATEGORY));
            }
        }

        private List<LinkPosition> getPositionsFromDatabase(IFile file) {
            List<LinkPosition> positions = Collections.emptyList();
            SearchScope scope = SearchEngine.createSearchScope((IResource[])new IResource[]{file});
            SearchPattern pattern = SearchPattern.createWildcardPattern();
            DefaultSearchRequestor req = new DefaultSearchRequestor();
            try {
                SearchEngine.setSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
                SearchEngine engine = new SearchEngine(true);
                engine.search(pattern, scope, (SearchRequestor)req, null);
                Set links = req.getMatches();
                positions = this.createPositionsFromLinks(links);
            }
            finally {
                SearchEngine.clearSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
            }
            return positions;
        }

        private List<LinkPosition> createPositionsFromLinks(Set<ILink> links) {
            ArrayList<LinkPosition> positions = new ArrayList<LinkPosition>();
            for (ILink link : links) {
                TextRange ctxrange = link.getContextLocation();
                TextRange linkrange = link.getLinkLocation();
                if (ctxrange == null) continue;
                LinkPosition cpos = new LinkPosition(ctxrange.getOffset(), ctxrange.getLength(), link, true, this.document);
                positions.add(cpos);
                if (linkrange.getOffset() == 0) continue;
                LinkPosition lpos = new LinkPosition(linkrange.getOffset(), linkrange.getLength(), link, false, this.document);
                positions.add(lpos);
            }
            return positions;
        }

        private List<LinkPosition> getPositionsFromDocument() {
            ArrayList<LinkPosition> existingPositions = new ArrayList<LinkPosition>();
            try {
                Position[] pos = this.document.getPositions(FileBufferListener.LINK_POSITION_CATEGORY);
                LinkPosition[] links = new LinkPosition[pos.length];
                System.arraycopy(pos, 0, links, 0, pos.length);
                existingPositions.addAll(Arrays.asList(links));
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            return existingPositions;
        }

        private void removePositions(Collection<? extends Position> existingPositions) {
            for (Position position : existingPositions) {
                try {
                    this.document.removePosition(FileBufferListener.LINK_POSITION_CATEGORY, position);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {}
            }
        }

        private void addPositions(Collection<? extends Position> positions) {
            for (Position position : positions) {
                try {
                    this.document.addPosition(FileBufferListener.LINK_POSITION_CATEGORY, position);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<LinkPosition> updatePositions(boolean fromDB, List<LinkPosition> currentKnownPositions) {
            DocListener docListener = this;
            synchronized (docListener) {
                if (this.file == null) {
                    return new ArrayList<LinkPosition>();
                }
                if (MANAGER.hasFatalError()) {
                    this.removeAllPositions();
                    return new ArrayList<LinkPosition>();
                }
                List<LinkPosition> positions = null;
                positions = fromDB ? this.getPositionsFromDatabase(this.file) : currentKnownPositions;
                Assert.isNotNull(positions, (String)Messages.errorMsg_FileBufferListener_positionnotnull);
                this.ensureCategoryExists();
                LinkCompare compare = new LinkCompare();
                Collections.sort(positions, compare);
                List<LinkPosition> existingPositions = this.getPositionsFromDocument();
                Collections.sort(existingPositions, compare);
                SetInfo<LinkPosition> split = this.split(positions, existingPositions, compare);
                this.removePositions(split.onlyList2);
                this.addPositions(split.onlyList1);
                return positions;
            }
        }

        public <T> SetInfo<T> split(List<T> sortedList1, List<T> sortedList2, Comparator<T> compare) {
            T pos1;
            SetInfo info = new SetInfo();
            Cursor<T> list1 = new Cursor<T>(sortedList1);
            Cursor<T> list2 = new Cursor<T>(sortedList2);
            while (!list1.isDone() && !list2.isDone()) {
                T pos2;
                pos1 = list1.current();
                int c = compare.compare(pos1, pos2 = list2.current());
                if (c == 0) {
                    info.both.add(pos1);
                    list1.advance();
                    list2.advance();
                    continue;
                }
                if (c < 0) {
                    list1.advance();
                    info.onlyList1.add(pos1);
                    continue;
                }
                list2.advance();
                info.onlyList2.add(pos2);
            }
            while (true) {
                pos1 = list1.advance();
                if (list1.isDone()) break;
                info.onlyList1.add(pos1);
            }
            while (true) {
                T pos2 = list2.advance();
                if (list2.isDone()) break;
                info.onlyList2.add(pos2);
            }
            return info;
        }

        public void documentChanged(DocumentEvent event) {
            if (this.disposed) {
                return;
            }
            boolean schedule = false;
            IPath location = null;
            try {
                FileBufferListener.this.write.lock();
                if (this.disposed) {
                    return;
                }
                ITextFileBuffer buffer = (ITextFileBuffer)FileBufferListener.this.docToBufferMap.get(event.getDocument());
                if (buffer.isDirty()) {
                    IFile file;
                    FileBufferListener.this.docToLastChangeMap.put(event.getDocument(), System.currentTimeMillis());
                    location = buffer.getLocation();
                    if (location != null && InternalAPI.isTargettable((IResource)(file = ResourcesPlugin.getWorkspace().getRoot().getFile(location))) && !InternalAPI.ignoreContainedLinks((IResource)file)) {
                        schedule = true;
                    }
                }
            }
            finally {
                FileBufferListener.this.write.unlock();
            }
            if (schedule) {
                if (Logger.SHOULD_TRACE_ACTIVE_DOC_REINDEXING) {
                    Logger.trace((Logger.Category)Logger.Category.ACTIVE_DOC_REINDEXING, (String)("Document [" + location + "] changed while dirty: schedule re-indexing"), (Throwable[])new Throwable[]{null});
                }
                FileBufferListener.this.scheduleReIndexing();
            }
        }

        public void dispose() {
            this.removeAllPositions();
            MANAGER.removeReferenceListener((IReferenceListener)this);
            this.disposed = true;
        }

        public class Cursor<T> {
            private final Iterator<T> itr;
            private T current;
            private boolean done;

            public Cursor(Collection<T> collection) {
                this.itr = collection.iterator();
                boolean bl = this.done = !this.itr.hasNext();
                if (!this.done) {
                    this.current = this.itr.next();
                }
            }

            public T current() {
                return this.current;
            }

            public T advance() {
                if (this.done) {
                    return null;
                }
                if (this.itr.hasNext()) {
                    this.current = this.itr.next();
                } else {
                    this.current = null;
                    this.done = true;
                }
                return this.current;
            }

            public boolean isDone() {
                return this.done;
            }
        }

        private class LinkCompare
        implements Comparator<LinkPosition> {
            private LinkCompare() {
            }

            @Override
            public int compare(LinkPosition pos1, LinkPosition pos2) {
                int id2;
                boolean ctx1 = pos1.isContext();
                boolean ctx2 = pos2.isContext();
                if (ctx1 && !ctx2) {
                    return -1;
                }
                if (!ctx1 && ctx2) {
                    return 1;
                }
                int id1 = pos1.getLinkId();
                if (id1 < (id2 = pos2.getLinkId())) {
                    return -1;
                }
                if (id1 > id2) {
                    return 1;
                }
                return 0;
            }
        }

        public class SetInfo<T> {
            List<T> onlyList1 = new ArrayList<T>();
            List<T> both = new ArrayList<T>();
            List<T> onlyList2 = new ArrayList<T>();
        }
    }

    private class FileBufListener
    implements IFileBufferListener {
        private FileBufListener() {
        }

        public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
        }

        public void bufferContentReplaced(IFileBuffer buffer) {
        }

        public void bufferCreated(IFileBuffer buffer) {
        }

        public void bufferDisposed(IFileBuffer buffer) {
        }

        public void stateChangeFailed(IFileBuffer buffer) {
        }

        public void stateChanging(IFileBuffer buffer) {
        }

        public void stateValidationChanged(IFileBuffer buffer, boolean isStateValidated) {
        }

        public void underlyingFileDeleted(IFileBuffer buffer) {
        }

        public void underlyingFileMoved(IFileBuffer buffer, IPath path) {
        }

        public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
            IPath path = buffer.getLocation();
            if (path == null) {
                return;
            }
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            if (file == null) {
                return;
            }
            try {
                FileBufferListener.this.write.lock();
                TrackingInfo info = (TrackingInfo)FileBufferListener.this.tracking.get(file);
                if (info != null) {
                    FileBufferListener.this.addToProcessingQueue.addItem(FileBufferListener.this.newItem(buffer, 3, isDirty));
                }
            }
            finally {
                FileBufferListener.this.write.unlock();
            }
        }
    }

    private static class Info {
        IFile file;

        private Info() {
        }
    }

    static class Item {
        public static final int CREATED = 1;
        public static final int DISPOSED = 2;
        public static final int DIRTY_STATE = 3;
        public int kind;
        public IFileBuffer buffer;
        public boolean isDirty;
        public IDocument document;
        public long timestamp;

        Item() {
        }

        public String toString() {
            String s = new String();
            s = this.kind == 1 ? "CREATED" : (this.kind == 2 ? "DISPOSED" : (this.kind == 3 ? "DIRTY_STATE" : "UNKNOWN"));
            s = String.valueOf(s) + " " + this.buffer.getLocation() + " dirty=" + this.isDirty + " " + this.timestamp;
            return s;
        }
    }

    private class PosInfoCompare
    implements Comparator<LinkPosition> {
        private PosInfoCompare() {
        }

        @Override
        public int compare(LinkPosition pos1, LinkPosition pos2) {
            int link2;
            boolean deleted1 = pos1.isDeleted();
            boolean deleted2 = pos2.isDeleted();
            if (deleted1 && !deleted2) {
                return 1;
            }
            if (!deleted1 && deleted2) {
                return -1;
            }
            int link1 = pos1.getLinkId();
            if (link1 < (link2 = pos2.getLinkId())) {
                return -1;
            }
            if (link1 > link2) {
                return 1;
            }
            boolean context1 = pos1.isContext();
            boolean context2 = pos2.isContext();
            if (context1 && !context2) {
                return -1;
            }
            if (!context1 && context2) {
                return 1;
            }
            return 0;
        }
    }

    static class TrackingInfo {
        public IFileBuffer buffer;
        public int count;

        TrackingInfo() {
        }
    }
}

