/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.ui.internal.filebuffers;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.events.IReferenceListener;
import com.ibm.etools.references.events.ReferenceEvent;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.ui.internal.filebuffers.FileBufferListener;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class EditorTracker
implements IWindowListener,
IPageListener,
IPartListener {
    private final FileBufferListener filebufferlistener;
    private boolean connected;
    private final IEclipsePreferences.IPreferenceChangeListener prefListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if ("referenceIgnoredPaths".equals(event.getKey())) {
                InternalAPI.ResourceApprovalEntry[] entries = InternalAPI.deserializeResourceApprovalPrefs((String)((String)event.getNewValue()));
                boolean hasStar = false;
                InternalAPI.ResourceApprovalEntry[] resourceApprovalEntryArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    InternalAPI.ResourceApprovalEntry entry = resourceApprovalEntryArray[n2];
                    if (entry.enabled && entry.stringItem.equals("*")) {
                        hasStar = true;
                        break;
                    }
                    ++n2;
                }
                if (hasStar) {
                    EditorTracker.this.disconnect();
                } else {
                    EditorTracker.this.connect(false);
                }
            }
        }
    };
    private final IReferenceListener referenceListener = new IReferenceListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleReferenceEvents(List<ReferenceEvent> events) {
            for (ReferenceEvent referenceEvent : events) {
                if (referenceEvent.getKind() == ReferenceEvent.Kind.RESET) {
                    EditorTracker editorTracker = EditorTracker.this;
                    synchronized (editorTracker) {
                        EditorTracker.this.disconnect();
                        EditorTracker.this.connect(true);
                        continue;
                    }
                }
                if (referenceEvent.getKind() != ReferenceEvent.Kind.FATAL_ERROR) continue;
                EditorTracker.this.disconnect();
            }
        }
    };

    public EditorTracker(FileBufferListener listener) {
        this.filebufferlistener = listener;
        InstanceScope scope = new InstanceScope();
        IEclipsePreferences instancePrefs = scope.getNode("com.ibm.etools.references");
        instancePrefs.addPreferenceChangeListener(this.prefListener);
        ReferenceManager.getReferenceManager().addReferenceListener(this.referenceListener);
        this.connect(true);
    }

    public void dispose() {
        ReferenceManager.getReferenceManager().removeReferenceListener(this.referenceListener);
        InstanceScope scope = new InstanceScope();
        IEclipsePreferences instancePrefs = scope.getNode("com.ibm.etools.references");
        instancePrefs.removePreferenceChangeListener(this.prefListener);
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(boolean doStarCheck) {
        EditorTracker editorTracker = this;
        synchronized (editorTracker) {
            if (!(this.connected || ReferenceManager.getReferenceManager().isSuspended() || ReferenceManager.getReferenceManager().hasFatalError())) {
                IWorkbenchWindow[] windows;
                if (doStarCheck && InternalAPI.hasStar()) {
                    return;
                }
                this.filebufferlistener.connect();
                PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
                IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                int n = windows.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchPage[] pages;
                    IWorkbenchWindow workbenchWindow = iWorkbenchWindowArray[n2];
                    workbenchWindow.addPageListener((IPageListener)this);
                    workbenchWindow.getPartService().addPartListener((IPartListener)this);
                    IWorkbenchPage[] iWorkbenchPageArray = pages = workbenchWindow.getPages();
                    int n3 = pages.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IViewReference[] views;
                        IEditorReference[] refs;
                        IWorkbenchPage workbenchPage = iWorkbenchPageArray[n4];
                        IEditorReference[] iEditorReferenceArray = refs = workbenchPage.getEditorReferences();
                        int n5 = refs.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IEditorReference editorReference = iEditorReferenceArray[n6];
                            IEditorPart part = editorReference.getEditor(false);
                            if (part != null) {
                                this.partOpened((IWorkbenchPart)part);
                            }
                            ++n6;
                        }
                        IViewReference[] iViewReferenceArray = views = workbenchPage.getViewReferences();
                        int n7 = views.length;
                        n5 = 0;
                        while (n5 < n7) {
                            IViewReference viewRef = iViewReferenceArray[n5];
                            IViewPart part = viewRef.getView(false);
                            if (part != null) {
                                this.partOpened((IWorkbenchPart)part);
                            }
                            ++n5;
                        }
                        ++n4;
                    }
                    ++n2;
                }
                this.connected = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect() {
        EditorTracker editorTracker = this;
        synchronized (editorTracker) {
            if (this.connected) {
                IWorkbenchWindow[] windows;
                PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
                IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                int n = windows.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchPage[] pages;
                    IWorkbenchWindow workbenchWindow = iWorkbenchWindowArray[n2];
                    workbenchWindow.removePageListener((IPageListener)this);
                    workbenchWindow.getPartService().removePartListener((IPartListener)this);
                    IWorkbenchPage[] iWorkbenchPageArray = pages = workbenchWindow.getPages();
                    int n3 = pages.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IEditorReference[] refs;
                        IWorkbenchPage workbenchPage = iWorkbenchPageArray[n4];
                        IEditorReference[] iEditorReferenceArray = refs = workbenchPage.getEditorReferences();
                        int n5 = refs.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IEditorReference editorReference = iEditorReferenceArray[n6];
                            IEditorPart part = editorReference.getEditor(false);
                            if (part != null) {
                                this.partClosed((IWorkbenchPart)part);
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                    ++n2;
                }
                this.connected = false;
                this.filebufferlistener.disconnect();
            }
        }
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        window.removePageListener((IPageListener)this);
    }

    public void windowOpened(IWorkbenchWindow window) {
        window.addPageListener((IPageListener)this);
        if (window.getActivePage() != null) {
            window.getActivePage().addPartListener((IPartListener)this);
        }
    }

    public void pageActivated(IWorkbenchPage page) {
    }

    public void pageClosed(IWorkbenchPage page) {
        page.removePartListener((IPartListener)this);
    }

    public void pageOpened(IWorkbenchPage page) {
        page.addPartListener((IPartListener)this);
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            this.editorClosed((IEditorPart)part);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            this.editorOpened((IEditorPart)part);
        } else if (part instanceof IViewPart) {
            IViewPart view = (IViewPart)part;
            this.viewOpened(view);
        }
    }

    public void viewOpened(IViewPart view) {
        IWorkbenchSiteProgressService service;
        if ("org.eclipse.ui.views.ProblemView".equals(view.getViewSite().getId())) {
            IWorkbenchSiteProgressService service2 = (IWorkbenchSiteProgressService)view.getSite().getService(IWorkbenchSiteProgressService.class);
            if (service2 != null) {
                service2.showBusyForFamily(InternalAPI.MARKERS_FAMILY);
                service2.showBusyForFamily(ReferenceManager.class);
            }
        } else if ("org.eclipse.ui.views.AllMarkersView".equals(view.getViewSite().getId()) && (service = (IWorkbenchSiteProgressService)view.getSite().getService(IWorkbenchSiteProgressService.class)) != null) {
            service.showBusyForFamily(InternalAPI.MARKERS_FAMILY);
            service.showBusyForFamily(ReferenceManager.class);
        }
    }

    public void editorOpened(IEditorPart part) {
        this.filebufferlistener.editorOpened(part);
    }

    public void editorClosed(IEditorPart part) {
        this.filebufferlistener.editorClosed(part);
    }
}

