/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.ui.internal.annotations;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.events.IReferenceListener;
import com.ibm.etools.references.events.ReferenceEvent;
import com.ibm.etools.references.management.BrokenReference;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.ui.internal.annotations.BrokenLinkAnnotation;
import com.ibm.etools.references.ui.internal.annotations.Mutex;
import com.ibm.etools.references.ui.internal.filebuffers.FileBufferListener;
import com.ibm.etools.references.ui.internal.nls.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.osgi.util.NLS;

public class AnnotationUpdater
implements Runnable,
IReferenceListener {
    private static final ReferenceManager MANAGER = ReferenceManager.getReferenceManager();
    private final WeakHashMap<IDocument, List<ILink>> docsWithAnnotations = new WeakHashMap();
    private final PriorityQueue<WorkItem> itemQueue = new PriorityQueue();
    private int mySize = 0;
    private final Mutex SYNC = new Mutex();
    private volatile boolean shutdown;
    private static final int SCHEDULE_DELAY = 0;
    private final InternalAPI.ReferencesJob job = new InternalAPI.ReferencesJob((Runnable)this);
    private FileBufferListener fileBufferListener;

    public void cancel() {
        this.job.cancelJoin();
    }

    public void clear() {
        this.cancel();
        try {
            this.SYNC.acquire();
            this.itemQueue.clear();
            this.mySize = 1;
            this.itemQueue.add(new WorkItem(1));
        }
        finally {
            this.SYNC.release();
        }
        this.doSchedule();
    }

    private void doSchedule() {
        this.job.schedule(0L, TimeUnit.MILLISECONDS);
    }

    private WorkItem getNextChange() {
        try {
            this.SYNC.acquire();
            WorkItem item = this.itemQueue.poll();
            if (item != null) {
                --this.mySize;
            }
            WorkItem workItem = item;
            return workItem;
        }
        finally {
            this.SYNC.release();
        }
    }

    @Override
    public void run() {
        this.run(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus run(IProgressMonitor monitor) {
        if (this.shutdown) {
            return Status.OK_STATUS;
        }
        SubMonitor root = SubMonitor.convert((IProgressMonitor)monitor);
        root.beginTask(Messages.annotations_updating, 100000);
        int originalPriority = Thread.currentThread().getPriority();
        try {
            Thread.currentThread().setPriority(1);
            SearchEngine.setSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
            int severity = InternalAPI.getBrokenLinkSeverity();
            WorkItem item = this.getNextChange();
            while (item != null) {
                block27: {
                    ILink link;
                    block28: {
                        block25: {
                            block26: {
                                int work = this.mySize;
                                root.setWorkRemaining(work);
                                link = item.link;
                                if (link == null) break block25;
                                if (link.isValid()) break block26;
                                this.removeAnnotationsForLink(link, (IProgressMonitor)root.newChild(1));
                                this.handleRemove(link);
                                break block27;
                            }
                            IPath path = link.getPath();
                            if (path != null) {
                                root.subTask(path.toString());
                            } else {
                                root.subTask("");
                            }
                            break block28;
                        }
                        root.subTask("");
                    }
                    SubMonitor mon = root.newChild(1, 7);
                    if (item.type == 11) {
                        if (link != null) {
                            InternalAPI.AnnotationModelDocumentPair model = null;
                            if (link.getContainer() != null && link.getContainer().getResource().getType() == 1) {
                                model = this.fileBufferListener.getAnnotationModel((IFile)link.getContainer().getResource());
                            }
                            if (model != null) {
                                WeakHashMap<IDocument, List<ILink>> weakHashMap = this.docsWithAnnotations;
                                synchronized (weakHashMap) {
                                    List<ILink> links = this.docsWithAnnotations.get(model.getDocument());
                                    if (links == null) {
                                        this.docsWithAnnotations.put(model.getDocument(), Collections.synchronizedList(new ArrayList()));
                                    }
                                }
                                mon.beginTask("", 3);
                                this.removeAnnotationsForLink(link, (IProgressMonitor)mon.newChild(1));
                                if (model.getBuffer().isDirty() && severity > 0) {
                                    Collection refs = link.findBrokenReferences((IProgressMonitor)mon.newChild(1));
                                    SubMonitor create = mon.newChild(1);
                                    create.beginTask("", refs.size());
                                    for (BrokenReference ref : refs) {
                                        String completeBrokenText = NLS.bind((String)Messages.annotations_broken_link_x, (Object)ref.getDescription());
                                        BrokenLinkAnnotation annotation = new BrokenLinkAnnotation(ref, completeBrokenText);
                                        int offset = ref.getBrokenReferenceRange().getOffset();
                                        int length = ref.getBrokenReferenceRange().getLength();
                                        Position p = new Position(offset, length);
                                        model.getAnnotationModel().addAnnotation((Annotation)annotation, p);
                                        create.worked(1);
                                    }
                                }
                            } else {
                                mon.done();
                            }
                        }
                    } else if (item.type == 10) {
                        if (link != null) {
                            this.handleRemove(link);
                            this.removeAnnotationsForLink(link, (IProgressMonitor)mon);
                        }
                    } else if (item.type == 1) {
                        List<IAnnotationModel> models = this.fileBufferListener.getAllAnotationModels();
                        for (IAnnotationModel model : models) {
                            this.removeAnnotations(model);
                        }
                    }
                }
                item = this.getNextChange();
            }
        }
        finally {
            Thread.currentThread().setPriority(originalPriority);
            root.done();
            SearchEngine.clearSearchHint(EnumSet.of(SearchEngine.SearchHint.NOWAIT));
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRemove(ILink link) {
        InternalAPI.AnnotationModelDocumentPair model;
        if (link.getContainer() != null && link.getContainer().getResource().getType() == 1 && (model = this.fileBufferListener.getAnnotationModel((IFile)link.getContainer().getResource())) != null) {
            List<Object> links;
            WeakHashMap<IDocument, List<ILink>> weakHashMap = this.docsWithAnnotations;
            synchronized (weakHashMap) {
                links = this.docsWithAnnotations.get(model.getDocument());
                if (links == null) {
                    links = Collections.synchronizedList(new ArrayList());
                    this.docsWithAnnotations.put(model.getDocument(), links);
                }
            }
            links.add(link);
        }
    }

    private void removeAnnotationsForLink(ILink link, IProgressMonitor monitor) {
        monitor.beginTask("", 1);
        InternalAPI.AnnotationModelDocumentPair model = null;
        if (link.getContainer() != null && link.getContainer().getResource().getType() == 1) {
            model = this.fileBufferListener.getAnnotationModel((IFile)link.getContainer().getResource());
        }
        if (model != null) {
            ArrayList<Annotation> toRemove = new ArrayList<Annotation>();
            if (model.getAnnotationModel() != null) {
                Iterator itr = model.getAnnotationModel().getAnnotationIterator();
                while (itr.hasNext()) {
                    Annotation a = (Annotation)itr.next();
                    if (!(a instanceof BrokenLinkAnnotation) || link.getId() != ((BrokenLinkAnnotation)a).getLinkId()) continue;
                    toRemove.add(a);
                }
                for (Annotation remove : toRemove) {
                    model.getAnnotationModel().removeAnnotation(remove);
                }
            }
        }
        monitor.worked(1);
        monitor.done();
    }

    private List<BrokenReference> removeAnnotationsFor(IFile file, IProgressMonitor monitor) {
        ArrayList<BrokenReference> references = new ArrayList<BrokenReference>();
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        mon.beginTask("", 1);
        InternalAPI.AnnotationModelDocumentPair model = this.fileBufferListener.getAnnotationModel(file, false);
        if (model != null) {
            references.addAll(this.removeAnnotations(model.getAnnotationModel()));
        }
        mon.worked(1);
        mon.done();
        return references;
    }

    private Collection<BrokenReference> removeAnnotations(IAnnotationModel model) {
        ArrayList<BrokenReference> references = new ArrayList<BrokenReference>();
        ArrayList<Annotation> toRemove = new ArrayList<Annotation>();
        Iterator itr = model.getAnnotationIterator();
        while (itr.hasNext()) {
            Annotation a = (Annotation)itr.next();
            if (!(a instanceof BrokenLinkAnnotation)) continue;
            toRemove.add(a);
            references.add(((BrokenLinkAnnotation)a).getBrokenReference());
        }
        for (Annotation remove : toRemove) {
            model.removeAnnotation(remove);
        }
        return references;
    }

    public void shutdown() {
        this.shutdown = true;
        this.cancel();
    }

    public void handleReferenceEvents(List<ReferenceEvent> events) {
        HashSet<ILink> removedLinks = new HashSet<ILink>();
        HashSet<ILink> affectedlinks = new HashSet<ILink>();
        if (this.fileBufferListener.hasAnnotationsModels()) {
            for (ReferenceEvent referenceEvent : events) {
                InternalAPI.AnnotationModelDocumentPair model;
                IResource file;
                ILink source;
                if (referenceEvent.getKind() == ReferenceEvent.Kind.RESET) {
                    this.clear();
                    break;
                }
                if (referenceEvent.getKind() == ReferenceEvent.Kind.FATAL_ERROR) {
                    this.clear();
                    break;
                }
                if (referenceEvent.getReferenceElement().getElementType() == IReferenceElement.ElementType.RESOLVED_REFERENCE) {
                    source = ((IResolvedReference)referenceEvent.getReferenceElement()).getSource();
                    if (source == null || source.getContainer() == null || (file = source.getContainer().getResource()).getType() != 1 || (model = this.fileBufferListener.getAnnotationModel((IFile)file)) == null) continue;
                    affectedlinks.add(source);
                    continue;
                }
                if (referenceEvent.getKind() != ReferenceEvent.Kind.REMOVE || referenceEvent.getOriginalElement().getElementType() != IReferenceElement.ElementType.LINK || (source = (ILink)referenceEvent.getOriginalElement()) == null || source.getContainer() == null || (file = source.getContainer().getResource()).getType() != 1 || (model = this.fileBufferListener.getAnnotationModel((IFile)file)) == null) continue;
                removedLinks.add(source);
            }
            affectedlinks.removeAll(removedLinks);
            boolean doSchedule = false;
            try {
                WorkItem item;
                this.SYNC.acquire();
                for (ILink link : removedLinks) {
                    item = new WorkItem(10);
                    item.link = link;
                    this.itemQueue.add(item);
                }
                for (ILink link : affectedlinks) {
                    item = new WorkItem(11);
                    item.link = link;
                    this.itemQueue.add(item);
                }
                int newSize = affectedlinks.size() + removedLinks.size();
                this.mySize += newSize;
                doSchedule = newSize > 0;
            }
            finally {
                this.SYNC.release();
            }
            if (doSchedule) {
                this.doSchedule();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dirtyStateChanged(IDocument document, IFile file, boolean dirty) {
        if (!MANAGER.isSuspended() && !dirty) {
            List<ILink> links = null;
            Object object = this.docsWithAnnotations;
            synchronized (object) {
                links = this.docsWithAnnotations.get(document);
            }
            if (links != null) {
                object = links;
                synchronized (object) {
                    InternalAPI.removeMarkersForLinks(links);
                    links.clear();
                }
                List<BrokenReference> references = this.removeAnnotationsFor(file, null);
                InternalAPI.removeMarkersFor(references);
                InternalAPI.createMarkersFor(references);
            }
        }
    }

    public void setFileBufferListener(FileBufferListener fileBufferListener) {
        this.fileBufferListener = fileBufferListener;
    }

    public void disconnect() {
        ReferenceManager.getReferenceManager().removeReferenceListener((IReferenceListener)this);
        this.cancel();
    }

    public void connect() {
        ReferenceManager.getReferenceManager().addReferenceListener((IReferenceListener)this);
    }

    public class WorkItem
    implements Comparable<WorkItem> {
        public static final int REMOVE_ALL = 1;
        public static final int REMOVED = 10;
        public static final int CHANGED = 11;
        public ILink link;
        public int type;

        public WorkItem(int type) {
            this.type = type;
        }

        @Override
        public int compareTo(WorkItem o) {
            return this.type - o.type;
        }

        public String toString() {
            String string = this.type == 1 ? "REMOVE_ALL" : (this.type == 10 ? "REMOVED" : (this.type == 11 ? "CHANGED" : "Unknown:" + this.type));
            return "WorkItem: Type=" + string + " " + this.link;
        }
    }
}

