/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.ui.internal;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.events.ErrorEvent;
import com.ibm.etools.references.events.IErrorListener;
import com.ibm.etools.references.ui.internal.ErrorRecoveryDialog;
import com.ibm.etools.references.ui.internal.UnknownErrorRecoveryDialog;
import java.util.Set;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public class ErrorPresenter
implements IErrorListener {
    private int convertHints(Set<ErrorEvent.PresentationHints> hints) {
        int hint = 0;
        for (ErrorEvent.PresentationHints presentationHints : hints) {
            int map = 0;
            if (presentationHints == ErrorEvent.PresentationHints.BLOCK) {
                map = 4;
            } else if (presentationHints == ErrorEvent.PresentationHints.LOG) {
                map = 1;
            } else if (presentationHints == ErrorEvent.PresentationHints.SHOW) {
                map = 2;
            }
            hint |= map;
        }
        return hint;
    }

    public void handleError(ErrorEvent error) {
        if (error.getKind() == ErrorEvent.Kind.CONTRIBUTION_ERROR) {
            StatusAdapter adapter = new StatusAdapter(error.getStatus());
            StatusManager.getManager().handle(adapter, this.convertHints(error.getHints()));
        } else if (error.getKind() == ErrorEvent.Kind.FRAMEWORK_ERROR) {
            StatusAdapter adapter = new StatusAdapter(error.getStatus());
            StatusManager.getManager().handle(adapter, this.convertHints(error.getHints()));
        }
    }

    public boolean handleErrorRecovery(int faultNumber, String ignorePath) {
        String path;
        final int[] resultHolder = new int[1];
        String string = path = ignorePath == null ? "" : ignorePath;
        if (faultNumber == 1) {
            return InternalAPI.Tweaks.ERROR_RECOVERY_STYLE == 0;
        }
        if (ErrorDialog.AUTOMATED_MODE) {
            return false;
        }
        if (ignorePath == null || ignorePath.length() == 0) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    UnknownErrorRecoveryDialog dialog = new UnknownErrorRecoveryDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), path);
                    resultHolder[0] = dialog.open();
                }
            });
            return resultHolder[0] == 2;
        }
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ErrorRecoveryDialog dialog = new ErrorRecoveryDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), path);
                resultHolder[0] = dialog.open();
            }
        });
        return resultHolder[0] == 2;
    }
}

