/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.view;

import com.ibm.etools.qev.nls.ResourceHandler;
import com.ibm.etools.qev.registry.DefinitionsRegistry;
import com.ibm.etools.qev.registry.EventCategoryDefinition;
import com.ibm.etools.qev.registry.EventDefinition;
import com.ibm.etools.qev.view.EventListFilter;
import com.ibm.etools.qev.view.FilterContentProvider;
import com.ibm.etools.qev.view.FilterLabelProvider;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchViewerSorter;

public class FilterDialog
extends Dialog
implements ICheckStateListener {
    private EventListFilter filterState;
    private CheckboxTreeViewer viewer;
    private static final int DIALOG_WIDTH = 250;
    private static final int DIALOG_HEIGHT = 350;

    public FilterDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Object elem = event.getElement();
        if (elem instanceof EventCategoryDefinition) {
            EventCategoryDefinition cat = (EventCategoryDefinition)elem;
            boolean checkedState = event.getChecked();
            Iterator eventsIter = cat.getEvents();
            while (eventsIter.hasNext()) {
                this.viewer.setChecked(eventsIter.next(), checkedState);
            }
            this.viewer.setGrayed((Object)cat, false);
        }
        if (elem instanceof EventDefinition) {
            EventDefinition eventDef = (EventDefinition)elem;
            EventCategoryDefinition catDef = eventDef.getCategory();
            this.updateCategory(catDef);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ResourceHandler.Set_event_filters);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "com.ibm.etools.qev.qedv1300");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Label label = new Label(dialogArea, 0);
        label.setText(ResourceHandler.FilterDialog_0);
        label.setFont(parent.getFont());
        this.viewer = new CheckboxTreeViewer(dialogArea, 2048);
        GridData data = new GridData(1808);
        this.viewer.getTree().setLayoutData((Object)data);
        this.viewer.setContentProvider((IContentProvider)new FilterContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new FilterLabelProvider());
        this.viewer.setSorter((ViewerSorter)new WorkbenchViewerSorter());
        this.viewer.addCheckStateListener((ICheckStateListener)this);
        DefinitionsRegistry registry = DefinitionsRegistry.getRegistry();
        Iterator categories = registry.getEventCategories();
        this.viewer.setInput((Object)categories);
        this.displayInitialSelection();
        return dialogArea;
    }

    private void displayInitialSelection() {
        Iterator eventsIter = DefinitionsRegistry.getRegistry().getEvents();
        while (eventsIter.hasNext()) {
            EventDefinition def = (EventDefinition)eventsIter.next();
            if (this.filterState.isHidden(def)) continue;
            this.viewer.setChecked((Object)def, true);
        }
        Iterator catsIter = DefinitionsRegistry.getRegistry().getEventCategories();
        while (catsIter.hasNext()) {
            EventCategoryDefinition catDef = (EventCategoryDefinition)catsIter.next();
            this.updateCategory(catDef);
        }
    }

    protected Point getInitialSize() {
        return new Point(250, 350);
    }

    protected void okPressed() {
        this.resetFilterState();
        super.okPressed();
    }

    private void resetFilterState() {
        this.filterState.clearFilters();
        Object[] checks = this.viewer.getCheckedElements();
        ArrayList<Object> checkedList = new ArrayList<Object>();
        int i = 0;
        while (i < checks.length) {
            checkedList.add(checks[i]);
            ++i;
        }
        Iterator allEvents = DefinitionsRegistry.getRegistry().getEvents();
        while (allEvents.hasNext()) {
            Object o = allEvents.next();
            if (checkedList.contains(o) || !(o instanceof EventDefinition)) continue;
            this.filterState.setFilter((EventDefinition)o, false);
        }
    }

    public void setFilterState(EventListFilter fs) {
        this.filterState = fs;
    }

    private void updateCategory(EventCategoryDefinition catDef) {
        Iterator eventsIter = catDef.getEvents();
        boolean partialChecked = false;
        boolean partialUnchecked = false;
        while (eventsIter.hasNext()) {
            if (this.viewer.getChecked(eventsIter.next())) {
                partialChecked = true;
                if (!partialUnchecked) continue;
                break;
            }
            partialUnchecked = true;
            if (partialChecked) break;
        }
        if (partialChecked && partialUnchecked) {
            this.viewer.setGrayChecked((Object)catDef, true);
        } else {
            this.viewer.setChecked((Object)catDef, partialChecked);
            this.viewer.setGrayed((Object)catDef, false);
        }
    }
}

