/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.view;

import com.ibm.etools.qev.model.IEvent;
import com.ibm.etools.qev.registry.DefinitionsRegistry;
import com.ibm.etools.qev.registry.EventDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IMemento;

public class EventListFilter
extends ViewerFilter {
    private static final String CHILD_TYPE = "eventFilter";
    private List eventsToHide = Collections.synchronizedList(new ArrayList());

    public void clearFilters() {
        this.eventsToHide.clear();
    }

    public Iterator getHiddenEvents() {
        return this.eventsToHide.iterator();
    }

    public boolean isHidden(EventDefinition eventDef) {
        return this.eventsToHide.contains(eventDef);
    }

    public void restoreState(IMemento memento) {
        IMemento[] children = memento.getChildren(CHILD_TYPE);
        int i = 0;
        while (i < children.length) {
            EventDefinition eventDef;
            String eventID = children[i].getTextData();
            if (eventID != null && (eventDef = DefinitionsRegistry.getRegistry().getEvent(eventID)) != null) {
                this.eventsToHide.add(eventDef);
            }
            ++i;
        }
    }

    public void saveState(IMemento memento) {
        int i = 0;
        while (i < this.eventsToHide.size()) {
            IMemento child = memento.createChild(CHILD_TYPE);
            child.putTextData(((EventDefinition)this.eventsToHide.get(i)).getEventID());
            ++i;
        }
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof IEvent) {
            IEvent event = (IEvent)element;
            return !this.isHidden(DefinitionsRegistry.getRegistry().getEvent(event.getID()));
        }
        return false;
    }

    public void setFilter(EventDefinition eventDef, boolean visible) {
        if (visible) {
            this.eventsToHide.remove(eventDef);
        } else if (!this.eventsToHide.contains(eventDef)) {
            this.eventsToHide.add(eventDef);
        }
    }
}

