/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.registry;

import com.ibm.etools.qev.Debug;
import com.ibm.etools.qev.QEVPlugin;
import com.ibm.etools.qev.model.IEvent;
import com.ibm.etools.qev.registry.ActionDefinition;
import com.ibm.etools.qev.registry.EventCategoryDefinition;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.swt.graphics.Image;

public class EventDefinition {
    private String eventID;
    private String eventName;
    private String displayName;
    private EventCategoryDefinition category;
    private ArrayList actions = new ArrayList();
    private String eventClassName;
    private IConfigurationElement configurationElement;

    public void addAction(ActionDefinition newAction) {
        this.actions.add(newAction);
    }

    public boolean containsActionMapping(ActionDefinition action) {
        return this.actions.contains(action);
    }

    public IEvent createEvent() {
        if (this.getEventClassName() == null) {
            return null;
        }
        IEvent event = null;
        try {
            event = (IEvent)this.getConfigurationElement().createExecutableExtension("class");
        }
        catch (CoreException e) {
            Debug.logException("Unable to create event: " + this.getEventID(), e);
        }
        return event;
    }

    public Iterator getActions() {
        return this.actions.iterator();
    }

    public EventCategoryDefinition getCategory() {
        return this.category;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getEventClassName() {
        return this.eventClassName;
    }

    public String getEventID() {
        return this.eventID;
    }

    public String getEventName() {
        return this.eventName;
    }

    public Image getSetIcon() {
        return QEVPlugin.getDefault().getImageRegistry().get(this.getCategory().getSetIconKey());
    }

    public Image getUnsetIcon() {
        return QEVPlugin.getDefault().getImageRegistry().get(this.getCategory().getUnsetIconKey());
    }

    public void setCategory(EventCategoryDefinition category) {
        this.category = category;
    }

    public void setConfigurationElement(IConfigurationElement element) {
        this.configurationElement = element;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setEventClassName(String string) {
        this.eventClassName = string;
    }

    public void setEventID(String eventID) {
        this.eventID = eventID;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }
}

