/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.registry;

import com.ibm.etools.qev.Debug;
import com.ibm.etools.qev.QEVPlugin;
import com.ibm.etools.qev.actions.IActionVariableDialog;
import com.ibm.etools.qev.actions.SimpleAction;
import com.ibm.etools.qev.registry.EventDefinition;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.swt.graphics.Image;

public class ActionDefinition {
    private String actionID;
    private String displayName;
    private String actionClassName;
    private String iconKey;
    private ArrayList relevantEvents = new ArrayList();
    private String language;
    private String dialogClass;
    private IConfigurationElement configurationElement;
    private String detectorId;

    public void addEvent(EventDefinition newEvent) {
        this.relevantEvents.add(newEvent);
    }

    public boolean containsEventMapping(EventDefinition event) {
        return this.relevantEvents.contains(event);
    }

    public IActionVariableDialog createActionDialog() {
        if (this.getDialogClass() == null) {
            return null;
        }
        IActionVariableDialog dialog = null;
        try {
            dialog = (IActionVariableDialog)this.getConfigurationElement().createExecutableExtension("dialogClass");
        }
        catch (CoreException e) {
            Debug.logException("Unable to create simple action dialog: " + this.getDialogClass(), e);
        }
        return dialog;
    }

    public SimpleAction createSimpleAction() {
        if (this.getActionClassName() == null) {
            return null;
        }
        SimpleAction action = null;
        try {
            action = (SimpleAction)this.getConfigurationElement().createExecutableExtension("class");
        }
        catch (CoreException e) {
            Debug.logException("Unable to create simple action: " + this.getActionID(), e);
        }
        return action;
    }

    public String getActionClassName() {
        return this.actionClassName;
    }

    public String getActionID() {
        return this.actionID;
    }

    public String getActionName() {
        return this.displayName;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public String getDetectorId() {
        return this.detectorId;
    }

    public String getDialogClass() {
        return this.dialogClass;
    }

    public Iterator getEvents() {
        return this.relevantEvents.iterator();
    }

    public Image getIcon() {
        return QEVPlugin.getDefault().getImageRegistry().get(this.getIconKey());
    }

    public String getIconKey() {
        return this.iconKey;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setActionClassName(String actionClassName) {
        this.actionClassName = actionClassName;
    }

    public void setActionID(String actionID) {
        this.actionID = actionID;
    }

    public void setActionName(String actionName) {
        this.displayName = actionName;
    }

    public void setConfigurationElement(IConfigurationElement element) {
        this.configurationElement = element;
    }

    public void setDetectorId(String string) {
        this.detectorId = string;
    }

    public void setDialogClass(String string) {
        this.dialogClass = string;
    }

    public void setIconKey(String iconKey) {
        this.iconKey = iconKey;
    }

    public void setLanguage(String string) {
        this.language = string;
    }
}

