/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.model.impl;

import com.ibm.etools.qev.Debug;
import com.ibm.etools.qev.edit.IExtendedDesignEditor;
import com.ibm.etools.qev.model.IEvent;
import com.ibm.etools.qev.model.adapters.EventsDocumentAdapter;
import com.ibm.etools.qev.model.adapters.EventsNodeAdapter;
import com.ibm.etools.qev.model.impl.AbstractDOMEventUpdater;
import com.ibm.etools.qev.model.impl.FunctionBounds;
import com.ibm.etools.qev.model.impl.ITagEvent;
import com.ibm.etools.qev.nls.ResourceHandler;
import com.ibm.etools.qev.registry.EventDefinition;
import com.ibm.etools.qev.util.TextNodeUtil;
import com.ibm.etools.webtools.internal.jsfInterface.IJSFInterface;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.html.core.internal.modelquery.DocumentQuery;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class HtmlEventUpdater
extends AbstractDOMEventUpdater {
    private final String THISOBJ = "thisObj";
    private final String THISEVENT = "thisEvent";
    MessageFormat thisObjMessageFormat = new MessageFormat(ResourceHandler.HtmlEventUpdater_0);
    Object[] thisObjArgs = new Object[]{"thisObj", "this"};
    String thisObjMessage;
    private String USE_THISOBJ_INSTEAD_OF_THIS = this.thisObjMessage = this.thisObjMessageFormat.format(this.thisObjArgs);
    MessageFormat thisEventMessageFormat = new MessageFormat(ResourceHandler.HtmlEventUpdater_1);
    Object[] thisEventArgs = new Object[]{"thisEvent", "event"};
    String thisEventMessage;
    private String USE_THISEVENT_INSTEAD_OF_EVENT = this.thisEventMessage = this.thisEventMessageFormat.format(this.thisEventArgs);
    protected boolean isIBMPortletProject = false;
    protected boolean isJSR168PortletProject = false;
    protected boolean isFacesJSP = false;
    protected IJSFInterface jsfHelper = null;

    public HtmlEventUpdater(IExtendedDesignEditor editDomain) {
        super(editDomain);
        FileEditorInput file = (FileEditorInput)editDomain.getActiveEditorInput();
        IProject project = file.getFile().getProject();
        this.isIBMPortletProject = HtmlEventUpdater.isProjectOfType(project, "ibmportlet.base");
        this.isJSR168PortletProject = HtmlEventUpdater.isProjectOfType(project, "jsr168.base");
        this.isFacesJSP = this.getFacesHelper().isFacesJSP(file.getFile());
    }

    private static boolean isProjectOfType(IProject project, String typeID) {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {
            return false;
        }
        if (facetedProject != null && ProjectFacetsManager.isProjectFacetDefined((String)typeID)) {
            IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)typeID);
            return projectFacet != null && facetedProject.hasProjectFacet(projectFacet);
        }
        return false;
    }

    private Node addBodyScriptNode(EventsDocumentAdapter pageInfo, IDOMNode eventNode) {
        Debug.trace("update", "no <body><script> nodes in page");
        Document doc = eventNode.getOwnerDocument();
        DocumentQuery query = (DocumentQuery)((INodeNotifier)doc).getAdapterFor(DocumentQuery.class);
        Node bodyNode = query.getRenderRootNode((Node)doc, !query.isFragment(doc));
        if (bodyNode != null) {
            return this.addScriptNode(bodyNode);
        }
        return null;
    }

    protected boolean addEventAsFunction(ITagEvent event, String functionName, String script) {
        Node scriptNode = this.getFirstScriptableNode(event);
        if (scriptNode == null) {
            return false;
        }
        Node textNode = TextNodeUtil.findChildTextNode(scriptNode);
        if (textNode == null) {
            textNode = scriptNode.getOwnerDocument().createTextNode("");
            scriptNode.appendChild(textNode);
        }
        String newFunctionText = "\n" + this.generateFunctionText(functionName, script);
        try {
            event.getNode().getStructuredDocument().replace(((IDOMNode)textNode).getEndOffset(), 0, newFunctionText);
        }
        catch (BadLocationException e) {
            Debug.log(202, e.getMessage(), e);
        }
        ((IDOMNode)scriptNode).getAdapterFor(EventsNodeAdapter.class);
        return true;
    }

    private Node addHeadScriptNode(EventsDocumentAdapter pageInfo, IDOMNode eventNode) {
        Debug.trace("update", "no <head><script> nodes in page");
        Document doc = eventNode.getOwnerDocument();
        DocumentQuery query = (DocumentQuery)((INodeNotifier)doc).getAdapterFor(DocumentQuery.class);
        query.getHeadCorrespondentNode((Node)doc, !query.isFragment(doc));
        DocumentQuery.InsertionTarget target = query.getHeadInsertionTarget(doc);
        if (target != null) {
            Node newScriptNode = this.createScriptNode(doc);
            target.getParent().insertBefore(newScriptNode, target.getRef());
            return newScriptNode;
        }
        return null;
    }

    private Node addScriptNode(Node parent) {
        IDOMNode xmlNodeParent;
        Document d = parent.getOwnerDocument();
        Node newScriptNode = this.createScriptNode(d);
        Node targetNode = parent;
        if (parent instanceof IDOMNode && !(xmlNodeParent = (IDOMNode)parent).isChildEditable()) {
            IDOMNode firstChild;
            IDOMNode potentialTarget = firstChild = (IDOMNode)xmlNodeParent.getFirstChild();
            while (potentialTarget != null) {
                if (potentialTarget.isChildEditable()) {
                    targetNode = potentialTarget;
                    break;
                }
                potentialTarget = (IDOMNode)potentialTarget.getNextSibling();
            }
        }
        targetNode.appendChild(newScriptNode);
        return newScriptNode;
    }

    @Override
    protected void create(ITagEvent tagEvent, Element tag, EventDefinition eventDef, String newEventScript, IStructuredModel model) {
        String functionName = tagEvent.getFunctionName();
        if (functionName == null) {
            EventsDocumentAdapter pageInfo = (EventsDocumentAdapter)tagEvent.getNode().getModel().getDocument().getAdapterFor(EventsDocumentAdapter.class);
            functionName = TextNodeUtil.generateUniqueFunctionName(pageInfo);
        }
        String massagedFunctionName = functionName;
        if (this.isJSR168PortletProject) {
            massagedFunctionName = "<portlet:namespace/>" + functionName;
        }
        if (!this.addEventAsFunction(tagEvent, massagedFunctionName, newEventScript)) {
            Debug.trace("update", "create: event add failed in " + this);
            return;
        }
        tagEvent.setInDOMAttribute(false);
        this.setDOMAttribute(tag, eventDef.getEventName(), this.getFunctionCallString(functionName));
        tagEvent.setFunctionName(functionName);
        tagEvent.setScript(newEventScript);
        if (tagEvent.getEditorInfo() == null || tagEvent.getEditorInfo().getEditorInput() == null) {
            this.processAdditionalScript(tagEvent, model);
        }
    }

    private Node createScriptNode(Document doc) {
        Element newScriptNode = doc.createElement("SCRIPT");
        newScriptNode.setAttribute("type", "text/javascript");
        Text textNode = doc.createTextNode("");
        newScriptNode.appendChild(textNode);
        return newScriptNode;
    }

    @Override
    public void doUpdate(IEvent event, String newEventScript, ArrayList actions, IStructuredModel model) {
        if (event.getEditorInfo() == null || event.getEditorInfo().getEditorInput() == null) {
            super.doUpdate(event, newEventScript, actions, model);
        }
    }

    protected String generateFunctionText(String functionName, String script) {
        StringBuffer buf = new StringBuffer();
        buf.append("function ");
        buf.append(functionName);
        buf.append("(thisObj, thisEvent) {");
        buf.append("\n//" + this.USE_THISOBJ_INSTEAD_OF_THIS + "\n");
        buf.append("//" + this.USE_THISEVENT_INSTEAD_OF_EVENT + "\n");
        buf.append(script);
        buf.append("\n");
        buf.append("}");
        return buf.toString();
    }

    private IJSFInterface getFacesHelper() {
        IExtensionRegistry reg;
        IConfigurationElement[] conf;
        if (this.jsfHelper == null && (conf = (reg = Platform.getExtensionRegistry()).getConfigurationElementsFor("com.ibm.etools.webtools.JSFHelper")).length > 0) {
            IConfigurationElement currentConf = conf[0];
            try {
                this.jsfHelper = (IJSFInterface)currentConf.createExecutableExtension("className");
            }
            catch (Exception exception) {
                Debug.trace("update", "Failed to create an instance of the IJSFHelper");
            }
        }
        return this.jsfHelper;
    }

    private Node getFirstHeadScriptableNode(ITagEvent event) {
        EventsDocumentAdapter pageInfo = (EventsDocumentAdapter)event.getNode().getModel().getDocument().getAdapterFor(EventsDocumentAdapter.class);
        DocumentQuery query = (DocumentQuery)event.getNode().getAdapterFor(DocumentQuery.class);
        List scriptNodesList = pageInfo.getScriptNodes();
        Node scriptNode = null;
        boolean scriptFound = false;
        int i = 0;
        while (i < scriptNodesList.size() && !scriptFound) {
            scriptNode = (Node)scriptNodesList.get(i);
            NamedNodeMap nodeAttributes = scriptNode.getAttributes();
            if (nodeAttributes != null && nodeAttributes.getNamedItem("src") == null && scriptNode.getParentNode() != null && query.isHeadCorrespondent(scriptNode.getParentNode()) && (!(scriptNode instanceof IDOMNode) || ((IDOMNode)scriptNode).isChildEditable())) {
                scriptFound = true;
                continue;
            }
            ++i;
        }
        if (!scriptFound) {
            scriptNode = this.addHeadScriptNode(pageInfo, event.getNode());
        }
        return scriptNode;
    }

    private Node getFirstScriptableNode(ITagEvent event) {
        EventsDocumentAdapter pageInfo = (EventsDocumentAdapter)event.getNode().getModel().getDocument().getAdapterFor(EventsDocumentAdapter.class);
        List scriptNodesList = pageInfo.getScriptNodes();
        Node scriptNode = null;
        boolean scriptFound = false;
        int i = 0;
        while (i < scriptNodesList.size() && !scriptFound) {
            scriptNode = (Node)scriptNodesList.get(i);
            NamedNodeMap nodeAttributes = scriptNode.getAttributes();
            if (nodeAttributes != null && nodeAttributes.getNamedItem("src") == null && (!(scriptNode instanceof IDOMNode) || ((IDOMNode)scriptNode).isChildEditable())) {
                scriptFound = true;
                continue;
            }
            ++i;
        }
        if (!scriptFound && (scriptNode = this.addHeadScriptNode(pageInfo, event.getNode())) == null) {
            scriptNode = this.addBodyScriptNode(pageInfo, event.getNode());
        }
        return scriptNode;
    }

    protected String getFunctionCallString(String functionName) {
        String result = null;
        result = this.isIBMPortletProject ? "return " + functionName + "(this, event);" : (this.isJSR168PortletProject ? (this.isFacesJSP ? "return #{facesContext.externalContext.response.namespace}" + functionName + "(this, event);" : "'<%=response.getNamespace()%>" + functionName + "(this, event)'") : "return " + functionName + "(this, event);");
        return result;
    }

    protected void processAdditionalScript(ITagEvent event, IStructuredModel model) {
        Node scriptNode;
        String name;
        if (model == null) {
            return;
        }
        EventsDocumentAdapter editorInfo = (EventsDocumentAdapter)event.getNode().getModel().getDocument().getAdapterFor(EventsDocumentAdapter.class);
        EventsDocumentAdapter eventsEditorInfo = (EventsDocumentAdapter)((IDOMModel)model).getDocument().getAdapterFor(EventsDocumentAdapter.class);
        StringBuffer additionalScriptToInsert = new StringBuffer();
        Iterator globalVarNames = eventsEditorInfo.getGlobalVarNames();
        List<String> varsToInsert = new ArrayList();
        while (globalVarNames.hasNext()) {
            String name2 = (String)globalVarNames.next();
            if (editorInfo.isInScriptTagVar(name2)) continue;
            varsToInsert.add(name2);
        }
        varsToInsert = eventsEditorInfo.orderGlobalVarNames(varsToInsert);
        int i = 0;
        while (i < varsToInsert.size()) {
            name = (String)varsToInsert.get(i);
            scriptNode = eventsEditorInfo.getNodeForScriptVar(name);
            if (scriptNode != null) {
                Region bounds = eventsEditorInfo.getBoundsForScriptVar(name);
                int start = bounds.getOffset();
                int end = bounds.getLength() + start;
                Node textNode = TextNodeUtil.findChildTextNode(scriptNode);
                String text = textNode.getNodeValue();
                additionalScriptToInsert.append(text.substring(start, end));
            }
            ++i;
        }
        Iterator functionNames = eventsEditorInfo.getFunctionNames();
        while (functionNames.hasNext()) {
            name = (String)functionNames.next();
            if (editorInfo.isInScriptTag(name) || name.equals(event.getFunctionName()) || (scriptNode = eventsEditorInfo.getNodeForScript(name)) == null) continue;
            Node textNode = TextNodeUtil.findChildTextNode(scriptNode);
            String text = textNode.getNodeValue();
            FunctionBounds bounds = eventsEditorInfo.getBoundsForScript(name);
            int start = bounds.getFunctionStart();
            int end = bounds.getFunctionEnd();
            additionalScriptToInsert.append(text.substring(start, end));
        }
        if (additionalScriptToInsert.length() > 0) {
            Node nodeToScript = this.getFirstHeadScriptableNode(event);
            if (nodeToScript == null) {
                nodeToScript = this.getFirstScriptableNode(event);
            }
            if (nodeToScript != null) {
                Node nodeToScriptText = nodeToScript.getFirstChild();
                StringBuffer currentScript = new StringBuffer(nodeToScriptText.getNodeValue());
                currentScript.append("\n");
                currentScript.append(additionalScriptToInsert);
                nodeToScriptText.setNodeValue(currentScript.toString());
                ((IDOMNode)nodeToScript).getAdapterFor(EventsNodeAdapter.class);
            }
        }
    }

    @Override
    protected void remove(ITagEvent tagEvent, Element tag, EventDefinition eventDef) {
        if (!tagEvent.isInDOMAttribute()) {
            String functionName = tagEvent.getFunctionName();
            if (functionName != null) {
                this.removeFunctionFromPage(tagEvent);
            } else {
                Debug.trace("update", "remove: event remove failed - function name not found");
                return;
            }
        }
        this.removeDOMAttribute(tag, eventDef.getEventName());
        tagEvent.setFunctionName(null);
        tagEvent.setScript(null);
    }

    protected void removeDOMAttribute(Element tag, String eventName) {
        tag.removeAttribute(eventName);
    }

    private void removeFunctionFromPage(ITagEvent event) {
        EventsDocumentAdapter pageInfo = (EventsDocumentAdapter)event.getNode().getModel().getDocument().getAdapterFor(EventsDocumentAdapter.class);
        String functionName = event.getFunctionName();
        Node currentScriptNode = pageInfo.getNodeForScript(functionName);
        Node textNode = TextNodeUtil.findChildTextNode(currentScriptNode);
        FunctionBounds bounds = pageInfo.getBoundsForScript(functionName);
        int start = bounds.getFunctionStart();
        int end = bounds.getFunctionEnd();
        int offset = ((IDOMNode)textNode).getStartOffset();
        try {
            char c;
            if (start > 0 && ((c = event.getNode().getStructuredDocument().getChar(offset + start - 1)) == '\r' || c == '\n')) {
                --start;
            }
            event.getNode().getStructuredDocument().replace(offset + start, end - start, "");
        }
        catch (BadLocationException e) {
            Debug.log(202, e.getMessage(), e);
        }
    }

    protected void setDOMAttribute(Element tag, String eventName, String script) {
        tag.setAttribute(eventName, script);
    }

    @Override
    protected void update(ITagEvent tagEvent, Element tag, EventDefinition eventDef, String newEventScript, IStructuredModel model) {
        if (tagEvent.getEditorInfo() == null || tagEvent.getEditorInfo().getEditorInput() == null) {
            if (tagEvent.isInDOMAttribute()) {
                this.setDOMAttribute(tag, eventDef.getEventName(), newEventScript);
            } else {
                String functionName = tagEvent.getFunctionName();
                if (functionName != null) {
                    if (!this.updateFunctionInPage(tagEvent, functionName, newEventScript)) {
                        Debug.trace("update", "update: event update failed in " + this);
                        return;
                    }
                } else {
                    Debug.trace("update", "update: event update failed - function name not set");
                    return;
                }
            }
            tagEvent.setScript(newEventScript);
            this.processAdditionalScript(tagEvent, model);
        }
    }

    private boolean updateFunctionInPage(ITagEvent event, String functionName, String script) {
        EventsDocumentAdapter pageInfo = (EventsDocumentAdapter)event.getNode().getModel().getDocument().getAdapterFor(EventsDocumentAdapter.class);
        Node scriptNode = pageInfo.getNodeForScript(functionName);
        if (scriptNode != null) {
            Node textNode = TextNodeUtil.findChildTextNode(scriptNode);
            FunctionBounds bounds = pageInfo.getBoundsForScript(functionName);
            int start = bounds.getFunctionStart();
            int end = bounds.getFunctionEnd();
            try {
                event.getNode().getStructuredDocument().replace(((IDOMNode)textNode).getStartOffset() + start, end - start, this.generateFunctionText(functionName, script));
                return true;
            }
            catch (BadLocationException e) {
                Debug.log(202, e.getMessage(), e);
            }
        }
        return false;
    }
}

