/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.model.impl;

import com.ibm.etools.qev.Debug;
import com.ibm.etools.qev.edit.IExtendedDesignEditor;
import com.ibm.etools.qev.model.IEvent;
import com.ibm.etools.qev.model.IEventEditorInfo;
import com.ibm.etools.qev.model.IEventScriptContext;
import com.ibm.etools.qev.model.adapters.EventsNodeAdapter;
import com.ibm.etools.qev.model.impl.CompositeEventUpdater;
import com.ibm.etools.qev.model.impl.EventEditorInfo;
import com.ibm.etools.qev.model.impl.HTMLJavascriptScriptContext;
import com.ibm.etools.qev.model.impl.HtmlEventUpdater;
import com.ibm.etools.qev.model.impl.HtmlJavascriptContext;
import com.ibm.etools.qev.model.impl.HtmlTagEventImpl;
import com.ibm.etools.qev.model.impl.ITagEventModelBuilder;
import com.ibm.etools.qev.model.impl.JspJavaDeclarationContext;
import com.ibm.etools.qev.model.impl.JspJavascriptDeclarationContext;
import com.ibm.etools.qev.model.impl.JspScriptletContext;
import com.ibm.etools.qev.model.impl.ScriptEventUpdater;
import com.ibm.etools.qev.model.impl.ScriptTagEventImpl;
import com.ibm.etools.qev.nls.ResourceHandler;
import com.ibm.etools.qev.registry.ActionDefinition;
import com.ibm.etools.qev.registry.DefinitionsRegistry;
import com.ibm.etools.qev.registry.EventDefinition;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapter;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentAssistUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HtmlEventModelBuilder
implements ITagEventModelBuilder {
    private HashMap clientEventsMap = null;
    protected CompositeEventUpdater clientJSEventUpdater = null;
    private ScriptEventUpdater scriptingEventUpdater = null;
    protected IEventEditorInfo editorInfo = null;

    @Override
    public boolean applicableAction(ActionDefinition action, IEvent event, IDOMNode node) {
        boolean result = false;
        if (action.getLanguage() == null || action.getLanguage().equalsIgnoreCase(event.getLanguage())) {
            result = true;
        }
        return result;
    }

    protected void contributeClientJSEvents(EventsNodeAdapter adapter, IDOMNode xmlNode, CMElementDeclaration elementDeclaration) {
        boolean isReadOnly = !xmlNode.isDataEditable();
        for (CMAttributeDeclaration cmAttrNode : elementDeclaration.getAttributes()) {
            String eventID;
            String cmAttrName = cmAttrNode.getNodeName();
            if (!this.isNodeScriptable(cmAttrNode)) continue;
            String eventName = eventID = cmAttrName;
            Image unsetIcon = null;
            Image setIcon = null;
            EventDefinition eventDef = (EventDefinition)this.getClientEventsMap().get(cmAttrName);
            if (eventDef != null) {
                eventID = eventDef.getEventID();
                eventName = eventDef.getEventName();
                unsetIcon = eventDef.getUnsetIcon();
                setIcon = eventDef.getSetIcon();
            }
            HtmlTagEventImpl event = new HtmlTagEventImpl(xmlNode, eventID, eventName, unsetIcon, setIcon, this.editorInfo);
            event.addScriptContext("javascript", new HtmlJavascriptContext(xmlNode));
            event.setReadOnly(isReadOnly);
            event.setUpdater(this.clientJSEventUpdater);
            event.addAllowedLanguage("javascript");
            event.setLanguage("javascript");
            event.setDescription(ResourceHandler.getDescriptionString(event.getID()));
            adapter.addEvent(event, this);
        }
    }

    @Override
    public void contributeEvents(EventsNodeAdapter adapter) {
        IDOMNode xmlNode = adapter.getNode();
        if (xmlNode instanceof Element) {
            ModelQueryAdapter mqa = (ModelQueryAdapter)xmlNode.getAdapterFor(ModelQueryAdapter.class);
            if (mqa == null) {
                return;
            }
            ModelQuery mq = mqa.getModelQuery();
            if (mq == null) {
                return;
            }
            CMElementDeclaration elementDeclaration = mq.getCMElementDeclaration((Element)xmlNode);
            if (elementDeclaration != null) {
                String nodeName = elementDeclaration.getElementName();
                if ("SCRIPT".equalsIgnoreCase(nodeName)) {
                    this.contributeScriptEvents(adapter, xmlNode, nodeName);
                }
                if ("jsp:scriptlet".equalsIgnoreCase(nodeName) || "jsp:expression".equalsIgnoreCase(nodeName) || "jsp:declaration".equalsIgnoreCase(nodeName)) {
                    this.contributeJSPScriptEvents(adapter, xmlNode, nodeName);
                } else {
                    this.contributeClientJSEvents(adapter, xmlNode, elementDeclaration);
                }
            }
        }
    }

    private void contributeJSPScriptEvents(EventsNodeAdapter adapter, IDOMNode node, String elementName) {
        PageDirectiveAdapter directive;
        String JSP = "jsp ";
        EventDefinition eventDef = null;
        IEventScriptContext context = null;
        String language = null;
        if ("jsp:scriptlet".equalsIgnoreCase(elementName)) {
            Debug.trace("adapters", "contributeEvents - processing scriptlet node");
            eventDef = DefinitionsRegistry.getRegistry().getEvent("jsp.scripting.scriptlet");
            directive = (PageDirectiveAdapter)((INodeNotifier)node.getOwnerDocument()).getAdapterFor(PageDirectiveAdapter.class);
            if (directive == null) {
                return;
            }
            language = directive.getLanguage();
            context = new JspScriptletContext(node);
        }
        if ("jsp:expression".equalsIgnoreCase(elementName)) {
            Debug.trace("adapters", "contributeEvents - processing expression node");
            eventDef = DefinitionsRegistry.getRegistry().getEvent("jsp.scripting.expression");
            directive = (PageDirectiveAdapter)((INodeNotifier)node.getOwnerDocument()).getAdapterFor(PageDirectiveAdapter.class);
            if (directive == null) {
                return;
            }
            language = directive.getLanguage();
            context = new JspScriptletContext(node);
        }
        if ("jsp:declaration".equalsIgnoreCase(elementName)) {
            Debug.trace("adapters", "contributeEvents - processing declaration node");
            eventDef = DefinitionsRegistry.getRegistry().getEvent("jsp.scripting.declaration");
            directive = (PageDirectiveAdapter)((INodeNotifier)node.getOwnerDocument()).getAdapterFor(PageDirectiveAdapter.class);
            if (directive == null) {
                return;
            }
            language = directive.getLanguage();
            context = language.equalsIgnoreCase("javascript") ? new JspJavascriptDeclarationContext() : new JspJavaDeclarationContext();
        }
        ScriptTagEventImpl event = null;
        String eventID = "";
        String eventName = "";
        Image eventSetIcon = null;
        Image eventUnsetIcon = null;
        if (eventDef != null) {
            eventID = eventDef.getEventID();
            eventName = eventDef.getDisplayName();
            eventSetIcon = eventDef.getSetIcon();
            eventUnsetIcon = eventDef.getUnsetIcon();
        }
        event = new ScriptTagEventImpl(node, eventID, eventName, eventUnsetIcon, eventSetIcon, this.editorInfo);
        event.setUpdater(this.scriptingEventUpdater);
        event.addAllowedLanguage(String.valueOf(JSP) + language);
        event.setLanguage(String.valueOf(JSP) + language);
        event.addScriptContext(String.valueOf(JSP) + language, context);
        event.setDescription(ResourceHandler.getDescriptionString(eventID));
        event.setReadOnly(!node.isDataEditable() || !node.isChildEditable());
        adapter.addEvent(event, this);
    }

    private void contributeScriptEvents(EventsNodeAdapter adapter, IDOMNode node, String elementName) {
        EventDefinition eventDef = null;
        HTMLJavascriptScriptContext context = null;
        String language = null;
        if (!"javascript".equalsIgnoreCase(XMLContentAssistUtilities.getScriptLanguage((Node)node)) || node.hasAttributes() && node.getAttributes().getNamedItem("src") != null) {
            Debug.trace("adapters", "processScriptNode-not valid javascript node");
            return;
        }
        Debug.trace("adapters", "contributeEvents - processing script node");
        eventDef = DefinitionsRegistry.getRegistry().getEvent("html.scripting.javascriptscript");
        language = "javascript";
        context = new HTMLJavascriptScriptContext(node);
        ScriptTagEventImpl event = null;
        String eventID = "";
        String eventName = "";
        Image eventSetIcon = null;
        Image eventUnsetIcon = null;
        if (eventDef != null) {
            eventID = eventDef.getEventID();
            eventName = eventDef.getDisplayName();
            eventSetIcon = eventDef.getSetIcon();
            eventUnsetIcon = eventDef.getUnsetIcon();
        }
        event = new ScriptTagEventImpl(node, eventID, eventName, eventUnsetIcon, eventSetIcon, this.editorInfo);
        event.setUpdater(this.scriptingEventUpdater);
        event.addAllowedLanguage(language);
        event.setLanguage(language);
        event.addScriptContext(language, context);
        event.setDescription(ResourceHandler.getDescriptionString(eventID));
        event.setReadOnly(!node.isDataEditable() || !node.isChildEditable());
        adapter.addEvent(event, this);
    }

    protected CompositeEventUpdater createClientJSEventUpdater(IExtendedDesignEditor editDomain) {
        CompositeEventUpdater updater = new CompositeEventUpdater();
        updater.addUpdater("javascript", new HtmlEventUpdater(editDomain));
        return updater;
    }

    protected IEventEditorInfo createEventEditorInfo(IExtendedDesignEditor editDomain) {
        EventEditorInfo info = null;
        info = new EventEditorInfo(editDomain.getActiveEditorInput(), null);
        return info;
    }

    protected HashMap getClientEventsMap() {
        if (this.clientEventsMap == null) {
            this.clientEventsMap = new HashMap();
            Iterator events = DefinitionsRegistry.getRegistry().getEventCategory("html.client").getEvents();
            while (events.hasNext()) {
                EventDefinition tempDef = (EventDefinition)events.next();
                this.clientEventsMap.put(tempDef.getEventName(), tempDef);
            }
        }
        return this.clientEventsMap;
    }

    @Override
    public void initUpdater(IExtendedDesignEditor editDomain) {
        this.scriptingEventUpdater = new ScriptEventUpdater(editDomain);
        this.clientJSEventUpdater = this.createClientJSEventUpdater(editDomain);
        this.editorInfo = this.createEventEditorInfo(editDomain);
    }

    protected boolean isNodeScriptable(CMAttributeDeclaration cmAttrNode) {
        Boolean isScriptable;
        boolean scriptable = false;
        if (cmAttrNode.supports("isScriptable") && (isScriptable = (Boolean)cmAttrNode.getProperty("isScriptable")) != null) {
            scriptable = isScriptable;
        }
        return scriptable;
    }
}

