/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.model.impl;

import com.ibm.etools.qev.Debug;
import com.ibm.etools.qev.edit.IExtendedDesignEditor;
import com.ibm.etools.qev.model.IEvent;
import com.ibm.etools.qev.model.IEventList;
import com.ibm.etools.qev.model.IEventModelListener;
import com.ibm.etools.qev.model.IEventModelProvider;
import com.ibm.etools.qev.model.adapters.EventsDocumentAdapter;
import com.ibm.etools.qev.model.adapters.EventsNodeAdapter;
import com.ibm.etools.qev.model.adapters.EventsNodeAdapterFactory;
import com.ibm.etools.qev.view.QEVView;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class EventModelProvider
implements ISelectionChangedListener,
IEventModelProvider,
IModelStateListener {
    private IExtendedDesignEditor editDomain;
    private ArrayList listeners = new ArrayList();
    private IDOMNode currentNode;
    private IEventList currentEventsListModel;
    private IPostSelectionProvider vsm;
    private int holdFireSelectionCounter = 0;
    private INodeAdapter nodeListener = new EventModelProviderNodeNotifier();
    private IEditorPart editorPart;

    public EventModelProvider(IExtendedDesignEditor edit) {
        this.setEditDomain(edit);
    }

    @Override
    public synchronized void addEventModelListener(IEventModelListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        if (this.listeners.size() == 1) {
            this.doModelSetup();
        }
        this.fireModelChangedEvent(this.currentEventsListModel);
    }

    private void doModelSetup() {
        ISelection selection;
        EventsDocumentAdapter docAdapter;
        this.initBuilders();
        IStructuredModel activeModel = this.editDomain.getActiveModel();
        IDOMDocument ownerDoc = (IDOMDocument)activeModel.getAdapter(Document.class);
        if (ownerDoc != null && (docAdapter = (EventsDocumentAdapter)ownerDoc.getExistingAdapter(EventsDocumentAdapter.class)) != null) {
            Debug.trace("adapters", "non-null doc adapter - forcing refresh");
            docAdapter.refreshAll();
        }
        if ((selection = this.editorPart.getSite().getSelectionProvider().getSelection()) instanceof IStructuredSelection) {
            this.setCurrentNode((IDOMNode)((IStructuredSelection)selection).getFirstElement());
            Debug.trace("adapters", "adapter - doModelSetup() - current node=" + this.currentNode);
            if (this.currentNode != null) {
                if (this.currentNode.getNodeType() == 3 && this.currentNode.getParentNode() != null) {
                    this.setCurrentNode((IDOMNode)this.currentNode.getParentNode());
                }
                this.currentEventsListModel = (EventsNodeAdapter)this.currentNode.getAdapterFor(EventsNodeAdapter.class);
            }
        }
        this.vsm = (IPostSelectionProvider)this.editorPart.getSite().getSelectionProvider();
        if (this.vsm != null) {
            this.vsm.addPostSelectionChangedListener((ISelectionChangedListener)this);
            this.vsm.addSelectionChangedListener((ISelectionChangedListener)this);
            this.holdFireSelectionCounter = 0;
        }
        this.editDomain.getActiveModel().addModelStateListener((IModelStateListener)this);
    }

    private void fireModelChangedEvent(IEventList eventList) {
        Iterator list = this.listeners.iterator();
        while (list.hasNext()) {
            ((IEventModelListener)list.next()).eventModelChanged(eventList);
        }
    }

    private void fireModelResetEvent() {
        Iterator list = this.listeners.iterator();
        while (list.hasNext()) {
            ((IEventModelListener)list.next()).eventModelReset();
        }
    }

    public boolean getFireSelection() {
        Debug.trace("adapters", "getFireSelection() counter=" + this.holdFireSelectionCounter);
        return this.holdFireSelectionCounter <= 0;
    }

    private void initBuilders() {
        IStructuredModel activeModel = this.editDomain.getActiveModel();
        EventsNodeAdapterFactory adapterFactory = (EventsNodeAdapterFactory)activeModel.getFactoryRegistry().getFactoryFor(EventsNodeAdapter.class);
        if (adapterFactory != null && !adapterFactory.isInitialized()) {
            adapterFactory.initBuilders(this.editDomain);
        }
    }

    public void modelAboutToBeChanged(IStructuredModel model) {
        Debug.trace("adapters", "modelAboutToBeChanged()");
        this.setFireSelection(false);
    }

    public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
        Debug.trace("adapters", "modelAboutToBeReinitialized()");
    }

    public void modelChanged(IStructuredModel model) {
        Debug.trace("adapters", "modelChanged()");
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                EventModelProvider.this.setFireSelection(true);
                if (EventModelProvider.this.getFireSelection()) {
                    ISelection selection;
                    EventsNodeAdapter adapter;
                    if (EventModelProvider.this.currentNode != null && (adapter = (EventsNodeAdapter)EventModelProvider.this.currentNode.getAdapterFor(EventsNodeAdapter.class)) != null) {
                        adapter.setRequiresRefresh(true);
                    }
                    if ((selection = EventModelProvider.this.vsm.getSelection()) instanceof IStructuredSelection) {
                        IStructuredSelection nodelist = (IStructuredSelection)selection;
                        IDOMNode tempNode = null;
                        if (nodelist.size() == 1 && (tempNode = (IDOMNode)nodelist.getFirstElement()).getNodeType() == 3) {
                            tempNode = (IDOMNode)tempNode.getParentNode();
                        }
                        if (tempNode != EventModelProvider.this.currentNode) {
                            EventModelProvider.this.setCurrentNode(tempNode);
                            if (EventModelProvider.this.currentNode != null) {
                                Debug.trace("adapters", "modelChanged():" + EventModelProvider.this.currentNode.getNodeName());
                                EventModelProvider.this.currentEventsListModel = (EventsNodeAdapter)EventModelProvider.this.currentNode.getAdapterFor(EventsNodeAdapter.class);
                                if (EventModelProvider.this.currentEventsListModel != null) {
                                    ((EventsNodeAdapter)EventModelProvider.this.currentEventsListModel).setRequiresRefresh(true);
                                }
                                EventModelProvider.this.fireModelChangedEvent(EventModelProvider.this.currentEventsListModel);
                            } else {
                                EventModelProvider.this.currentEventsListModel = null;
                                Debug.trace("adapters", "modelChanged(): no node selected");
                                EventModelProvider.this.fireModelChangedEvent(null);
                            }
                        }
                    }
                }
            }
        });
    }

    public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
        Iterator list = this.listeners.iterator();
        while (list.hasNext()) {
            ((IEventModelListener)list.next()).eventModelDirtyStateChanged(isDirty);
        }
    }

    public void modelReinitialized(IStructuredModel structuredModel) {
        Debug.trace("adapters", "modelReinitialized()");
    }

    public void modelResourceDeleted(IStructuredModel model) {
    }

    public void modelResourceMoved(IStructuredModel oldModel, IStructuredModel newModel) {
    }

    @Override
    public synchronized void removeEventModelListener(IEventModelListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
        if (this.listeners.size() == 0) {
            if (this.vsm != null) {
                this.vsm.removePostSelectionChangedListener((ISelectionChangedListener)this);
            }
            if (this.editDomain != null && this.editDomain.getActiveModel() != null) {
                this.editDomain.getActiveModel().removeModelStateListener((IModelStateListener)this);
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection;
        Debug.trace("adapters", "nodeSelectionChanged()");
        if (this.getFireSelection() && (selection = event.getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection nodelist = (IStructuredSelection)selection;
            if (nodelist.size() == 1 && nodelist.getFirstElement() instanceof IDOMNode) {
                IDOMNode tempNode = (IDOMNode)nodelist.getFirstElement();
                if (tempNode.getNodeType() == 3) {
                    tempNode = (IDOMNode)tempNode.getParentNode();
                }
                this.setCurrentNode(tempNode);
                Debug.trace("adapters", "nodeSelectionChanged():" + this.currentNode.getNodeName());
                this.currentEventsListModel = (EventsNodeAdapter)this.currentNode.getAdapterFor(EventsNodeAdapter.class);
                this.initBuilders();
                this.fireModelChangedEvent(this.currentEventsListModel);
            } else {
                this.setCurrentNode(null);
                if (this.currentEventsListModel != null) {
                    this.currentEventsListModel = null;
                    this.fireModelChangedEvent(this.currentEventsListModel);
                }
            }
        }
    }

    private void setCurrentNode(IDOMNode newNode) {
        if (this.currentNode != null) {
            this.currentNode.removeAdapter(this.nodeListener);
        }
        this.currentNode = newNode;
        if (this.currentNode != null) {
            this.currentNode.addAdapter(this.nodeListener);
        }
    }

    public void setEditDomain(IExtendedDesignEditor edit) {
        if (this.vsm != null) {
            this.vsm.removePostSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (this.editDomain != null && this.editDomain.getActiveModel() != null) {
            this.editDomain.getActiveModel().removeModelStateListener((IModelStateListener)this);
        }
        this.editDomain = edit;
        this.holdFireSelectionCounter = 0;
        if (this.listeners.size() >= 1) {
            this.doModelSetup();
            this.fireModelChangedEvent(this.currentEventsListModel);
        }
    }

    public void setEditorPart(IEditorPart editorPart) {
        this.editorPart = editorPart;
    }

    public void setFireSelection(boolean b) {
        this.holdFireSelectionCounter = b ? --this.holdFireSelectionCounter : ++this.holdFireSelectionCounter;
        Debug.trace("adapters", "setFireSelection(" + b + ") counter=" + this.holdFireSelectionCounter);
    }

    private class EventModelProviderNodeNotifier
    implements INodeAdapter {
        private Object key = this.getClass();

        private EventModelProviderNodeNotifier() {
        }

        public boolean isAdapterForType(Object type) {
            return this.key.equals(type);
        }

        public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
            if (eventType == 1 && EventModelProvider.this.getFireSelection() && !EventModelProvider.this.listeners.isEmpty() && changedFeature instanceof Node && ((Node)changedFeature).getNodeType() == 2) {
                String attName = ((Node)changedFeature).getNodeName();
                if (oldValue instanceof String && ((String)oldValue).length() == 0 && newValue == null) {
                    for (Object listener : EventModelProvider.this.listeners) {
                        IEvent qevEvent;
                        if (!(listener instanceof QEVView) || (qevEvent = ((QEVView)listener).getCurrentEvent()) == null || qevEvent.getDisplayName() == null || !qevEvent.getDisplayName().equalsIgnoreCase(attName)) continue;
                        try {
                            EventModelProvider.this.setFireSelection(false);
                            EventModelProvider.this.fireModelResetEvent();
                        }
                        finally {
                            EventModelProvider.this.setFireSelection(true);
                        }
                    }
                }
            }
        }
    }
}

