/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.model.adapters;

import com.ibm.etools.qev.Debug;
import com.ibm.etools.qev.edit.IExtendedDesignEditor;
import com.ibm.etools.qev.model.adapters.EventsDocumentAdapter;
import com.ibm.etools.qev.model.adapters.EventsNodeAdapter;
import com.ibm.etools.qev.model.impl.ITagEventModelBuilder;
import com.ibm.etools.qev.registry.DefinitionsRegistry;
import com.ibm.etools.qev.registry.ModelBuilderDefinition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDDocument;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.sse.core.internal.provisional.AbstractAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.contentmodel.CMNodeWrapper;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class EventsNodeAdapterFactory
extends AbstractAdapterFactory {
    private ArrayList buildersList = new ArrayList();
    private EventsDocumentAdapter docAdapter;
    private boolean initialized = false;

    public EventsNodeAdapterFactory() {
        super(EventsNodeAdapter.class);
        this.loadBuildersFromRegistry(null);
    }

    public void addBuilderMapping(String uri, ITagEventModelBuilder builder) {
        BuilderMapping newMapping = new BuilderMapping();
        newMapping.builderKey = uri;
        newMapping.builder = builder;
        boolean found = false;
        Iterator buildersIter = this.buildersList.iterator();
        while (buildersIter.hasNext() && !found) {
            BuilderMapping mapping = (BuilderMapping)buildersIter.next();
            if (!mapping.equals(newMapping)) continue;
            found = true;
        }
        if (!found) {
            this.buildersList.add(newMapping);
        }
    }

    private EventsNodeAdapter buildNodeAdapter(IDOMNode node) {
        EventsNodeAdapter adapter = new EventsNodeAdapter(node, this);
        return adapter;
    }

    protected INodeAdapter createAdapter(INodeNotifier node) {
        if (node instanceof IDOMNode) {
            return this.buildNodeAdapter((IDOMNode)node);
        }
        return null;
    }

    private Iterator getBuildersForPrefix(String key) {
        ArrayList<ITagEventModelBuilder> tempList = new ArrayList<ITagEventModelBuilder>();
        for (BuilderMapping mapping : this.buildersList) {
            if (!mapping.builderKey.equals(key) || tempList.contains(mapping.builder)) continue;
            tempList.add(mapping.builder);
        }
        return tempList.iterator();
    }

    public void initBuilders(IExtendedDesignEditor editDomain) {
        if (!this.initialized) {
            IProject project = ((FileEditorInput)editDomain.getActiveEditorInput()).getFile().getProject();
            this.loadBuildersFromRegistry(project);
            ArrayList<ITagEventModelBuilder> tempList = new ArrayList<ITagEventModelBuilder>();
            for (BuilderMapping mapping : this.buildersList) {
                if (tempList.contains(mapping.builder)) continue;
                tempList.add(mapping.builder);
            }
            for (ITagEventModelBuilder builder : tempList) {
                try {
                    builder.initUpdater(editDomain);
                }
                catch (Exception t) {
                    Debug.log(2, t.getMessage(), t);
                }
            }
            this.initialized = true;
        }
    }

    private boolean isActiveBuilder(IProject project, ModelBuilderDefinition tempDef) {
        boolean result = false;
        List facets = tempDef.getFacets();
        if (facets.size() == 0) {
            result = true;
        } else {
            IFacetedProject facetedProject = null;
            if (project != null && project.isAccessible()) {
                try {
                    facetedProject = ProjectFacetsManager.create((IProject)project);
                }
                catch (CoreException coreException) {
                    return false;
                }
            }
            Iterator iter = facets.iterator();
            while (iter.hasNext() && !result) {
                IProjectFacet projectFacet;
                String facetId = (String)iter.next();
                if (facetedProject == null || !ProjectFacetsManager.isProjectFacetDefined((String)facetId) || (projectFacet = ProjectFacetsManager.getProjectFacet((String)facetId)) == null) continue;
                result = facetedProject.hasProjectFacet(projectFacet);
            }
        }
        return result;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private void loadBuildersFromRegistry(IProject project) {
        ModelBuilderDefinition tempDef = null;
        Iterator buildersIter = DefinitionsRegistry.getRegistry().getBuilders();
        while (buildersIter.hasNext()) {
            tempDef = (ModelBuilderDefinition)buildersIter.next();
            ITagEventModelBuilder builder = null;
            Iterator URIsIter = tempDef.getURIs();
            if (!this.isActiveBuilder(project, tempDef)) continue;
            while (URIsIter.hasNext()) {
                try {
                    String key = (String)URIsIter.next();
                    if (builder == null) {
                        builder = tempDef.createModelBuilder();
                    }
                    this.addBuilderMapping(key, builder);
                }
                catch (Exception t) {
                    Debug.log(2, t.getMessage(), t);
                }
            }
        }
    }

    public void refreshModel(EventsNodeAdapter adapter) {
        ITagEventModelBuilder builder;
        Debug.trace("adapters", "refresh model for: " + adapter.getName());
        adapter.clearEvents();
        IDOMNode node = adapter.getNode();
        if (this.docAdapter == null) {
            this.docAdapter = (EventsDocumentAdapter)node.getModel().getDocument().getAdapterFor(EventsDocumentAdapter.class);
        }
        Iterator builders = this.getBuildersForPrefix("");
        while (builders.hasNext()) {
            builder = (ITagEventModelBuilder)builders.next();
            try {
                builder.contributeEvents(adapter);
            }
            catch (Exception e) {
                Debug.log(202, e.getMessage(), e);
            }
        }
        String tagPrefix = node.getPrefix();
        if (tagPrefix != null) {
            String taglibURI;
            CMDocument cmdoc = ModelQueryUtil.getModelQuery((Document)node.getOwnerDocument()).getCorrespondingCMDocument((Node)node);
            if (cmdoc instanceof CMNodeWrapper) {
                cmdoc = (CMDocument)((CMNodeWrapper)cmdoc).getOriginNode();
            }
            if (cmdoc instanceof TLDDocument && (taglibURI = ((TLDDocument)cmdoc).getUri()) != null) {
                builders = this.getBuildersForPrefix(taglibURI);
                while (builders.hasNext()) {
                    builder = (ITagEventModelBuilder)builders.next();
                    try {
                        builder.contributeEvents(adapter);
                    }
                    catch (Exception e) {
                        Debug.log(202, e.getMessage(), e);
                    }
                }
            }
        }
    }

    class BuilderMapping {
        String builderKey;
        ITagEventModelBuilder builder;

        BuilderMapping() {
        }

        public boolean equals(BuilderMapping mapping) {
            return this.builderKey.equals(mapping.builderKey) && this.builder == mapping.builder;
        }
    }
}

