/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.model.adapters;

import com.ibm.etools.qev.Debug;
import com.ibm.etools.qev.model.impl.FunctionBounds;
import com.ibm.etools.qev.util.TextNodeUtil;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.javascript.core.internal.jsparser.lexer.Lexer;
import org.eclipse.wst.javascript.core.internal.jsparser.lexer.LexerException;
import org.eclipse.wst.javascript.core.internal.jsparser.node.EOF;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TIdentifier;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TPunctuator1;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TStringLiteral;
import org.eclipse.wst.javascript.core.internal.jsparser.node.Token;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.ui.internal.util.Sorter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentAssistUtilities;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EventsDocumentAdapter
implements INodeAdapter,
IDocumentListener {
    private Object key = EventsDocumentAdapter.class;
    private IDOMDocument doc;
    private boolean scriptMappingsNeedRefresh = true;
    private boolean jspDeclarationMappingsNeedRefresh = true;
    private ArrayList jsScriptNodesList = new ArrayList();
    private HashMap jsFunctions = new HashMap();
    private HashMap jsFunctionToNodeMap = new HashMap();
    private HashMap jsGlobalVars = new HashMap();
    private HashMap jsGlobalVarToNodeMap = new HashMap();
    private ArrayList dirtyScriptNodes = new ArrayList();
    private ArrayList jspDeclarationNodesList = new ArrayList();
    private HashMap jspDeclarationMethods = new HashMap();
    private HashMap jspMethodToNodeMap = new HashMap();
    private ArrayList dirtyDeclarationNodes = new ArrayList();
    private IProject currentProject = null;

    public EventsDocumentAdapter(IDOMDocument d) {
        Debug.trace("new adapter for document: " + d.getNodeName(), "adapters");
        this.doc = d;
        this.refreshAll();
        this.doc.getStructuredDocument().addDocumentListener((IDocumentListener)this);
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.scriptMappingsNeedRefresh = true;
        this.jspDeclarationMappingsNeedRefresh = true;
    }

    public FunctionBounds getBoundsForJspDeclaration(String methodName) {
        this.updateDirtyJspDeclarationMappings();
        return (FunctionBounds)this.jspDeclarationMethods.get(methodName);
    }

    public FunctionBounds getBoundsForScript(String functionName) {
        this.updateDirtyScriptMappings();
        return (FunctionBounds)this.jsFunctions.get(functionName);
    }

    public Region getBoundsForScriptVar(String varName) {
        this.updateDirtyScriptMappings();
        return (Region)this.jsGlobalVars.get(varName);
    }

    public Iterator getFunctionNames() {
        this.updateDirtyScriptMappings();
        return this.jsFunctions.keySet().iterator();
    }

    public Iterator getGlobalVarNames() {
        this.updateDirtyScriptMappings();
        return this.jsGlobalVars.keySet().iterator();
    }

    public List getJspDeclarationNodes() {
        this.updateDirtyJspDeclarationMappings();
        return this.jspDeclarationNodesList;
    }

    public Iterator getMethodNames() {
        this.updateDirtyJspDeclarationMappings();
        return this.jspDeclarationMethods.keySet().iterator();
    }

    public Node getNodeForJspDeclaration(String methodName) {
        this.updateDirtyJspDeclarationMappings();
        return (Node)this.jspMethodToNodeMap.get(methodName);
    }

    public Node getNodeForScript(String functionName) {
        this.updateDirtyScriptMappings();
        return (Node)this.jsFunctionToNodeMap.get(functionName);
    }

    public Node getNodeForScriptVar(String varName) {
        this.updateDirtyScriptMappings();
        return (Node)this.jsGlobalVarToNodeMap.get(varName);
    }

    public IProject getProjectForPage() {
        if (this.currentProject == null) {
            this.currentProject = this.doc.getModel().getResolver().getProject();
        }
        return this.currentProject;
    }

    public List getScriptNodes() {
        this.updateDirtyScriptMappings();
        return this.jsScriptNodesList;
    }

    public boolean isAdapterForType(Object arg0) {
        return this.key.equals(arg0);
    }

    public boolean isInJspDeclaration(String methodName) {
        this.updateDirtyJspDeclarationMappings();
        return this.jspDeclarationMethods.get(methodName) != null;
    }

    public boolean isInScriptTag(String functionName) {
        this.updateDirtyScriptMappings();
        return this.jsFunctions.get(functionName) != null;
    }

    public boolean isInScriptTagVar(String varName) {
        this.updateDirtyScriptMappings();
        return this.jsGlobalVars.get(varName) != null;
    }

    public boolean isMapped(Node n) {
        this.updateDirtyScriptMappings();
        this.updateDirtyJspDeclarationMappings();
        return this.jspDeclarationNodesList.contains(n) || this.jsScriptNodesList.contains(n);
    }

    public void markJspDeclarationNodeDirty(IDOMNode n) {
        Debug.trace("jsp declaration node marked dirty: " + n, "adapters");
        if (!this.dirtyDeclarationNodes.contains(n)) {
            this.dirtyDeclarationNodes.add(n);
        }
    }

    public void markScriptNodeDirty(IDOMNode n) {
        Debug.trace("script node marked dirty: " + n, "adapters");
        if (!this.dirtyScriptNodes.contains(n)) {
            this.dirtyScriptNodes.add(n);
        }
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
    }

    public List orderGlobalVarNames(List theVars) {
        if (theVars == null || theVars.size() == 0) {
            return theVars;
        }
        return Arrays.asList(new GlobalVarSorter().sort(theVars.toArray()));
    }

    /*
     * Unable to fully structure code
     */
    private String parseOutFuncNameFromTag(Lexer lexer, Token token) throws LexerException, IOException {
        result = null;
        if (!token.getText().equals("portletAPI")) ** GOTO lbl10
        while (!(token instanceof EOF) && !(token instanceof TStringLiteral)) {
            token = lexer.next();
        }
        result = token.getText().substring(1);
        result = result.substring(0, result.length() - 1);
        return result;
lbl-1000:
        // 1 sources

        {
            token = lexer.next();
lbl10:
            // 2 sources

            ** while (!(token instanceof EOF) && !token.getText().equals((Object)">"))
        }
lbl11:
        // 2 sources

        while (!(token instanceof EOF || token instanceof TIdentifier || token.getText().equals("("))) {
            token = lexer.next();
        }
        if (token instanceof TIdentifier) {
            result = token.getText();
        }
        return result;
    }

    private void processDeclarationNode(Node n, HashMap methodToNodeMap, HashMap methods) {
        String block = n.getNodeValue();
        Scanner javaScanner = new Scanner();
        javaScanner.setSource(block.toCharArray());
        int blockLength = block.length();
        int methodBegin = 0;
        int methodEnd = 0;
        int bodyBegin = 0;
        int bodyEnd = 0;
        try {
            javaScanner.getNextToken();
            while (javaScanner.getCurrentTokenEndPosition() < blockLength) {
                String token = new String(javaScanner.getCurrentIdentifierSource());
                if (token.equals("public")) {
                    methodBegin = javaScanner.getCurrentTokenStartPosition();
                    javaScanner.getNextToken();
                    javaScanner.getNextToken();
                    String methodName = new String(javaScanner.getCurrentIdentifierSource());
                    boolean findingBrace = true;
                    while (findingBrace) {
                        int linefeedIndex;
                        javaScanner.getNextToken();
                        token = new String(javaScanner.getCurrentIdentifierSource());
                        if (!token.equals("{")) continue;
                        findingBrace = false;
                        bodyBegin = javaScanner.getCurrentTokenEndPosition() + 1;
                        if (block.substring(bodyBegin, bodyBegin + (linefeedIndex = block.substring(bodyBegin).indexOf("\n"))).trim().length() != 0) continue;
                        bodyBegin = bodyBegin + linefeedIndex + 1;
                    }
                    javaScanner.jumpOverMethodBody();
                    bodyEnd = javaScanner.getCurrentTokenStartPosition();
                    methodEnd = javaScanner.getCurrentTokenEndPosition() + 1;
                    methodToNodeMap.put(methodName, n.getParentNode());
                    FunctionBounds bounds = new FunctionBounds();
                    bounds.setFunctionStart(methodBegin);
                    bounds.setFunctionEnd(methodEnd);
                    bounds.setBodyStart(bodyBegin);
                    bounds.setBodyEnd(bodyEnd);
                    methods.put(methodName, bounds);
                    Debug.trace("mapped method: " + methodName, "adapters");
                }
                javaScanner.getNextToken();
            }
        }
        catch (InvalidInputException invalidInputException) {
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processScriptNode(Node n, HashMap functionToNodeMap, HashMap functions, HashMap varToNodeMap, HashMap vars) {
        String block = n.getNodeValue();
        Lexer lexer = new Lexer(new PushbackReader(new StringReader(block), 1000));
        Token token = null;
        try {
            block23: {
                block22: {
                    token = lexer.next();
                    if (!true) break block22;
                    if (token == null) return;
                    if (token instanceof EOF) break block23;
                }
                do {
                    int endIndex;
                    int startIndex;
                    if (token.getText().equals("function")) {
                        startIndex = token.getLPOffset();
                        endIndex = -1;
                        int endBody = -1;
                        String functionName = null;
                        token = lexer.next();
                        boolean startTag = false;
                        while (!(token instanceof EOF || token instanceof TIdentifier || token.getText().equals("("))) {
                            token = lexer.next();
                            if (!token.getText().equals("<")) continue;
                            startTag = true;
                        }
                        if (!(token instanceof TIdentifier)) {
                            Debug.trace("BAD FUNCTION NAME IN SCRIPT PARSING", "adapters");
                            return;
                        }
                        if (startTag) {
                            startTag = false;
                            functionName = this.parseOutFuncNameFromTag(lexer, token);
                            if (functionName == null) {
                                Debug.trace("BAD FUNCTION NAME IN SCRIPT PARSING", "adapters");
                                return;
                            }
                        } else {
                            functionName = token.getText();
                            token = lexer.next();
                        }
                        while (!(token instanceof EOF) && !token.getText().equals("{")) {
                            token = lexer.next();
                        }
                        token = lexer.next();
                        int startBody = token.getLPOffset();
                        if (token.getContainsLineTerminator()) {
                            int lfIndex = token.getText().indexOf("\n");
                            startBody = startBody + lfIndex + 1;
                        }
                        boolean foundFunctionEnd = false;
                        int braceCounter = 1;
                        Token prevToken = token;
                        while (!(token instanceof EOF) && !foundFunctionEnd) {
                            if (token instanceof TPunctuator1) {
                                if (token.getText().equals("{")) {
                                    ++braceCounter;
                                }
                                if (token.getText().equals("}") && --braceCounter == 0) {
                                    int suggestedEndBody;
                                    int lfIndex;
                                    foundFunctionEnd = true;
                                    endBody = token.getLPOffset();
                                    endIndex = token.getEndLPOffset();
                                    if (prevToken.equals(token) || !prevToken.getContainsLineTerminator() || (lfIndex = prevToken.getText().lastIndexOf("\n")) <= -1 || (suggestedEndBody = prevToken.getLPOffset() + lfIndex) < startBody) break;
                                    endBody = suggestedEndBody;
                                    break;
                                }
                            }
                            prevToken = token;
                            token = lexer.next();
                        }
                        if (endIndex < startIndex) {
                            Debug.trace("BAD INDEXES IN SCRIPT PARSING", "adapters");
                        } else {
                            functionToNodeMap.put(functionName, n.getParentNode());
                            FunctionBounds bounds = new FunctionBounds();
                            bounds.setFunctionStart(startIndex);
                            bounds.setFunctionEnd(endIndex);
                            bounds.setBodyStart(startBody);
                            bounds.setBodyEnd(endBody);
                            functions.put(functionName, bounds);
                            Debug.trace("mapped function: " + functionName, "adapters");
                        }
                    }
                    if (token.getText().equals("var")) {
                        startIndex = token.getLPOffset();
                        endIndex = -1;
                        token = lexer.next();
                        token = lexer.next();
                        String varName = token.getText();
                        while (!(token instanceof EOF) && !token.getContainsLineTerminator()) {
                            token = lexer.next();
                        }
                        endIndex = token.getEndLPOffset();
                        if (endIndex < startIndex) {
                            Debug.trace("BAD INDEXES IN SCRIPT PARSING", "adapters");
                        } else {
                            varToNodeMap.put(varName, n.getParentNode());
                            Region bounds = new Region(startIndex, endIndex - startIndex);
                            vars.put(varName, bounds);
                            Debug.trace("mapped global variable: " + varName, "adapters");
                        }
                    }
                    token = lexer.next();
                    if (token == null) return;
                } while (!(token instanceof EOF));
            }
            return;
        }
        catch (Exception e) {
            Debug.log(202, "Error while processing script node", e);
        }
    }

    public void refreshAll() {
        this.refreshAllScriptMappings();
        this.refreshAllJspDeclarationMappings();
        Debug.trace("refreshing page model - new DOM scan", "adapters");
    }

    public void refreshAllJspDeclarationMappings() {
        this.jspDeclarationMethods.clear();
        this.jspMethodToNodeMap.clear();
        this.jspDeclarationNodesList.clear();
        this.dirtyDeclarationNodes.clear();
        NodeList nodeList = this.doc.getElementsByTagName("jsp:declaration");
        int i = 0;
        while (i < nodeList.getLength()) {
            IDOMNode n = (IDOMNode)nodeList.item(i);
            this.refreshJspDeclarationMapping(n);
            ++i;
        }
        this.jspDeclarationMappingsNeedRefresh = false;
        Debug.trace("refreshAllJspDeclarationMappings", "adapters");
    }

    public void refreshAllScriptMappings() {
        this.jsFunctions.clear();
        this.jsFunctionToNodeMap.clear();
        this.jsGlobalVars.clear();
        this.jsGlobalVarToNodeMap.clear();
        this.jsScriptNodesList.clear();
        this.dirtyScriptNodes.clear();
        NodeList nodeList = this.doc.getElementsByTagName("script");
        int i = 0;
        while (i < nodeList.getLength()) {
            IDOMNode n = (IDOMNode)nodeList.item(i);
            if (!(XMLContentAssistUtilities.getScriptLanguage((Node)n) != "javascript" || n.hasAttributes() && n.getAttributes().getNamedItem("src") != null)) {
                this.refreshScriptMapping(n);
            }
            ++i;
        }
        this.scriptMappingsNeedRefresh = false;
        Debug.trace("refreshAllScriptMappings", "adapters");
    }

    private void refreshJspDeclarationMapping(IDOMNode n) {
        Debug.trace("refreshJspDeclarationMapping()", "adapters");
        int index = this.jspDeclarationNodesList.indexOf(n);
        this.removeJspDeclarationMapping(n);
        if (index > -1) {
            this.jspDeclarationNodesList.add(index, n);
        } else {
            this.jspDeclarationNodesList.add(n);
        }
        Node tempNode = TextNodeUtil.findChildTextNode((Node)n);
        if (tempNode != null && tempNode.getNodeType() == 3) {
            this.processDeclarationNode(tempNode, this.jspMethodToNodeMap, this.jspDeclarationMethods);
        }
    }

    private void refreshScriptMapping(IDOMNode n) {
        Debug.trace("refreshScriptMapping()", "adapters");
        int index = this.jsScriptNodesList.indexOf(n);
        this.removeScriptMapping(n);
        if (index > -1) {
            this.jsScriptNodesList.add(index, n);
        } else {
            this.jsScriptNodesList.add(n);
        }
        Node tempNode = TextNodeUtil.findChildTextNode((Node)n);
        if (tempNode != null && tempNode.getNodeType() == 3) {
            this.processScriptNode(tempNode, this.jsFunctionToNodeMap, this.jsFunctions, this.jsGlobalVarToNodeMap, this.jsGlobalVars);
        }
    }

    public void release() {
        if (this.doc != null && this.doc.getStructuredDocument() != null) {
            this.doc.getStructuredDocument().removeDocumentListener((IDocumentListener)this);
        }
    }

    public void removeJspDeclarationMapping(IDOMNode n) {
        Debug.trace("removeJspDeclarationMapping()", "adapters");
        if (this.jspDeclarationNodesList.contains(n)) {
            this.jspDeclarationNodesList.remove(n);
            if (this.jspMethodToNodeMap.containsValue(n)) {
                Iterator<Object> iter = this.jspMethodToNodeMap.keySet().iterator();
                ArrayList removeList = new ArrayList();
                while (iter.hasNext()) {
                    Object o = iter.next();
                    if (this.jspMethodToNodeMap.get(o) != n) continue;
                    removeList.add(o);
                }
                for (Object o : removeList) {
                    this.jspMethodToNodeMap.remove(o);
                    this.jspDeclarationMethods.remove(o);
                }
            }
        }
    }

    public void removeScriptMapping(IDOMNode n) {
        Debug.trace("removeScriptMapping()", "adapters");
        if (this.jsScriptNodesList.contains(n)) {
            Object o2;
            ArrayList removeList;
            Iterator<Object> iter;
            this.jsScriptNodesList.remove(n);
            if (this.jsFunctionToNodeMap.containsValue(n)) {
                iter = this.jsFunctionToNodeMap.keySet().iterator();
                removeList = new ArrayList();
                while (iter.hasNext()) {
                    o2 = iter.next();
                    if (this.jsFunctionToNodeMap.get(o2) != n) continue;
                    removeList.add(o2);
                }
                for (Object o2 : removeList) {
                    this.jsFunctionToNodeMap.remove(o2);
                    this.jsFunctions.remove(o2);
                }
            }
            if (this.jsGlobalVarToNodeMap.containsValue(n)) {
                iter = this.jsGlobalVarToNodeMap.keySet().iterator();
                removeList = new ArrayList();
                while (iter.hasNext()) {
                    o2 = iter.next();
                    if (this.jsGlobalVarToNodeMap.get(o2) != n) continue;
                    removeList.add(o2);
                }
                for (Object o2 : removeList) {
                    this.jsGlobalVarToNodeMap.remove(o2);
                    this.jsGlobalVars.remove(o2);
                }
            }
        }
    }

    private void updateDirtyJspDeclarationMappings() {
        if (this.jspDeclarationMappingsNeedRefresh) {
            this.refreshAllJspDeclarationMappings();
        } else if (this.dirtyDeclarationNodes.size() > 0) {
            int i = 0;
            while (i < this.dirtyDeclarationNodes.size()) {
                this.refreshJspDeclarationMapping((IDOMNode)this.dirtyDeclarationNodes.get(i));
                ++i;
            }
            this.dirtyDeclarationNodes.clear();
        }
    }

    private void updateDirtyScriptMappings() {
        if (this.scriptMappingsNeedRefresh) {
            this.refreshAllScriptMappings();
        } else if (this.dirtyScriptNodes.size() > 0) {
            int i = 0;
            while (i < this.dirtyScriptNodes.size()) {
                this.refreshScriptMapping((IDOMNode)this.dirtyScriptNodes.get(i));
                ++i;
            }
            this.dirtyScriptNodes.clear();
        }
    }

    public class GlobalVarSorter
    extends Sorter {
        public boolean compare(Object elementOne, Object elementTwo) {
            int var2Index;
            String varName1 = (String)elementOne;
            String varName2 = (String)elementTwo;
            int var1Index = EventsDocumentAdapter.this.getScriptNodes().indexOf(EventsDocumentAdapter.this.getNodeForScriptVar(varName1));
            if (var1Index < (var2Index = EventsDocumentAdapter.this.getScriptNodes().indexOf(EventsDocumentAdapter.this.getNodeForScriptVar(varName2)))) {
                return true;
            }
            if (var1Index > var2Index) {
                return false;
            }
            if (var1Index == -1) {
                return false;
            }
            Region var1Bounds = EventsDocumentAdapter.this.getBoundsForScriptVar(varName1);
            Region var2Bounds = EventsDocumentAdapter.this.getBoundsForScriptVar(varName2);
            if (var1Bounds == null) {
                return true;
            }
            if (var2Bounds == null) {
                return false;
            }
            return var1Bounds.getOffset() < var2Bounds.getOffset();
        }
    }
}

