/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.edit;

import com.ibm.etools.qev.Debug;
import com.ibm.etools.qev.EventsConstants;
import com.ibm.etools.qev.edit.IEventsViewEditor;
import com.ibm.etools.qev.edit.IEventsViewEditorSaveablePart;
import com.ibm.etools.qev.edit.QEVEditorEditorSite;
import com.ibm.etools.qev.edit.TextEditorViewer;
import com.ibm.etools.qev.edit.VirtualEditorInput;
import com.ibm.etools.qev.model.IEvent;
import com.ibm.etools.qev.model.IEventEditorInfo;
import com.ibm.etools.qev.model.IEventScriptContext;
import com.ibm.etools.qev.util.StringUtil;
import com.ibm.etools.qev.view.QEVView;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class TextEditorQEVEditor
implements IEventsViewEditor,
IEventsViewEditorSaveablePart {
    protected FocusListener defaultTextFocusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
            if (TextEditorQEVEditor.this.isIgnoreOneCycle()) {
                TextEditorQEVEditor.this.setIgnoreOneCycle(false);
                QEVView.getViewInstance().setFocus();
            } else {
                TextEditorQEVEditor.this.handleDefaultTextFocusGained();
            }
        }

        public void focusLost(FocusEvent e) {
        }
    };
    protected TextEditorViewer editorViewer;
    protected IEditorInput virtualInput;
    protected IEvent currentEvent;
    protected String currentLanguage;
    protected String initialScript;
    protected boolean usingDefault;
    protected boolean ignoreOneCycle;

    protected void activateGlobalActions() {
        boolean actionBarChanged = false;
        String actionID = ITextEditorActionConstants.CUT;
        IAction action = this.editorViewer.getTextEditor().getAction(actionID);
        if (action != null && !action.equals(this.getEditorSite().getActionBars().getGlobalActionHandler(actionID))) {
            this.getEditorSite().getActionBars().setGlobalActionHandler(actionID, action);
            actionBarChanged = true;
        }
        actionID = ITextEditorActionConstants.COPY;
        action = this.editorViewer.getTextEditor().getAction(actionID);
        if (action != null && !action.equals(this.getEditorSite().getActionBars().getGlobalActionHandler(actionID))) {
            this.getEditorSite().getActionBars().setGlobalActionHandler(actionID, action);
            actionBarChanged = true;
        }
        actionID = ITextEditorActionConstants.PASTE;
        action = this.editorViewer.getTextEditor().getAction(actionID);
        if (action != null && !action.equals(this.getEditorSite().getActionBars().getGlobalActionHandler(actionID))) {
            this.getEditorSite().getActionBars().setGlobalActionHandler(actionID, action);
            actionBarChanged = true;
        }
        if (actionBarChanged) {
            this.getEditorSite().getActionBars().updateActionBars();
        }
        this.editorViewer.getTextEditor().setAction(ActionFactory.SAVE.getId(), (IAction)new SaveSourcePageAction(QEVView.getViewInstance()));
    }

    @Override
    public void addPropertyListener(IPropertyListener listener) {
        if (this.editorViewer != null && this.editorViewer.getTextEditor() != null) {
            this.editorViewer.getTextEditor().addPropertyListener(listener);
        }
    }

    @Override
    public void clearEditor() {
        this.currentEvent = null;
        this.currentLanguage = null;
        if (this.getSourceViewer() != null && this.getSourceViewer().getTextWidget() != null) {
            this.getSourceViewer().getTextWidget().removeFocusListener(this.defaultTextFocusListener);
        }
        this.setupVirtualInputInEditor("");
        this.editorViewer.getTextEditor().resetHighlightRange();
        this.editorViewer.getTextEditor().showHighlightRangeOnly(false);
        this.deactivateGlobalActions();
    }

    @Override
    public void contributeToPopupMenu(IMenuManager menu) {
        if (!this.usingDefault) {
            IAction action = this.editorViewer.getTextEditor().getAction(ITextEditorActionConstants.CUT);
            if (action != null) {
                menu.add(action);
            }
            if ((action = this.editorViewer.getTextEditor().getAction(ITextEditorActionConstants.COPY)) != null) {
                menu.add(action);
            }
            if ((action = this.editorViewer.getTextEditor().getAction(ITextEditorActionConstants.PASTE)) != null) {
                menu.add(action);
            }
        }
    }

    protected TextEditorViewer createEditorViewer(Composite parent) {
        return new TextEditorViewer(parent);
    }

    protected IEditorInput createVirtualInput() {
        return new VirtualEditorInput(String.valueOf(this.hashCode()) + ".txt");
    }

    protected void deactivateGlobalActions() {
        this.getEditorSite().getActionBars().clearGlobalActionHandlers();
        this.getEditorSite().getActionBars().updateActionBars();
        this.editorViewer.getTextEditor().setAction(ActionFactory.SAVE.getId(), null);
    }

    @Override
    public void dispose() {
        if (this.getSourceViewer() != null && this.getSourceViewer().getTextWidget() != null) {
            this.getSourceViewer().getTextWidget().removeFocusListener(this.defaultTextFocusListener);
        }
        this.deactivateGlobalActions();
        this.editorViewer.dispose();
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        ITextEditor editor;
        if (this.editorViewer != null && this.editorViewer.getTextEditor() != null && (editor = this.editorViewer.getTextEditor()).getEditorInput() != this.virtualInput) {
            this.editorViewer.getTextEditor().doSave(monitor);
        }
    }

    @Override
    public void editorActivated() {
        if (this.getEditorSite() instanceof QEVEditorEditorSite) {
            ((QEVEditorEditorSite)this.getEditorSite()).activate();
        }
    }

    @Override
    public void editorDeactivated() {
        try {
            try {
                if (this.initialScript != null && this.currentEvent != null && this.currentEvent.getScript() != null && this.initialScript.trim().equals(this.currentEvent.getScript().trim())) {
                    this.currentEvent.getEventUpdater().forceRemove(this.currentEvent, null);
                    QEVView.getViewInstance().getEventTableViewer().update((Object)this.currentEvent, null);
                }
            }
            catch (Exception e) {
                Debug.log(202, "editorDeactivated: An exception was thrown during deactivation: ", e);
                this.currentEvent = null;
                this.currentLanguage = null;
                if (this.getEditorSite() instanceof QEVEditorEditorSite) {
                    ((QEVEditorEditorSite)this.getEditorSite()).deactivate();
                }
                this.deactivateGlobalActions();
            }
        }
        finally {
            this.currentEvent = null;
            this.currentLanguage = null;
            if (this.getEditorSite() instanceof QEVEditorEditorSite) {
                ((QEVEditorEditorSite)this.getEditorSite()).deactivate();
            }
            this.deactivateGlobalActions();
        }
    }

    protected String generateVisibleScript(IEvent event) {
        String eventScript = event.getScript();
        if (eventScript == null) {
            eventScript = "";
        }
        eventScript = StringUtil.stripCRs(eventScript);
        Debug.trace("view", "generateVisibleScript: " + eventScript);
        return eventScript;
    }

    @Override
    public Control getControl() {
        return this.editorViewer.getControl();
    }

    @Override
    public IDocument getDocument() {
        IDocument doc = this.editorViewer.getTextEditor().getDocumentProvider().getDocument((Object)this.editorViewer.getTextEditor().getEditorInput());
        return doc;
    }

    protected IEditorSite getEditorSite() {
        return this.editorViewer.getTextEditor().getEditorSite();
    }

    @Override
    public String getScript() {
        if (this.getSourceViewer() != null && this.getSourceViewer().getTextWidget() != null) {
            return this.getSourceViewer().getTextWidget().getText();
        }
        return null;
    }

    @Override
    public ISourceViewer getSourceViewer() {
        return this.editorViewer.getSourceViewer();
    }

    protected IEditorInput getVirtualInput() {
        if (this.virtualInput == null) {
            this.virtualInput = this.createVirtualInput();
        }
        return this.virtualInput;
    }

    protected void handleDefaultTextFocusGained() {
        this.getSourceViewer().getTextWidget().removeFocusListener(this.defaultTextFocusListener);
        try {
            this.currentEvent.getEventUpdater().forceCreate(this.currentEvent, "", this.currentLanguage, null);
            this.setupEditorForScriptedEvent(this.currentEvent, this.currentLanguage);
            this.initialScript = this.currentEvent.getScript();
            this.activateGlobalActions();
            QEVView.getViewInstance().getEventTableViewer().update((Object)this.currentEvent, null);
        }
        catch (Exception e) {
            Debug.log(202, "handleDefaultTextFocusGained: An exception was thrown during setup: ", e);
            QEVView.getViewInstance().errorClearEditor();
        }
    }

    @Override
    public boolean isDirty() {
        ITextEditor editor;
        if (this.editorViewer != null && this.editorViewer.getTextEditor() != null && (editor = this.editorViewer.getTextEditor()).getEditorInput() != this.virtualInput) {
            return this.editorViewer.getTextEditor().isDirty();
        }
        return false;
    }

    public boolean isIgnoreOneCycle() {
        return this.ignoreOneCycle;
    }

    @Override
    public void removePropertyListener(IPropertyListener listener) {
        if (this.editorViewer != null && this.editorViewer.getTextEditor() != null) {
            this.editorViewer.getTextEditor().removePropertyListener(listener);
        }
    }

    @Override
    public void setIgnoreOneCycle(boolean b) {
        this.ignoreOneCycle = b;
    }

    @Override
    public void setupEditorControl(IWorkbenchPartSite site, Composite parent, int style) {
        this.editorViewer = this.createEditorViewer(parent);
        this.editorViewer.init(site, this.getVirtualInput());
    }

    protected void setupEditorForDefault() {
        if (this.getSourceViewer() != null && this.getSourceViewer().getTextWidget() != null && this.getSourceViewer().getTextWidget().isFocusControl()) {
            this.handleDefaultTextFocusGained();
            String init = this.getScript();
            this.getSourceViewer().getTextWidget().setText(init);
            return;
        }
        if (!this.currentEvent.isReadOnly()) {
            this.usingDefault = true;
            this.setupVirtualInputInEditor(EventsConstants.DEFAULT_EVENT_EDITOR_TEXT);
            if (this.getSourceViewer() != null && this.getSourceViewer().getTextWidget() != null) {
                this.getSourceViewer().getTextWidget().addFocusListener(this.defaultTextFocusListener);
                this.getSourceViewer().setEditable(true);
            }
        } else {
            this.setupVirtualInputInEditor("");
            this.getSourceViewer().setEditable(false);
        }
        this.editorViewer.getTextEditor().showHighlightRangeOnly(true);
        this.editorViewer.getTextEditor().resetHighlightRange();
        this.deactivateGlobalActions();
    }

    @Override
    public void setupEditorForEvent(IEvent event, String language) {
        this.setupEditorForEvent(event, language, false);
    }

    public void setupEditorForEvent(IEvent event, String language, boolean forceVirtual) {
        if (this.getSourceViewer() != null && this.getSourceViewer().getTextWidget() != null) {
            this.getSourceViewer().getTextWidget().removeFocusListener(this.defaultTextFocusListener);
        }
        try {
            if (this.currentEvent != null && !this.currentEvent.equals(event) && this.initialScript != null && this.currentEvent != null && this.currentEvent.getScript() != null && this.initialScript.trim().equals(this.currentEvent.getScript().trim())) {
                this.currentEvent.getEventUpdater().forceRemove(this.currentEvent, null);
                QEVView.getViewInstance().getEventTableViewer().update((Object)this.currentEvent, null);
            }
            this.currentEvent = event;
            this.initialScript = null;
            this.currentLanguage = language;
            this.setIgnoreOneCycle(false);
            if (event != null && event.isScripted()) {
                this.setupEditorForScriptedEvent(event, language, forceVirtual);
            } else {
                this.setupEditorForDefault();
            }
        }
        catch (Exception e) {
            Debug.log(202, "setupEditorForEvent: An exception was thrown during setup: ", e);
            QEVView.getViewInstance().errorClearEditor();
        }
    }

    protected void setupEditorForScriptedEvent(IEvent event, String language) {
        this.setupEditorForScriptedEvent(event, language, false);
    }

    protected void setupEditorForScriptedEvent(IEvent event, String language, boolean forceVirtual) {
        Position visiblePosition = null;
        IEventEditorInfo info = event.getEditorInfo();
        IEditorInput input = null;
        if (info != null) {
            input = info.getEditorInput();
        }
        if (input != null) {
            if (!input.equals(this.editorViewer.getTextEditor().getEditorInput())) {
                this.editorViewer.setInput(input);
            }
            visiblePosition = event.getScriptPosition();
            if (forceVirtual && visiblePosition == null) {
                visiblePosition = this.setupVirtualInput(event, language);
            }
        } else {
            visiblePosition = this.setupVirtualInput(event, language);
        }
        if (visiblePosition != null) {
            boolean addedSpace = false;
            if (event != null && !event.isReadOnly()) {
                this.getSourceViewer().setEditable(true);
                if (visiblePosition.getLength() == 0) {
                    try {
                        this.getDocument().replace(visiblePosition.getOffset(), 0, " ");
                        visiblePosition = new Position(visiblePosition.getOffset(), 1);
                        addedSpace = true;
                    }
                    catch (BadLocationException e) {
                        Debug.log(202, "setupEditorForScriptedEvent: error when try to add space to visible region", e);
                        this.getSourceViewer().setEditable(false);
                    }
                }
            } else {
                this.getSourceViewer().setEditable(false);
            }
            this.usingDefault = false;
            this.editorViewer.getTextEditor().showHighlightRangeOnly(true);
            this.editorViewer.getTextEditor().setHighlightRange(visiblePosition.getOffset(), visiblePosition.getLength(), true);
            if (addedSpace) {
                try {
                    this.getDocument().replace(visiblePosition.getOffset(), 1, "");
                }
                catch (BadLocationException e) {
                    Debug.log(202, "setupEditorForScriptedEvent: error when try to delete space from visible region", e);
                }
            }
            this.activateGlobalActions();
        } else if (!event.isScripted()) {
            Debug.trace("view", "setupEditorForScriptedEvent: event is not really scripted, calling setupEditorForDefault");
            this.setupEditorForDefault();
        } else {
            Debug.trace("view", "setupEditorForScriptedEvent: event claims isScripted but has no script position");
            QEVView.getViewInstance().errorClearEditor();
        }
    }

    protected Position setupVirtualInput(IEvent event, String language) {
        StringBuffer dummyPage = new StringBuffer(200);
        IEventScriptContext context = event.getContextForLanguage(language);
        if (context != null) {
            dummyPage.append(context.getPreScript());
            Debug.trace("view", "setupEditorForEvent(preScript): " + context.getPreScript());
        }
        dummyPage.append("\n");
        Position visiblePosition = new Position(dummyPage.length());
        String visibleScript = this.generateVisibleScript(event);
        dummyPage.append(visibleScript);
        visiblePosition.setLength(visibleScript.length());
        if (context != null) {
            dummyPage.append(context.getPostScript());
            Debug.trace("view", "setupEditorForEvent(postScript): " + context.getPostScript());
        }
        this.setupVirtualInputInEditor(dummyPage.toString());
        return visiblePosition;
    }

    protected void setupVirtualInputInEditor(String contents) {
        if (!this.getVirtualInput().equals(this.editorViewer.getTextEditor().getEditorInput())) {
            this.editorViewer.setInput(this.getVirtualInput());
        }
        this.getDocument().set(contents);
    }

    private class SaveSourcePageAction
    extends Action {
        private QEVView qevView;

        public SaveSourcePageAction(QEVView qevView) {
            super("");
            this.setId(ActionFactory.SAVE.getId());
            this.setActionDefinitionId("org.eclipse.ui.file.save");
            this.qevView = qevView;
        }

        public void run() {
            if (this.qevView != null) {
                this.qevView.doSave((IProgressMonitor)new NullProgressMonitor());
            }
        }
    }
}

