/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.edit;

import com.ibm.etools.qev.edit.QEVEditorEditorSite;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IKeyBindingService;

public class QEVEditorKeyBindingService
implements IKeyBindingService {
    private QEVEditorEditorSite fSite;
    String[] fScopes = new String[]{"org.eclipse.ui.globalScope"};
    private String[] fMainScopes;
    private HashMap fCommandIdToActionMap = new HashMap();

    public QEVEditorKeyBindingService(QEVEditorEditorSite site) {
        this.fSite = site;
    }

    public void activate() {
        Iterator i = this.fCommandIdToActionMap.values().iterator();
        while (i.hasNext()) {
            this.getOuterService().registerAction((IAction)i.next());
        }
        this.fMainScopes = this.getOuterService().getScopes();
        this.getOuterService().setScopes(this.getScopes());
    }

    public void deactivate() {
        Iterator i = this.fCommandIdToActionMap.values().iterator();
        while (i.hasNext()) {
            this.getOuterService().unregisterAction((IAction)i.next());
        }
        if (this.fMainScopes != null) {
            this.getOuterService().setScopes(this.fMainScopes);
        }
    }

    private IKeyBindingService getOuterService() {
        return this.fSite.getMainSite().getKeyBindingService();
    }

    public String[] getScopes() {
        return (String[])this.fScopes.clone();
    }

    private boolean isActive() {
        return this.fSite.isActive();
    }

    public void registerAction(IAction action) {
        String command = action.getActionDefinitionId();
        if (command != null) {
            this.fCommandIdToActionMap.put(command, action);
            if (this.isActive()) {
                this.getOuterService().registerAction(action);
            }
        }
    }

    public void setScopes(String[] scopes) {
        if (scopes == null || scopes.length < 1) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < scopes.length) {
            if (scopes[i] == null) {
                throw new IllegalArgumentException();
            }
            ++i;
        }
        this.fScopes = (String[])scopes.clone();
        if (this.isActive()) {
            this.fMainScopes = this.getOuterService().getScopes();
            this.getOuterService().setScopes(scopes);
        }
    }

    public void unregisterAction(IAction action) {
        String command = action.getActionDefinitionId();
        if (command != null) {
            this.fCommandIdToActionMap.remove(command);
            if (this.isActive()) {
                this.getOuterService().unregisterAction(action);
            }
        }
    }
}

