/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.edit;

import com.ibm.etools.qev.Debug;
import com.ibm.etools.qev.actions.ActionVariableInsertionDialog;
import com.ibm.etools.qev.actions.IActionDetector;
import com.ibm.etools.qev.actions.IActionVariableDialog;
import com.ibm.etools.qev.actions.SimpleAction;
import com.ibm.etools.qev.edit.IEventsViewEditor;
import com.ibm.etools.qev.edit.IEventsViewEditorSaveablePart;
import com.ibm.etools.qev.model.IEvent;
import com.ibm.etools.qev.nls.ResourceHandler;
import com.ibm.etools.qev.registry.ActionDefinition;
import com.ibm.etools.qev.registry.DefinitionsRegistry;
import com.ibm.etools.qev.registry.DetectorDefinition;
import com.ibm.etools.qev.view.BreakApartActionAction;
import com.ibm.etools.qev.view.DeleteActionAction;
import com.ibm.etools.qev.view.EditActionVariablesAction;
import com.ibm.etools.qev.view.EditorPanel;
import com.ibm.etools.qev.view.NewSimpleActionMenu;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPropertyListener;

public class EventEditManager {
    private IMenuListener contextMenuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            EventEditManager.this.fillContextMenu(manager);
        }
    };
    private IPropertyListener fPropertyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            EventEditManager.this.firePropertyChange(propId);
        }
    };
    private static final String QEVEDITOR_POPUPMENU_ID = "#QEVEditorPopupMenu";
    private EditorPanel panel;
    private IEventsViewEditor editor;
    private MenuManager contextMenuManager = null;
    private EditActionVariablesAction editActionAction = null;
    private DeleteActionAction deleteActionAction = null;
    private NewSimpleActionMenu insertNewActionsMenu = null;
    private BreakApartActionAction breakApartActionAction = null;
    private ListenerList propChangeListeners = new ListenerList(2);
    private IEvent currentEvent;
    private ArrayList actions = null;
    private HashMap detectors = null;

    public void addPropertyListener(IPropertyListener l) {
        this.propChangeListeners.add((Object)l);
    }

    public void clearEditor() {
        if (this.editor != null) {
            this.editor.clearEditor();
        }
        if (!this.getActions().isEmpty()) {
            this.actions.clear();
        }
        if (!this.getDetectors().isEmpty()) {
            this.detectors.clear();
        }
        this.currentEvent = null;
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.editor instanceof IEventsViewEditorSaveablePart) {
            ((IEventsViewEditorSaveablePart)((Object)this.editor)).doSave(monitor);
        }
    }

    void fillContextMenu(IMenuManager manager) {
        this.getNewActionMenu().setCurrentEvent(this.currentEvent);
        SimpleAction a = this.getActionAtOffset(this.getCurrentOffset());
        this.getEditActionAction().setSimpleAction(a);
        this.getBreakApartActionAction().setSimpleAction(a);
        this.getDeleteActionAction().setSimpleAction(a);
        manager.add((IContributionItem)this.getNewActionMenu());
        manager.add((IAction)this.getEditActionAction());
        manager.add((IAction)this.getBreakApartActionAction());
        manager.add((IAction)this.getDeleteActionAction());
        manager.add((IContributionItem)new Separator("additions"));
        this.editor.contributeToPopupMenu(manager);
    }

    private void firePropertyChange(final int propertyId) {
        Object[] array = this.propChangeListeners.getListeners();
        int nX = 0;
        while (nX < array.length) {
            final IPropertyListener l = (IPropertyListener)array[nX];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.propertyChanged((Object)EventEditManager.this.editor, propertyId);
                }
            });
            ++nX;
        }
    }

    public SimpleAction getActionAtOffset(int offset) {
        ArrayList l = this.getActions();
        int i = 0;
        while (i < l.size()) {
            SimpleAction a = (SimpleAction)l.get(i);
            if (a.isInsideAction(offset, 0)) {
                return a;
            }
            ++i;
        }
        return null;
    }

    public ArrayList getActions() {
        if (this.actions == null) {
            this.actions = new ArrayList();
        }
        return this.actions;
    }

    public BreakApartActionAction getBreakApartActionAction() {
        if (this.breakApartActionAction == null) {
            this.breakApartActionAction = new BreakApartActionAction();
        }
        return this.breakApartActionAction;
    }

    public MenuManager getContextMenuManager() {
        if (this.contextMenuManager == null) {
            this.contextMenuManager = new MenuManager(QEVEDITOR_POPUPMENU_ID, QEVEDITOR_POPUPMENU_ID);
            this.contextMenuManager.setRemoveAllWhenShown(true);
            this.contextMenuManager.addMenuListener(this.contextMenuListener);
        }
        return this.contextMenuManager;
    }

    public int getCurrentOffset() {
        if (this.editor != null) {
            return this.editor.getSourceViewer().getSelectedRange().x;
        }
        return -1;
    }

    public DeleteActionAction getDeleteActionAction() {
        if (this.deleteActionAction == null) {
            this.deleteActionAction = new DeleteActionAction();
        }
        return this.deleteActionAction;
    }

    public HashMap getDetectors() {
        if (this.detectors == null) {
            this.detectors = new HashMap();
        }
        return this.detectors;
    }

    public EditActionVariablesAction getEditActionAction() {
        if (this.editActionAction == null) {
            this.editActionAction = new EditActionVariablesAction();
        }
        return this.editActionAction;
    }

    public IEventsViewEditor getEditor() {
        return this.editor;
    }

    public NewSimpleActionMenu getNewActionMenu() {
        if (this.insertNewActionsMenu == null) {
            this.insertNewActionsMenu = new NewSimpleActionMenu(this);
        }
        return this.insertNewActionsMenu;
    }

    public String getScript() {
        if (this.editor != null) {
            return this.editor.getScript();
        }
        return null;
    }

    private StyledText getTextWidget() {
        if (this.editor.getSourceViewer() != null) {
            return this.editor.getSourceViewer().getTextWidget();
        }
        return null;
    }

    private void handleActionInsert(ActionDefinition actionDef, int offset) {
        Debug.trace("handleActionInsert() - action: " + actionDef + ", offset: " + offset, "actions");
        SimpleAction action = actionDef.createSimpleAction();
        if (action != null) {
            this.panel.setFocus();
            offset = this.editor.getSourceViewer().getSelectedRange().x;
            if (this.getActionAtOffset(offset) != null) {
                MessageDialog.openInformation((Shell)this.panel.getShell(), (String)ResourceHandler.Action_Insertion_Error, (String)ResourceHandler.Cannot_insert_action_within_another_action);
                return;
            }
            if (action.getVariables() != null && action.getVariables().length > 0) {
                action.setEvent(this.currentEvent);
                action.setDocument(this.editor.getDocument());
                IActionVariableDialog dialog = actionDef.createActionDialog();
                if (dialog == null) {
                    dialog = new ActionVariableInsertionDialog();
                }
                dialog.setAction(action);
                int result = 1;
                result = dialog.open();
                if (result == 0) {
                    action.insert(offset, (IActionDetector)this.detectors.get(actionDef.getDetectorId()));
                    this.actions.add(action);
                } else {
                    action.setEvent(null);
                    action.setDocument(null);
                }
            } else {
                action.setEvent(this.currentEvent);
                action.setDocument(this.editor.getDocument());
                action.insert(offset, (IActionDetector)this.detectors.get(actionDef.getDetectorId()));
                this.actions.add(action);
            }
        }
    }

    public void init(EditorPanel editorPanel) {
        this.panel = editorPanel;
    }

    public void insertAction(ActionDefinition actionDef, int offset) {
        this.handleActionInsert(actionDef, offset);
    }

    public boolean isDirty() {
        if (this.editor != null) {
            return this.editor.isDirty();
        }
        return false;
    }

    public void removePropertyListener(IPropertyListener l) {
        this.propChangeListeners.remove((Object)l);
    }

    public void setContextMenuManager(MenuManager contextMenuManager) {
        this.contextMenuManager = contextMenuManager;
    }

    public void setEditorEnvironment(IEvent event, String language) {
        if (!this.getActions().isEmpty()) {
            this.actions.clear();
        }
        if (!this.getDetectors().isEmpty()) {
            this.detectors.clear();
        }
        this.currentEvent = event;
        this.panel.showDefaultEditorForLanguage(language);
        if (this.editor != this.panel.getCurrentEditor()) {
            if (this.editor != null) {
                this.editor.clearEditor();
                if (this.editor instanceof IEventsViewEditorSaveablePart) {
                    ((IEventsViewEditorSaveablePart)((Object)this.editor)).removePropertyListener(this.fPropertyListener);
                }
            }
            this.editor = this.panel.getCurrentEditor() != null ? this.panel.getCurrentEditor() : null;
        }
        if (this.editor == null) {
            return;
        }
        Menu menu = this.getContextMenuManager().createContextMenu((Control)this.getTextWidget());
        this.getTextWidget().setMenu(menu);
        this.setupEditor(event, language);
    }

    public void setIgnoreOneCycle(boolean delay) {
        if (this.editor != null) {
            this.editor.setIgnoreOneCycle(delay);
        }
    }

    private void setupEditor(IEvent event, String language) {
        if (event != null) {
            this.editor.setupEditorForEvent(event, language);
            Iterator possibleActions = this.getNewActionMenu().getPossibleActions(event);
            while (possibleActions.hasNext()) {
                ActionDefinition def = (ActionDefinition)possibleActions.next();
                String id = def.getDetectorId();
                if (id == null || this.detectors.get(id) != null) continue;
                DetectorDefinition dd = DefinitionsRegistry.getRegistry().getDetector(id);
                this.detectors.put(id, dd.createActionDetector());
            }
            if (event != null && event.isScripted()) {
                int offset = this.editor.getSourceViewer().getVisibleRegion().getOffset();
                int length = this.editor.getSourceViewer().getVisibleRegion().getLength();
                for (IActionDetector ad : this.detectors.values()) {
                    this.actions.addAll(ad.findActions(event, this.editor.getDocument(), offset, length));
                }
            }
        }
        if (this.editor instanceof IEventsViewEditorSaveablePart) {
            ((IEventsViewEditorSaveablePart)((Object)this.editor)).addPropertyListener(this.fPropertyListener);
        }
    }

    public void switchEditorLanguage(String language) {
        this.setEditorEnvironment(this.currentEvent, language);
    }
}

