/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.actions.javascript;

import com.ibm.etools.qev.Debug;
import com.ibm.etools.qev.actions.CommentActionDetector;
import com.ibm.etools.qev.actions.InfoRegion;

public class JavascriptCommentActionDetector
extends CommentActionDetector {
    @Override
    public InfoRegion findActionPostfix(String script, int offset, int length, String actionID) {
        int startOffset = offset;
        boolean keepSearching = true;
        while (startOffset < offset + length - 1 && keepSearching) {
            int commentBegin;
            keepSearching = false;
            String subscript = script.substring(startOffset, offset + length);
            int end = subscript.indexOf("actionEnd: ");
            if (end <= -1 || (commentBegin = subscript.lastIndexOf(this.getBeginComment(), end)) <= -1) continue;
            int endComment = subscript.indexOf(this.getEndComment(), commentBegin + this.getBeginComment().length() - 1);
            if (endComment == -1) {
                endComment = subscript.length();
            }
            if (endComment <= -1 || endComment < end + "actionEnd: ".length()) continue;
            String id = subscript.substring(end + "actionEnd: ".length() - 1, endComment).trim();
            if (actionID == null || actionID.equals(id)) {
                int beginCommentOffset = commentBegin + startOffset;
                int commentLength = endComment + this.getEndComment().length() - commentBegin;
                Debug.trace("actions", "CommentActionDetector#findEndComment: begin=" + beginCommentOffset + " length=" + commentLength + " actionID=" + actionID);
                return new InfoRegion(beginCommentOffset, commentLength, id);
            }
            startOffset = startOffset + endComment + this.getEndComment().length() - 1;
            keepSearching = true;
        }
        return null;
    }

    @Override
    public String getBeginComment() {
        return "//";
    }

    @Override
    public String getEndComment() {
        return "\n";
    }
}

