/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.actions.javascript;

import com.ibm.etools.qev.Debug;
import com.ibm.etools.qev.actions.IActionDetector;
import com.ibm.etools.qev.actions.SimpleTextInsertAction;
import com.ibm.etools.qev.model.IEvent;
import com.ibm.etools.qev.model.adapters.EventsDocumentAdapter;
import java.util.ArrayList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.html.core.internal.modelquery.DocumentQuery;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ComplexJavascriptInsertAction
extends SimpleTextInsertAction {
    protected String lineDelimiter = "\n";
    private ArrayList functions;
    private ArrayList globalVars;

    public ComplexJavascriptInsertAction(String id) {
        super(id);
    }

    public void addFunction(FunctionVarItem f) {
        this.getFunctions().add(f);
    }

    public void addGlobalVar(FunctionVarItem v) {
        this.getGlobalVars().add(v);
    }

    private Element createScriptNode(Document domDoc, String text, boolean commented) {
        Element newScriptNode = domDoc.createElement("SCRIPT");
        newScriptNode.setAttribute("type", "text/javascript");
        if (text == null) {
            text = new String();
        }
        String toInsert = String.valueOf(this.lineDelimiter) + text + this.lineDelimiter;
        if (commented) {
            toInsert = String.valueOf(this.lineDelimiter) + "<!--" + this.lineDelimiter + text + this.lineDelimiter + "//-->" + this.lineDelimiter;
        }
        Text textNode = domDoc.createTextNode(toInsert);
        newScriptNode.appendChild(textNode);
        return newScriptNode;
    }

    public ArrayList getFunctions() {
        if (this.functions == null) {
            this.functions = new ArrayList();
        }
        return this.functions;
    }

    private StringBuffer getFunctionsInsertString(EventsDocumentAdapter pageInfo) {
        StringBuffer toInsert = new StringBuffer();
        if (!this.getFunctions().isEmpty()) {
            int i = 0;
            while (i < this.getFunctions().size()) {
                FunctionVarItem item = (FunctionVarItem)this.getFunctions().get(i);
                if (pageInfo == null || !pageInfo.isInScriptTag(item.getName())) {
                    toInsert.append(item.getContents());
                }
                ++i;
            }
        }
        return toInsert;
    }

    public ArrayList getGlobalVars() {
        if (this.globalVars == null) {
            this.globalVars = new ArrayList();
        }
        return this.globalVars;
    }

    private StringBuffer getGlobalVarsInsertString(EventsDocumentAdapter pageInfo) {
        StringBuffer toInsert = new StringBuffer();
        if (!this.getGlobalVars().isEmpty()) {
            int i = 0;
            while (i < this.getGlobalVars().size()) {
                FunctionVarItem item = (FunctionVarItem)this.getGlobalVars().get(i);
                if (pageInfo == null || !pageInfo.isInScriptTagVar(item.getName())) {
                    toInsert.append(item.getContents());
                }
                ++i;
            }
        }
        return toInsert;
    }

    @Override
    public void insert(int offset) {
        this.insert(offset, null);
    }

    @Override
    public void insert(int offset, IActionDetector extractor) {
        if (this.getDocument() != null) {
            IStructuredModel sm = StructuredModelManager.getModelManager().getExistingModelForEdit(this.getDocument());
            if (sm != null) {
                sm.beginRecording((Object)this);
            }
            this.insertScriptBody(this.getEvent(), this.getDocument(), offset, true, extractor);
            this.insertScriptHead(this.getEvent(), this.getDocument());
            if (sm != null) {
                sm.endRecording((Object)this);
            }
            if (sm != null) {
                sm.releaseFromEdit();
            }
        }
    }

    protected void insertHead(String text, IDOMModel model) {
        IDOMDocument domDoc = model.getDocument();
        DocumentQuery query = (DocumentQuery)domDoc.getAdapterFor(DocumentQuery.class);
        if (query != null) {
            query.getHeadCorrespondentNode((Node)domDoc, !query.isFragment((Document)domDoc));
            DocumentQuery.InsertionTarget target = query.getHeadInsertionTarget((Document)domDoc);
            if (target != null) {
                Element newScriptNode = this.createScriptNode((Document)domDoc, text, true);
                target.getParent().insertBefore(newScriptNode, target.getRef());
            }
        }
    }

    @Override
    public void insertMainScript(IEvent e, IDocument doc, int offset) {
        this.insertScriptHead(e, doc);
        this.insertScriptBody(e, doc, offset, false, null);
    }

    public void insertScriptHead(IEvent e, IDocument doc) {
        Debug.trace("actions", "insertAdditionalScript-inserting into event doc");
        IStructuredModel sm = StructuredModelManager.getModelManager().getExistingModelForEdit(doc);
        EventsDocumentAdapter pageInfo = null;
        IDOMModel xmlModel = (IDOMModel)sm;
        if (sm != null) {
            pageInfo = (EventsDocumentAdapter)xmlModel.getDocument().getAdapterFor(EventsDocumentAdapter.class);
            StringBuffer toInsert = this.getGlobalVarsInsertString(pageInfo);
            toInsert.append(this.getFunctionsInsertString(pageInfo));
            if (toInsert.length() > 0) {
                this.insertHead(toInsert.toString(), xmlModel);
            }
            sm.releaseFromEdit();
        }
    }

    protected class FunctionVarItem {
        private String name;
        private String contents;

        public FunctionVarItem(String n, String c) {
            this.name = n;
            this.contents = c;
        }

        public String getContents() {
            return this.contents;
        }

        public String getName() {
            return this.name;
        }

        public void setContents(String string) {
            this.contents = string;
        }

        public void setName(String string) {
            this.name = string;
        }
    }
}

