/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev.actions;

import com.ibm.etools.qev.Debug;
import com.ibm.etools.qev.actions.ActionVariable;
import com.ibm.etools.qev.actions.CommentActionDetector;
import com.ibm.etools.qev.actions.IActionDetector;
import com.ibm.etools.qev.actions.InfoRegion;
import com.ibm.etools.qev.actions.SimpleAction;
import com.ibm.etools.qev.actions.SimpleActionComparator;
import com.ibm.etools.qev.model.IEvent;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.wst.common.snippets.core.ISnippetVariable;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteItem;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.text.DeleteEqualPositionUpdater;

public abstract class SimpleTextInsertAction
extends SnippetPaletteItem
implements SimpleAction {
    public static String PARM_START = "${";
    public static String PARM_END = "}";
    protected static String LINE_DELIMITER = "\n";
    private static final String SIMPLE_ACTION_CATEGORY = "_simpleTextInsertAction_category";
    private boolean readOnly = false;
    private IEvent currentEvent;
    private IDocument currentDoc;
    private Position mainScriptPosition;
    private Position prefixPosition;
    private Position postfixPosition;
    private boolean deleted;

    public SimpleTextInsertAction(String id) {
        super(id);
        this.setId(id);
    }

    public SimpleTextInsertAction(String id, IDocument doc, IEvent e) {
        this(id);
        this.setDocument(doc);
        this.setEvent(e);
    }

    private void addActionPosition(IDocument doc, Position pos) {
        if (pos == null) {
            return;
        }
        if (!doc.containsPositionCategory(SIMPLE_ACTION_CATEGORY)) {
            doc.addPositionCategory(SIMPLE_ACTION_CATEGORY);
            doc.addPositionUpdater((IPositionUpdater)new DeleteEqualPositionUpdater(SIMPLE_ACTION_CATEGORY));
        }
        try {
            doc.addPosition(SIMPLE_ACTION_CATEGORY, pos);
        }
        catch (Exception e) {
            Debug.log(204, e.getMessage());
        }
    }

    private void addPositionsToDoc(IDocument doc, int offset, int length) {
        this.mainScriptPosition = new Position(offset, length);
        this.addActionPosition(doc, this.mainScriptPosition);
        ISnippetVariable[] variables = this.getVariables();
        int i = 0;
        while (i < variables.length) {
            ActionVariable var = (ActionVariable)variables[i];
            int j = 0;
            while (j < var.getPositions().size()) {
                Position varPos = (Position)var.getPositions().get(j);
                varPos.setOffset(offset + varPos.getOffset());
                this.addActionPosition(doc, varPos);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void breakApart() {
        if (this.getDocument() == null) {
            Debug.trace("actions", "action: no doc associated with action");
            return;
        }
        if (this.getEntireScriptPosition() == null) {
            Debug.trace("actions", "action: breakApart-no position tracked so don't know where to breakApart!");
            return;
        }
        try {
            if (this.getReadOnly() && this.getDocument() instanceof IStructuredDocument) {
                ((IStructuredDocument)this.getDocument()).clearReadOnly(this.getEntireScriptPosition().getOffset(), this.getEntireScriptPosition().getLength());
            }
            if (this.getPrefixPosition() != null && this.getPostfixPosition() != null) {
                this.getDocument().replace(this.getPrefixPosition().getOffset(), this.getPrefixPosition().getLength(), "");
                this.getDocument().replace(this.getPostfixPosition().getOffset(), this.getPostfixPosition().getLength(), "");
            }
            this.removePositionsFromDoc(this.getDocument());
        }
        catch (BadLocationException e) {
            Debug.log(202, e.getMessage(), e);
        }
    }

    @Override
    public boolean extract(IEvent e, IDocument doc, InfoRegion prefix, InfoRegion postfix) {
        int scriptLength;
        int scriptStart;
        Position body;
        if (prefix != null && postfix != null && (body = this.extractMainScript(e, doc, scriptStart = prefix.getEndOffset(), scriptLength = postfix.getOffset() - scriptStart + 1)) != null) {
            this.removeActionPosition(doc, this.getPrefixPosition());
            this.prefixPosition = new Position(prefix.getOffset(), prefix.getLength());
            this.addActionPosition(doc, this.prefixPosition);
            this.removeActionPosition(doc, this.postfixPosition);
            this.postfixPosition = new Position(postfix.getOffset(), postfix.getLength());
            this.addActionPosition(doc, this.postfixPosition);
            if (this.getReadOnly() && doc instanceof IStructuredDocument) {
                Position entireScript = this.getEntireScriptPosition();
                ((IStructuredDocument)doc).makeReadOnly(entireScript.getOffset(), entireScript.getLength());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean extract(IEvent e, IDocument doc, int offset, int length) {
        if (length == 0) {
            length = doc.getLength() - offset;
        }
        try {
            doc.get(offset, length);
            Position body = this.extractMainScript(e, doc, offset, length);
            if (body != null) {
                if (this.getReadOnly() && doc instanceof IStructuredDocument) {
                    ((IStructuredDocument)doc).makeReadOnly(body.offset, body.length);
                }
                return true;
            }
        }
        catch (BadLocationException e1) {
            Debug.log(202, e1.getMessage(), e1);
        }
        return false;
    }

    protected Position extractMainScript(IEvent e, IDocument doc, int offset, int length) {
        this.setDocument(doc);
        this.setEvent(e);
        Position body = null;
        body = this.getVariableNames().length == 0 ? new Position(offset, length) : this.extractVariables(e, doc, offset, length);
        if (body != null) {
            this.addPositionsToDoc(doc, body.offset, body.length);
        } else {
            this.setDocument(null);
            this.setEvent(null);
        }
        return body;
    }

    protected Position extractVariables(IEvent e, IDocument doc, int offset, int length) {
        try {
            String script = doc.get(offset, length);
            Position p = this.extractVariables(this.getContentString(), script);
            p.setOffset(p.getOffset() + offset);
            return p;
        }
        catch (Exception exception) {
            Debug.log(204, exception.getMessage());
            return null;
        }
    }

    protected Position extractVariables(String template, String script) {
        SimpleActionComparator templateCompare = new SimpleActionComparator(template, true);
        SimpleActionComparator scriptCompare = new SimpleActionComparator(script, false);
        RangeDifference[] rd = RangeDifferencer.findDifferences((IRangeComparator)templateCompare, (IRangeComparator)scriptCompare);
        int i = 0;
        boolean everythingOK = true;
        while (i < rd.length && everythingOK) {
            int endIndex = i + 1;
            while (endIndex < rd.length && rd[endIndex].leftLength() == 0 && rd[endIndex - 1].rightEnd() + 1 == rd[endIndex].rightStart()) {
                ++endIndex;
            }
            String scriptDiffsString = this.getScriptDifferenceString(rd, scriptCompare, i, endIndex);
            RangeDifference diff = rd[i];
            int actionScriptOffset = scriptCompare.getTokenStart(diff.rightStart());
            everythingOK = this.extractVars2(diff, templateCompare, scriptDiffsString, actionScriptOffset);
            i = endIndex;
        }
        if (everythingOK) {
            return new Position(0, script.length());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean extractVars2(RangeDifference diff, SimpleActionComparator templateCompare, String scriptDiffsString, int startOffset) {
        int templateIndex = diff.leftStart();
        int charAt = 0;
        int lastVarIndex = -1;
        int lastVarStart = charAt;
        while (templateIndex < diff.leftEnd()) {
            String tt = templateCompare.getTokenString(templateIndex);
            String tokenType = templateCompare.getTokenType(templateIndex);
            if (tokenType != "VARIABLE") {
                int staticStart = scriptDiffsString.indexOf(tt, charAt);
                if (staticStart == -1) {
                    Debug.trace("actions", "ERROR: could not extract variables from script (couldnt find static string)");
                    return false;
                }
                if (lastVarIndex != -1) {
                    this.populateVariable(templateCompare, scriptDiffsString, lastVarIndex, lastVarStart, staticStart, startOffset);
                    lastVarIndex = -1;
                }
                charAt = staticStart + tt.length();
            } else {
                lastVarIndex = templateIndex;
                lastVarStart = charAt;
            }
            ++templateIndex;
        }
        if (lastVarIndex != -1) {
            this.populateVariable(templateCompare, scriptDiffsString, lastVarIndex, lastVarStart, scriptDiffsString.length(), startOffset);
        }
        return true;
    }

    protected String generateScript(boolean trackPositions) {
        return this.generateScript(this.getContentString(), trackPositions);
    }

    protected String generateScript(String template, boolean trackPositions) {
        if (template == null || template.length() == 0) {
            return null;
        }
        String normalString = "";
        int tPrevious = 0;
        int tPos = 0;
        int tVarPosB = template.indexOf(PARM_START, tPos);
        while (tVarPosB > -1) {
            int tVarPosE = template.indexOf(PARM_END, tVarPosB);
            if (tVarPosE > -1) {
                tVarPosB = template.lastIndexOf(PARM_START, tVarPosE);
                String varID = template.substring(tVarPosB + PARM_START.length(), tVarPosE).trim();
                ActionVariable var = this.getActionVariable(varID);
                if (var != null) {
                    String value = var.getValue();
                    if (value == null) {
                        value = var.getDefaultValue();
                    }
                    normalString = String.valueOf(normalString) + template.substring(tPrevious, tVarPosB) + value;
                    if (trackPositions) {
                        var.getPositions().add(new Position(normalString.length() - value.length(), value.length()));
                    }
                    tPos = tPrevious = tVarPosE + 1;
                } else {
                    tPos = tVarPosE + 1;
                }
            } else {
                tPos = tVarPosB + 1;
            }
            tVarPosB = template.indexOf(PARM_START, tPos);
        }
        normalString = String.valueOf(normalString) + template.substring(tPrevious);
        return normalString;
    }

    public ActionVariable getActionVariable(String varID) {
        ActionVariable foundVar = null;
        ISnippetVariable[] variables = this.getVariables();
        int i = 0;
        while (i < variables.length && foundVar == null) {
            ActionVariable var = (ActionVariable)variables[i];
            if (varID.equals(var.getId())) {
                foundVar = var;
            }
            ++i;
        }
        return foundVar;
    }

    @Override
    public IDocument getDocument() {
        return this.currentDoc;
    }

    protected Position getEntireScriptPosition() {
        if (this.getPrefixPosition() != null && this.getPostfixPosition() != null) {
            int postfixEnd = this.getPostfixPosition().getOffset() + this.getPostfixPosition().getLength() - 1;
            return new Position(this.getPrefixPosition().getOffset(), postfixEnd - this.getPrefixPosition().getOffset() + 1);
        }
        return this.getMainScriptPosition();
    }

    @Override
    public IEvent getEvent() {
        return this.currentEvent;
    }

    protected Position getMainScriptPosition() {
        if (this.mainScriptPosition != null && this.mainScriptPosition.isDeleted) {
            this.mainScriptPosition = null;
            this.setDeleted(true);
        }
        return this.mainScriptPosition;
    }

    protected Position getPostfixPosition() {
        if (this.postfixPosition != null && this.postfixPosition.isDeleted) {
            this.postfixPosition = null;
        }
        return this.postfixPosition;
    }

    protected Position getPrefixPosition() {
        if (this.prefixPosition != null && this.prefixPosition.isDeleted) {
            this.prefixPosition = null;
        }
        return this.prefixPosition;
    }

    protected boolean getReadOnly() {
        return this.readOnly;
    }

    private String getScriptDifferenceString(RangeDifference[] rd, SimpleActionComparator scriptCompare, int startIndex, int endIndex) {
        StringBuffer scriptDiffs = new StringBuffer();
        int j = startIndex;
        while (j < endIndex) {
            String difference;
            if (scriptDiffs.length() > 0) {
                difference = scriptCompare.getTokenString(rd[j - 1].rightEnd());
                scriptDiffs.append(difference);
            }
            int rightIndex = rd[j].rightStart();
            while (rightIndex < rd[j].rightEnd()) {
                difference = scriptCompare.getTokenString(rightIndex);
                scriptDiffs.append(difference);
                ++rightIndex;
            }
            ++j;
        }
        Debug.trace("actions", "extractVariabes - script diff = " + scriptDiffs.toString());
        return scriptDiffs.toString();
    }

    @Override
    public String[] getVariableNames() {
        ISnippetVariable[] variables = this.getVariables();
        String[] varNames = new String[variables.length];
        int i = 0;
        while (i < variables.length) {
            ISnippetVariable var = variables[i];
            varNames[i] = ((ActionVariable)var).getId();
            ++i;
        }
        return varNames;
    }

    @Override
    public String getVariableValue(String varId) {
        ActionVariable av = this.getActionVariable(varId);
        if (av == null) {
            Debug.trace("actions: getVariableValue: could not find variable: " + varId, "actions");
            return null;
        }
        return av.getValue();
    }

    @Override
    public void insert(int offset) {
        this.insert(offset, null);
    }

    @Override
    public void insert(int offset, IActionDetector extractor) {
        this.insertScriptBody(this.getEvent(), this.getDocument(), offset, true, extractor);
    }

    @Override
    public void insertMainScript(IEvent e, IDocument doc, int offset) {
        this.insertScriptBody(e, doc, offset, false, null);
    }

    protected void insertScriptBody(IEvent e, IDocument doc, int offset, boolean trackPosition, IActionDetector extractor) {
        if (doc == null) {
            Debug.trace("actions", "action: doc to insert is null");
            return;
        }
        String script = this.generateScript(trackPosition);
        String prefix = "";
        String postfix = "";
        if (extractor != null && extractor instanceof CommentActionDetector) {
            CommentActionDetector ae = (CommentActionDetector)extractor;
            prefix = ae.getActionPrefix(this);
            postfix = ae.getActionPostfix(this);
        }
        String inserting = String.valueOf(prefix) + script + postfix;
        try {
            if (inserting != null) {
                doc.replace(offset, 0, inserting);
                if (trackPosition) {
                    Debug.trace("actions", "action: insertMainScript-tracking action position");
                    this.addPositionsToDoc(doc, offset + prefix.length(), script.length());
                    if (prefix.length() > 0 && postfix.length() > 0) {
                        this.removeActionPosition(doc, this.prefixPosition);
                        this.prefixPosition = new Position(offset, prefix.length());
                        this.addActionPosition(doc, this.prefixPosition);
                        this.removeActionPosition(doc, this.postfixPosition);
                        this.postfixPosition = new Position(offset + prefix.length() + script.length() - 1, postfix.length());
                        this.addActionPosition(doc, this.postfixPosition);
                    }
                }
                if (this.getReadOnly() && doc instanceof IStructuredDocument) {
                    ((IStructuredDocument)doc).makeReadOnly(offset, inserting.length());
                }
            }
        }
        catch (BadLocationException exception) {
            Debug.log(204, exception.getMessage());
        }
    }

    @Override
    public boolean isDeleted() {
        if (this.getEntireScriptPosition() == null) {
            this.deleted = true;
        }
        return this.deleted;
    }

    @Override
    public boolean isInsideAction(int offset, int length) {
        if (this.getEntireScriptPosition() != null) {
            boolean overlapsWith = this.getEntireScriptPosition().overlapsWith(offset, length);
            if (overlapsWith && length == 0 && offset == this.getEntireScriptPosition().getOffset()) {
                return false;
            }
            return overlapsWith;
        }
        return false;
    }

    private void populateVariable(SimpleActionComparator templateCompare, String scriptDiffsString, int lastVarIndex, int lastVarStart, int varEnd, int startOffset) {
        String varName = templateCompare.getTokenString(lastVarIndex);
        varName = varName.substring(2, varName.length() - 1);
        String value = scriptDiffsString.substring(lastVarStart, varEnd);
        ActionVariable av = this.getActionVariable(varName);
        if (av != null) {
            av.setValue(value);
            Position varPos = new Position(lastVarStart + startOffset, varEnd - lastVarStart);
            av.getPositions().add(varPos);
        }
    }

    @Override
    public void remove() {
        this.setDeleted(true);
        if (this.getDocument() == null) {
            Debug.trace("actions", "action: doc to remove is null");
            return;
        }
        if (this.getEntireScriptPosition() == null) {
            Debug.trace("actions", "action: remove-no position tracked so don't know where to remove!");
            return;
        }
        try {
            if (this.getReadOnly() && this.getDocument() instanceof IStructuredDocument) {
                ((IStructuredDocument)this.getDocument()).clearReadOnly(this.getEntireScriptPosition().offset, this.getEntireScriptPosition().length);
            }
            this.getDocument().replace(this.getEntireScriptPosition().offset, this.getEntireScriptPosition().length, "");
            this.removePositionsFromDoc(this.getDocument());
        }
        catch (BadLocationException exception) {
            Debug.log(202, "Problems occurred while removing simple action: " + this.getId(), exception);
        }
    }

    private void removeActionPosition(IDocument doc, Position pos) {
        if (pos == null) {
            return;
        }
        try {
            if (doc.containsPositionCategory(SIMPLE_ACTION_CATEGORY)) {
                doc.removePosition(SIMPLE_ACTION_CATEGORY, pos);
            }
        }
        catch (BadPositionCategoryException e) {
            Debug.log(204, e.getMessage());
        }
    }

    private void removePositionsFromDoc(IDocument doc) {
        this.removeActionPosition(doc, this.getMainScriptPosition());
        this.mainScriptPosition = null;
        this.removeActionPosition(doc, this.getPrefixPosition());
        this.prefixPosition = null;
        this.removeActionPosition(doc, this.getPostfixPosition());
        this.postfixPosition = null;
        ISnippetVariable[] variables = this.getVariables();
        int i = 0;
        while (i < variables.length) {
            ActionVariable var = (ActionVariable)variables[i];
            int j = 0;
            while (j < var.getPositions().size()) {
                Position varPos = (Position)var.getPositions().get(j);
                this.removeActionPosition(doc, varPos);
                var.getPositions().remove(j);
                ++j;
            }
            ++i;
        }
    }

    public void setDeleted(boolean b) {
        this.deleted = b;
    }

    @Override
    public void setDocument(IDocument doc) {
        if (this.currentDoc != null && this.mainScriptPosition != null && this.currentDoc != doc) {
            this.removePositionsFromDoc(doc);
        }
        this.currentDoc = doc;
    }

    @Override
    public void setEvent(IEvent event) {
        this.currentEvent = event;
    }

    protected void setReadOnly(boolean b) {
        this.readOnly = b;
    }

    @Override
    public void setVariableValue(String varId, String varValue) {
        ActionVariable av = this.getActionVariable(varId);
        if (av == null) {
            Debug.trace("actions: setVariableValue: could not find variable: " + varId, "actions");
            return;
        }
        av.setValue(varValue);
    }

    @Override
    public void update() {
        if (this.getDocument() == null) {
            Debug.trace("action: doc to update is null", "actions");
            return;
        }
        ISnippetVariable[] variables = this.getVariables();
        int i = 0;
        while (i < variables.length) {
            ActionVariable var = (ActionVariable)variables[i];
            int j = 0;
            while (j < var.getPositions().size()) {
                Position varPos = (Position)var.getPositions().get(j);
                int oldLength = varPos.length;
                try {
                    if (this.getDocument().containsPosition(SIMPLE_ACTION_CATEGORY, varPos.getOffset(), varPos.getLength())) {
                        if (this.getDocument() instanceof IStructuredDocument) {
                            ((IStructuredDocument)this.getDocument()).replaceText((Object)this, varPos.getOffset(), oldLength, var.getValue(), true);
                        } else {
                            this.getDocument().replace(varPos.getOffset(), oldLength, var.getValue());
                        }
                    }
                }
                catch (BadLocationException e) {
                    Debug.log(202, "Problems occurred while removing simple action: " + this.getId(), e);
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void updateAdditionalScript(IEvent e, IDocument doc) {
    }
}

