/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.qev;

import com.ibm.etools.qev.QEVPlugin;
import com.ibm.icu.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class Debug {
    public static final boolean perf_saveScript = false;
    public static final boolean perf_refreshEventList = false;
    public static final boolean perf_refreshEvent = false;
    public static final boolean perf_setupEditor = false;
    public static final boolean perf_EVEventModelBuilder = false;
    private static Plugin fPlugin = QEVPlugin.getDefault();
    private static final String fPluginId = fPlugin.getBundle().getSymbolicName();
    private static final String TRACEFILTER_LOCATION = "/debug/tracefilter";
    public static final int OK = 0;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 4;
    public static final int OK_DEBUG = 200;
    public static final int INFO_DEBUG = 201;
    public static final int WARNING_DEBUG = 202;
    public static final int ERROR_DEBUG = 204;

    protected static void _log(int level, String message, Throwable exception) {
        if (!(level != 200 && level != 201 && level != 202 && level != 204 || Debug.isDebugging())) {
            return;
        }
        int severity = 0;
        switch (level) {
            case 1: 
            case 201: {
                severity = 1;
                break;
            }
            case 2: 
            case 202: {
                severity = 2;
                break;
            }
            case 4: 
            case 204: {
                severity = 4;
            }
        }
        message = message != null ? message : "null";
        Status statusObj = new Status(severity, fPluginId, severity, message, exception);
        fPlugin.getLog().log((IStatus)statusObj);
    }

    protected static void _trace(String category, String message, Throwable exception) {
        if (Debug.isTracing(category)) {
            message = message != null ? message : "null";
            Status statusObj = new Status(0, fPluginId, 0, message, exception);
            fPlugin.getLog().log((IStatus)statusObj);
        }
    }

    public static boolean isDebugging() {
        return fPlugin.isDebugging();
    }

    public static boolean isTracing(String category) {
        if (!Debug.isDebugging()) {
            return false;
        }
        String traceFilter = Platform.getDebugOption((String)(String.valueOf(fPluginId) + TRACEFILTER_LOCATION));
        if (traceFilter != null) {
            StringTokenizer tokenizer = new StringTokenizer(traceFilter, ",");
            while (tokenizer.hasMoreTokens()) {
                String cat = tokenizer.nextToken().trim();
                if (!category.equals(cat)) continue;
                return true;
            }
        }
        return false;
    }

    public static void log(int level, String message) {
        Debug._log(level, message, null);
    }

    public static void log(int level, String message, Throwable exception) {
        Debug._log(level, message, exception);
    }

    public static void logException(String message, Throwable exception) {
        Debug._log(4, message, exception);
    }

    public static void logException(Throwable exception) {
        Debug._log(4, exception.getMessage(), exception);
    }

    public static void trace(String category, String message) {
        Debug._trace(category, message, null);
    }

    public static void traceException(String category, String message, Throwable exception) {
        Debug._trace(category, message, exception);
    }

    public static void traceException(String category, Throwable exception) {
        Debug._trace(category, exception.getMessage(), exception);
    }
}

