/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.internal.resource.cmds.nodes;

import com.ibm.etools.diagram.model.internal.DiagramCommandResult;
import com.ibm.etools.diagram.model.internal.commands.IWorkspaceLockMarker;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.model2.base.facet.ProjectFacetUtil;
import com.ibm.etools.model2.diagram.web.internal.WebPlugin;
import com.ibm.etools.model2.diagram.web.internal.nls.Messages;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.webpage.template.selection.core.ITemplateDescriptor;
import com.ibm.etools.webtools.webpage.core.internal.PropertyStore;
import com.ibm.etools.webtools.webpage.core.internal.util.WebPageModelUtil;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeIdForHTML;

public class CreateWebPageResourceCommand
extends AbstractCommand
implements IWorkspaceLockMarker {
    private final MNode node;
    private IFile file = null;
    private boolean undoable = false;

    public CreateWebPageResourceCommand(MNode node) {
        super(Messages.CreateResourceWebPage);
        this.node = node;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)16);
        this.file = WebProvider.getFileForNode(this.node);
        if (this.file != null && !this.file.exists()) {
            if (this.file.getFileExtension() == null) {
                return CommandResult.newCancelledCommandResult();
            }
            sub.subTask(Messages.SettingWebPageCeationProperties);
            PropertyStore ps = WebPageModelUtil.getPropertyStore();
            sub.worked(1);
            IDataModel dataModel = DataModelFactory.createDataModel((String)"com.ibm.etools.webtools.webpage.core.WebPageCreationDataModelProvider");
            sub.worked(1);
            dataModel.setProperty("IWebPageCreationDataModelProperties.PROJECT", (Object)this.file.getProject());
            sub.worked(1);
            String folder = this.file.getFullPath().removeLastSegments(1).removeTrailingSeparator().toString();
            dataModel.setProperty("IWebPageCreationDataModelProperties.FOLDER", (Object)folder);
            sub.worked(1);
            dataModel.setProperty("IWebPageDataModelProperties.FILE_NAME", (Object)this.file.getName());
            sub.worked(1);
            DataModelPropertyDescriptor[] templateDescs = dataModel.getValidPropertyDescriptors("IWebPageDataModelProperties.TEMPLATE");
            boolean isHTML = false;
            String ext = this.file.getFileExtension();
            if (ext != null) {
                String[] htmlExts = this.getHtmlExtensions();
                int i = 0;
                while (i < htmlExts.length) {
                    String htmlExt = htmlExts[i];
                    if (ext.equals(htmlExt)) {
                        isHTML = true;
                    }
                    ++i;
                }
            }
            sub.worked(1);
            if (!isHTML) {
                IFacetedProject fp = ProjectFacetUtil.getFacetedProject((IProject)this.file.getProject());
                boolean isPortlet = false;
                if (fp.hasProjectFacet(ProjectFacetUtil.getProjectFacet((String)"jsr.base")) || fp.hasProjectFacet(ProjectFacetUtil.getProjectFacet((String)"jsr168.base")) || fp.hasProjectFacet(ProjectFacetUtil.getProjectFacet((String)"ibmportlet.base"))) {
                    isPortlet = true;
                }
                int i = 0;
                while (i < templateDescs.length) {
                    ITemplateDescriptor templateDescriptor = (ITemplateDescriptor)templateDescs[i].getPropertyValue();
                    if (isPortlet) {
                        if ("com.ibm.etools.portlet.jsp.BasicPortletJSPTemplate".equals(templateDescriptor.getID())) {
                            dataModel.setProperty("IWebPageDataModelProperties.TEMPLATE", (Object)templateDescriptor);
                            break;
                        }
                    } else if ("com.ibm.etools.webtools.webpage.BasicJSPTemplate".equals(templateDescriptor.getID())) {
                        dataModel.setProperty("IWebPageDataModelProperties.TEMPLATE", (Object)templateDescriptor);
                        break;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < templateDescs.length) {
                    ITemplateDescriptor templateDescriptor = (ITemplateDescriptor)templateDescs[i].getPropertyValue();
                    if ("com.ibm.etools.webtools.webpage.BasicHTMLTemplate".equals(templateDescriptor.getID())) {
                        dataModel.setProperty("IWebPageDataModelProperties.TEMPLATE", (Object)templateDescriptor);
                        break;
                    }
                    ++i;
                }
            }
            sub.worked(1);
            ps.restoreAllProperties(dataModel, this.file.getProject());
            sub.worked(1);
            sub.subTask(Messages.PerformingWebPageCreation);
            IStatus dbStatus = dataModel.validate();
            int sev = dbStatus.getSeverity();
            if (sev == 0 || sev == 1 || sev == 2) {
                IDataModelOperation op = dataModel.getDefaultOperation();
                IStatus status = op.execute((IProgressMonitor)sub.newChild(8), null);
                if (!status.isOK()) {
                    return new CommandResult(status);
                }
                this.undoable = true;
            } else {
                return new CommandResult(dbStatus);
            }
        }
        sub.done();
        if (progressMonitor != null) {
            progressMonitor.done();
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.file != null) {
            try {
                IFileState[] state = this.file.getHistory(progressMonitor);
                if (state != null && state.length > 0) {
                    this.file.create(state[0].getContents(), false, progressMonitor);
                }
            }
            catch (CoreException e) {
                WebPlugin.getDefault().getLog().log(e.getStatus());
                return DiagramCommandResult.newErrorCommandResult((Throwable)e);
            }
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.node.removeAdapter(ILink.class);
        if (this.undoable && this.file != null && this.file.exists()) {
            try {
                this.file.delete(false, true, progressMonitor);
            }
            catch (CoreException e) {
                WebPlugin.getDefault().getLog().log(e.getStatus());
                return DiagramCommandResult.newErrorCommandResult((Throwable)e);
            }
        }
        return CommandResult.newOKCommandResult();
    }

    private String[] getHtmlExtensions() {
        String contentTypeID = ContentTypeIdForHTML.ContentTypeID_HTML;
        IContentType type = Platform.getContentTypeManager().getContentType(contentTypeID);
        if (type != null) {
            String[] extensions = type.getFileSpecs(8);
            return extensions;
        }
        return new String[0];
    }
}

