/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.internal.resource.cmds.items;

import com.ibm.etools.diagram.model.internal.DiagramCommandResult;
import com.ibm.etools.diagram.model.internal.commands.support.IDeletionCommand;
import com.ibm.etools.diagram.model.internal.commands.support.ResourceDescriptor;
import com.ibm.etools.diagram.model.internal.commands.support.ResourceTree;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.CommandExecutionAprover;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.TargetAdapter;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.WebDiagramCommandHelper;
import com.ibm.etools.model2.diagram.web.internal.nls.Messages;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.model2.diagram.web.internal.resource.cmds.ResourceModificationCommand;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webtools.model.util.ModelUtil;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.osgi.util.NLS;

public class UpdateWebPageLinkResourceCommand
extends ResourceModificationCommand
implements IDeletionCommand {
    private final IAdaptable sourceNodeItem;
    private final String oldPath;
    private final List<String> resourcesToDelete;
    private boolean undoable = false;
    private IFile file;
    private int index;
    private String tagname;
    private String attribute;
    private final CommandExecutionAprover updateAprover;
    private final TargetAdapter targetAdapter;

    public UpdateWebPageLinkResourceCommand(String oldPath, IAdaptable sourceNodeItem, List<String> resourcesToDelete, CommandExecutionAprover updateAprover, TargetAdapter targetAdapter) {
        super(Messages.UpdateHTMLLink);
        this.oldPath = oldPath;
        this.sourceNodeItem = sourceNodeItem;
        this.resourcesToDelete = resourcesToDelete;
        this.updateAprover = updateAprover;
        this.targetAdapter = targetAdapter;
    }

    @Override
    protected CommandResult doExecuteResourceModification(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (!this.updateAprover.isProceed()) {
            return CommandResult.newOKCommandResult();
        }
        if (this.resourcesToDelete == null || this.resourcesToDelete.isEmpty() || this.resourcesToDelete != null && !this.resourcesToDelete.contains(this.oldPath)) {
            return CommandResult.newOKCommandResult();
        }
        IFile fileToModify = this.getFileToModify();
        if (fileToModify != null && fileToModify.exists()) {
            HTMLEditDomain domain = null;
            try {
                try {
                    domain = ModelUtil.getEditDomain((IFile)fileToModify);
                    this.tagname = "A";
                    this.attribute = "href";
                    Item item = this.getItem();
                    this.index = WebProvider.calculateItemIndexInCompartmentByType(item);
                    WebDiagramCommandHelper.updateLink(this.index, domain, this.tagname, Collections.singleton(this.attribute), this.attribute, this.oldPath, this.getTargetPath());
                    this.undoable = true;
                }
                catch (Exception e) {
                    CommandResult commandResult = DiagramCommandResult.newErrorCommandResult((Throwable)e);
                    try {
                        ModelUtil.releaseAndSaveIfNecessaryEditDomain((HTMLEditDomain)domain);
                    }
                    catch (Exception e2) {
                        return DiagramCommandResult.newErrorCommandResult((Throwable)e2);
                    }
                    return commandResult;
                }
            }
            finally {
                try {
                    ModelUtil.releaseAndSaveIfNecessaryEditDomain((HTMLEditDomain)domain);
                }
                catch (Exception e) {
                    return DiagramCommandResult.newErrorCommandResult((Throwable)e);
                }
            }
        }
        return CommandResult.newOKCommandResult();
    }

    @Override
    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        HTMLEditDomain domain = null;
        try {
            try {
                domain = ModelUtil.getEditDomain((IFile)this.getFileToModify());
                WebDiagramCommandHelper.updateLink(this.index, domain, this.tagname, Collections.singleton(this.attribute), this.attribute, this.oldPath, this.getTargetPath());
            }
            catch (Exception e) {
                CommandResult commandResult = DiagramCommandResult.newErrorCommandResult((Throwable)e);
                try {
                    ModelUtil.releaseAndSaveIfNecessaryEditDomain((HTMLEditDomain)domain);
                }
                catch (Exception e2) {
                    return DiagramCommandResult.newErrorCommandResult((Throwable)e2);
                }
                return commandResult;
            }
        }
        finally {
            try {
                ModelUtil.releaseAndSaveIfNecessaryEditDomain((HTMLEditDomain)domain);
            }
            catch (Exception e) {
                return DiagramCommandResult.newErrorCommandResult((Throwable)e);
            }
        }
        return CommandResult.newOKCommandResult();
    }

    @Override
    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.undoable && this.file.exists()) {
            HTMLEditDomain domain = null;
            try {
                try {
                    domain = ModelUtil.getEditDomain((IFile)this.file);
                    String tagname = "A";
                    String attribute = "href";
                    WebDiagramCommandHelper.updateLink(0, domain, tagname, Collections.singleton(attribute), attribute, this.getTargetPath(), this.oldPath);
                    this.undoable = true;
                }
                catch (Exception e) {
                    CommandResult commandResult = DiagramCommandResult.newErrorCommandResult((Throwable)e);
                    try {
                        ModelUtil.releaseAndSaveIfNecessaryEditDomain((HTMLEditDomain)domain);
                    }
                    catch (Exception e2) {
                        return DiagramCommandResult.newErrorCommandResult((Throwable)e2);
                    }
                    return commandResult;
                }
            }
            finally {
                try {
                    ModelUtil.releaseAndSaveIfNecessaryEditDomain((HTMLEditDomain)domain);
                }
                catch (Exception e) {
                    return DiagramCommandResult.newErrorCommandResult((Throwable)e);
                }
            }
        }
        return CommandResult.newOKCommandResult();
    }

    public ResourceTree getDeletionTree() {
        if (this.getTargetPath().equals("")) {
            ResourceDescriptor desc = new ResourceDescriptor((Object)this.oldPath);
            desc.setDisplayText(NLS.bind((String)Messages.UpdateFileXRemoveReferenceToX, (Object)this.getFileToModify().getLocation().lastSegment(), (Object)this.oldPath));
            return new ResourceTree(desc);
        }
        return null;
    }

    @Override
    protected IFile getFileToModify() {
        Item item;
        if (this.file == null && this.sourceNodeItem != null && (item = this.getItem()) != null) {
            this.file = WebProvider.getFileForNode(item.getNode());
        }
        return this.file;
    }

    protected Item getItem() {
        Item item = (Item)this.sourceNodeItem.getAdapter(Item.class);
        return item;
    }

    private String getTargetPath() {
        return this.targetAdapter.getTargetPath();
    }
}

