/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.internal.providers.edgegenerator;

import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.diagram.model.internal.providers.IEdgeGeneratorProvider;
import com.ibm.etools.diagram.model.internal.providers.SourceReference;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.WebTargetTypeUtilities;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.references.management.ILink;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;

public class HREFEdgeTypeGeneratorProvider
extends WebProvider
implements IEdgeGeneratorProvider {
    public Collection generateSources(Item source, IElementType edgeType, IElementType itemTypeToGenerate) {
        int dupIndex = 0;
        IResource r = HREFEdgeTypeGeneratorProvider.getTargetContainer((IAdaptable)source);
        if (r instanceof IFile) {
            IFile targetFile = (IFile)r;
            dupIndex = HREFEdgeTypeGeneratorProvider.calculateItemIndexInCompartmentByType(source);
            SourceReference ref = new SourceReference(source, edgeType);
            IPath modRelative = HREFEdgeTypeGeneratorProvider.getDocumentRootRelativePath(targetFile);
            ref.setDisplayText(modRelative.toString());
            ref.addParameter("web.itemname.key", (Object)targetFile);
            ref.addParameter("web.dup.index", (Object)new Integer(dupIndex));
            return Collections.singletonList(ref);
        }
        return Collections.EMPTY_SET;
    }

    public boolean isSourcedToItem(MEdge edge, Item node) {
        ILink source = (ILink)node.getAdapter(ILink.class);
        ILink target = HREFEdgeTypeGeneratorProvider.getTarget((IAdaptable)node);
        if (target != null) {
            if (target.equals(edge.getTarget().getAdapter(ILink.class))) {
                int dupCount = HREFEdgeTypeGeneratorProvider.calculateItemIndexInCompartmentByType(node);
                MEdge edgeToCompare = HREFEdgeTypeGeneratorProvider.getEdgeForTargetByTypeAtIndex(edge.getType(), edge.getTarget(), (List<MEdge>)node.getNode().getOutput(), dupCount);
                if (edge.equals(edgeToCompare)) {
                    return true;
                }
            }
        } else {
            String targetNode;
            String stringTarget = source.getLinkText();
            if (stringTarget != null && stringTarget.startsWith("/") && HREFEdgeTypeGeneratorProvider.isWebApplicationNode((TypedElement)edge.getTarget()) && (targetNode = WebTargetTypeUtilities.getTargetNodePath(edge.getSource(), edge.getTarget())) != null && stringTarget.startsWith(targetNode)) {
                return true;
            }
        }
        return false;
    }
}

