/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.internal.providers.config;

import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.DiagramModelFactory;
import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.MDiagram;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.diagram.model.internal.providers.IConfiguratorProvider;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.runtime.common.core.service.IOperation;

public class WebApplicationConfiguratorProvider
extends WebProvider
implements IConfiguratorProvider {
    public void configureExisting(CommonElement element, Object existing, Map options) {
        MNode node = (MNode)element;
        IProject project = null;
        if (existing instanceof IAdaptable) {
            project = (IProject)((IAdaptable)existing).getAdapter(IProject.class);
        } else if (existing instanceof IProject) {
            project = (IProject)existing;
        }
        if (project == null) {
            return;
        }
        if ("nodePhase".equals(options.get("configure phase"))) {
            boolean updated = WebProvider.updateStringProperty("web.project.key", project.getName(), (IPropertyHolder)node);
            if (!updated) {
                Property property = DiagramModelFactory.eINSTANCE.createProperty();
                property.setName("web.project.key");
                property.setValue(project.getName());
                node.getPersistedProperties().add((Object)property);
                node.setTitleProperty(property);
            }
            node.refreshRealization();
        }
    }

    public void configureLoad(CommonElement element) {
    }

    public void configureNew(CommonElement element) {
        MNode node = (MNode)element;
        String projectName = "NewWebProject";
        int i = 0;
        while (!this.isUniquePath(node, projectName, i)) {
            ++i;
        }
        Property property = DiagramModelFactory.eINSTANCE.createProperty();
        property.setName("web.project.key");
        property.setValue(this.createPath(projectName, i));
        element.getPersistedProperties().add((Object)property);
        element.setTitleProperty(property);
    }

    private String createPath(String newPath, int suffix) {
        if (suffix > 1) {
            Path p = new Path(newPath);
            return String.valueOf(p.toString()) + suffix;
        }
        return newPath;
    }

    private boolean isUniquePath(MNode nodeToConfigure, String newPath, int suffix) {
        MDiagram d = nodeToConfigure.getParent();
        EList nodes = d.getNodes();
        String incedPath = this.createPath(newPath, suffix);
        for (MNode node : nodes) {
            String projectName = WebApplicationConfiguratorProvider.getStringProperty("web.project.key", (IPropertyHolder)node);
            if (projectName == null || !incedPath.equals(projectName)) continue;
            return false;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(incedPath);
        return !project.exists();
    }

    @Override
    public boolean provides(IOperation operation) {
        return false;
    }
}

