/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.internal.providers;

import com.ibm.etools.diagram.model.internal.Debug;
import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.Compartment;
import com.ibm.etools.diagram.model.internal.emf.DiagramModelFactory;
import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.diagram.model.util.ModelUpdateUtils;
import com.ibm.etools.model2.base.facet.ProjectFacetUtil;
import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.model2.diagram.web.internal.WebPlugin;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.IPathModifier;
import com.ibm.etools.model2.diagram.web.internal.nls.Messages;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.ReferenceException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.ProviderChangeEvent;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeIdForHTML;

public abstract class WebProvider
extends AbstractProvider {
    private static RefreshJob refresh = new RefreshJob();
    private static boolean suspendRefresh;
    private static final HashSet<MNode> defferedRefreshNodeList;

    static {
        defferedRefreshNodeList = new HashSet();
    }

    public static boolean allowRetargetDialog() {
        if (Thread.currentThread() != PlatformUI.getWorkbench().getDisplay().getThread()) {
            final boolean[] holder = new boolean[1];
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    holder[0] = WebProvider.doOpenRetargetDialog();
                }
            });
            return holder[0];
        }
        return WebProvider.doOpenRetargetDialog();
    }

    public static synchronized void asyncRefreshNode(MNode element) {
        if (!suspendRefresh) {
            WebProvider.scheduleJob(element);
        } else {
            defferedRefreshNodeList.add(element);
        }
    }

    public static int calculateItemIndexInCompartmentByType(Item node) {
        IResource target = WebProvider.getTargetContainer((IAdaptable)node);
        int dupCount = 0;
        Compartment compartment = (Compartment)node.eContainer();
        EList sorted = compartment.getSortedItems();
        for (Item item : sorted) {
            IResource otherTarget;
            if (item == node) break;
            if (!node.getType().equals(item.getType()) || !Model2Util.isEqualOrBothNull((Object)target, (Object)(otherTarget = WebProvider.getTargetContainer((IAdaptable)item)))) continue;
            ++dupCount;
        }
        return dupCount;
    }

    public static boolean deleteStringProperty(String key, IPropertyHolder element) {
        Property property;
        if (key == null) {
            return false;
        }
        Iterator iter = element.getTransientProperties().iterator();
        while (iter.hasNext()) {
            property = (Property)iter.next();
            if (!key.equals(property.getName())) continue;
            iter.remove();
            return true;
        }
        iter = element.getPersistedProperties().iterator();
        while (iter.hasNext()) {
            property = (Property)iter.next();
            if (!key.equals(property.getName())) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    private static boolean doOpenRetargetDialog() {
        Shell shell = new Shell(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 65536);
        int result = -1;
        try {
            shell.setSize(0, 0);
            MessageBox box = new MessageBox(shell, 192);
            box.setText(Messages.RetargetLink);
            box.setMessage(Messages.LinkAlreadyHasTarget_Retarget);
            shell.setVisible(true);
            result = box.open();
        }
        finally {
            shell.close();
            shell.dispose();
        }
        return result == 64;
    }

    private static void doRefresh(MNode element) {
        element.refresh();
    }

    public static String externalPathModification(String path, IProject project) {
        List<Object> modifiers = WebProvider.getPathModifiers(project);
        for (IPathModifier iPathModifier : modifiers) {
            path = iPathModifier.modifyPath(path, Model2Util.findComponent((IResource)project));
        }
        return path;
    }

    public static IContainer getDocumentRootContainer(IFile file) {
        if (file != null) {
            return Model2Util.getDocumentRootContainer((IVirtualComponent)Model2Util.findComponent((IResource)file));
        }
        return null;
    }

    public static IContainer getDocumentRootContainer(Resource resource) {
        IFile file;
        if (resource != null && (file = WorkspaceSynchronizer.getFile((Resource)resource)) != null) {
            return WebProvider.getDocumentRootContainer(file);
        }
        return null;
    }

    public static IPath getDocumentRootRelativePath(IFile file) {
        IPath filepath = file.getProjectRelativePath();
        IPath root = WebProvider.getDocumentRootContainer(file).getProjectRelativePath();
        IPath moduleRelative = filepath.removeFirstSegments(filepath.matchingFirstSegments(root));
        return moduleRelative;
    }

    public static IPath getDocumentRootRelativePath(MNode node) {
        IPath file = WebProvider.getFileForNode(node).getProjectRelativePath();
        IPath root = WebProvider.getDocumentRootContainer(node.eResource()).getProjectRelativePath();
        IPath moduleRelative = file.removeFirstSegments(file.matchingFirstSegments(root));
        return moduleRelative;
    }

    public static MEdge getEdgeForTargetByTypeAtIndex(String edgeType, MNode edgeTarget, List<MEdge> outgoingEdgesOnSourceNode, int itemIndexByType) {
        return WebProvider.getEdgeForTargetByTypeAtIndex(edgeType, null, null, edgeTarget, outgoingEdgesOnSourceNode, itemIndexByType);
    }

    public static MEdge getEdgeForTargetByTypeAtIndex(String edgeType, String propertyName, String propertyValue, MNode edgeTarget, List<MEdge> outgoingEdgesOnSourceNode, int itemIndexByType) {
        ArrayList<MEdge> sorted = new ArrayList<MEdge>();
        for (MEdge outGoingEdge : outgoingEdgesOnSourceNode) {
            String edgeIndexByType;
            if (!edgeType.equals(outGoingEdge.getType()) || !edgeTarget.equals(outGoingEdge.getTarget()) || (edgeIndexByType = WebProvider.getStringProperty("web.dup.index", (IPropertyHolder)outGoingEdge)) == null) continue;
            if (propertyName == null || propertyValue == null) {
                sorted.add(outGoingEdge);
                continue;
            }
            if (!propertyValue.equals(WebProvider.getEdgeProperty(outGoingEdge, propertyName))) continue;
            sorted.add(outGoingEdge);
        }
        Collections.sort(sorted, new Comparator<MEdge>(){

            @Override
            public int compare(MEdge edge1, MEdge edge2) {
                Integer edge1Index = Integer.valueOf(WebProvider.getStringProperty("web.dup.index", (IPropertyHolder)edge1));
                Integer edge2Index = Integer.valueOf(WebProvider.getStringProperty("web.dup.index", (IPropertyHolder)edge2));
                return edge1Index.compareTo(edge2Index);
            }
        });
        return itemIndexByType <= sorted.size() - 1 ? (MEdge)sorted.get(itemIndexByType) : null;
    }

    private static String getEdgeProperty(MEdge edge, String propertyName) {
        for (Property p : edge.getPersistedProperties()) {
            if (!p.getName().equals(propertyName)) continue;
            return p.getValue();
        }
        return null;
    }

    public static IFile getFileForNode(MNode node) {
        return WebProvider.getFileForNode(node, null);
    }

    public static IFile getFileForNode(MNode node, String defaultPath) {
        String path;
        if (node == null || node.eResource() == null) {
            return null;
        }
        String nodePath = WebProvider.getStringProperty("web.path.key", (IPropertyHolder)node);
        IFile file = WorkspaceSynchronizer.getFile((Resource)node.eResource());
        IProject project = file.getProject();
        IPath webModulePath = Model2Util.getProjectRelativeDocRootPath((IVirtualComponent)Model2Util.findComponent((IResource)project));
        String string = path = defaultPath == null ? nodePath : defaultPath;
        if (path != null && webModulePath != null) {
            webModulePath = webModulePath.append(path);
            return project.getFile(webModulePath);
        }
        return null;
    }

    public static Property getFirstProperty(String name, IPropertyHolder element) {
        for (Property property : element.getProperties()) {
            if (!name.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    public static ILink getILinkForNode(CommonElement element) {
        if (WebProvider.isWebPageNode((TypedElement)element)) {
            return (ILink)element.getAdapter(ILink.class);
        }
        if (WebProvider.isWebApplicationNode((TypedElement)element)) {
            return (ILink)element.getAdapter(ILink.class);
        }
        return null;
    }

    public static Compartment getLinksCompartment(MNode node) {
        if (node == null) {
            return null;
        }
        EList compartments = node.getCompartments();
        for (Compartment compartment : compartments) {
            if (!WebProvider.isLinkCompartment((TypedElement)compartment)) continue;
            return compartment;
        }
        return null;
    }

    private static List<Object> getPathModifiers(IProject project) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.etools.model2.diagram.web", "ExternalHrefPathModification").getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    Object obj;
                    String requiredFacet = elements[j].getAttribute("facet");
                    IFacetedProject fp = ProjectFacetUtil.getFacetedProject((IProject)project);
                    if (fp.hasProjectFacet(ProjectFacetUtil.getProjectFacet((String)requiredFacet)) && (obj = elements[j].createExecutableExtension("class")) instanceof IPathModifier) {
                        list.add(obj);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            WebPlugin.getDefault().getLog().log(e.getStatus());
        }
        return list;
    }

    public static IProject getProjectForElement(CommonElement element) {
        if (element == null) {
            return null;
        }
        if (element.eResource() == null) {
            return null;
        }
        IFile diagramFile = WorkspaceSynchronizer.getFile((Resource)element.eResource());
        return diagramFile.getProject();
    }

    public static IProject getProjectForNode(MNode node) {
        String nodePath = WebProvider.getStringProperty("web.project.key", (IPropertyHolder)node);
        if (nodePath == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(nodePath);
    }

    public static String getStringProperty(String name, IPropertyHolder element) {
        if (name == null || element == null) {
            return null;
        }
        String prop = null;
        for (Property property : element.getProperties()) {
            if (!name.equals(property.getName())) continue;
            prop = property.getValue();
        }
        return prop;
    }

    public static ILink getTarget(IAdaptable node) {
        ILink source = (ILink)node.getAdapter(ILink.class);
        try {
            Collection rr = source.resolveReference("web.reference.workspacePath", null);
            if (!rr.isEmpty()) {
                ILink target = ((IResolvedReference)rr.iterator().next()).getTarget();
                return target;
            }
        }
        catch (ReferenceException referenceException) {}
        return null;
    }

    public static IResource getTargetContainer(IAdaptable node) {
        ILink target = WebProvider.getTarget(node);
        if (target != null) {
            return target.getContainer().getResource();
        }
        return null;
    }

    public static IVirtualComponent getVirtualComponent(EObject element) {
        if (element.eResource() == null) {
            return null;
        }
        IFile diagramFile = WorkspaceSynchronizer.getFile((Resource)element.eResource());
        IVirtualComponent component = Model2Util.findComponent((IResource)diagramFile.getProject());
        return component;
    }

    public static boolean isCompartmentInJSP(Compartment compartment) {
        if (compartment != null) {
            return WebProvider.isJSP((IAdaptable)compartment.getParent());
        }
        return false;
    }

    public static boolean isDataCompartment(TypedElement element) {
        return element == null ? false : "com.ibm.etools.model2.diagram.web.DataCompartment".equals(element.getType());
    }

    public static boolean isDiagram(TypedElement element) {
        return element == null ? false : "com.ibm.etools.model2.diagram.web.WebDiagram".equals(element.getType());
    }

    public static boolean isHREFEdge(TypedElement element) {
        return element == null ? false : "com.ibm.etools.model2.diagram.web.HREFEdgeType".equals(element.getType());
    }

    public static boolean isHREFItem(TypedElement element) {
        return element == null ? false : "com.ibm.etools.model2.diagram.web.WebPageLinkNodeItem".equals(element.getType());
    }

    public static boolean isHTML(IAdaptable fileAdapter) {
        return WebProvider.isOfType(fileAdapter, ContentTypeIdForHTML.ContentTypeID_HTML);
    }

    public static boolean isJSP(IAdaptable fileAdapter) {
        return WebProvider.isOfType(fileAdapter, ContentTypeIdForJSP.ContentTypeID_JSP);
    }

    public static boolean isLinkCompartment(TypedElement element) {
        return element == null ? false : "com.ibm.etools.model2.diagram.web.LinksCompartment".equals(element.getType());
    }

    private static boolean isOfType(IAdaptable fileAdapter, String contentTypeId) {
        boolean result;
        block21: {
            if (fileAdapter == null) {
                return false;
            }
            IFile file = (IFile)fileAdapter.getAdapter(IFile.class);
            result = false;
            InputStream stream = null;
            try {
                try {
                    IContentType type;
                    IContentType contentTypeJSP = Platform.getContentTypeManager().getContentType(contentTypeId);
                    String fileName = file.getName();
                    IContentType[] contentTypes = null;
                    if (file.exists()) {
                        IContentDescription contentDescription = file.getContentDescription();
                        if (contentDescription == null) {
                            stream = file.getContents();
                            contentDescription = Platform.getContentTypeManager().getDescriptionFor(stream, fileName, null);
                        }
                        if (contentDescription != null && (type = contentDescription.getContentType()) != null) {
                            contentTypes = new IContentType[]{type};
                        }
                    }
                    if (contentTypes == null) {
                        contentTypes = Platform.getContentTypeManager().findContentTypesFor(fileName);
                    }
                    int i = 0;
                    while (i < contentTypes.length) {
                        type = contentTypes[i];
                        if (type.isKindOf(contentTypeJSP)) {
                            result = true;
                            break;
                        }
                        ++i;
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    public static boolean isSuspended() {
        return suspendRefresh;
    }

    public static boolean isTargetProject(ILink target) {
        return "builtin.project.nodeid".equals(target.getSpecializedType().getId());
    }

    public static boolean isTargetWebPage(ILink targetNodeId) {
        return "builtin.file.nodeid".equals(targetNodeId.getSpecializedType().getId());
    }

    public static boolean isWebApplicationNode(TypedElement element) {
        return element == null ? false : "com.ibm.etools.model2.diagram.web.WebApplicationNode".equals(element.getType());
    }

    public static boolean isWebPageNode(TypedElement element) {
        return element == null ? false : "com.ibm.etools.model2.diagram.web.WebPageNode".equals(element.getType());
    }

    public static boolean isWebType(IAdaptable fileAdapter) {
        return WebProvider.isJSP(fileAdapter) || WebProvider.isHTML(fileAdapter);
    }

    public static boolean makeTitleProperty(String name, IPropertyHolder element) {
        if (name == null) {
            return false;
        }
        boolean didIt = false;
        for (Property property : element.getProperties()) {
            if (!name.equals(property.getName())) continue;
            element.setTitleProperty(property);
            didIt = true;
            break;
        }
        return didIt;
    }

    public static boolean propertyExists(String name, IPropertyHolder element) {
        if (name == null || element == null) {
            return false;
        }
        for (Property property : element.getProperties()) {
            if (!name.equals(property.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean renamePropertyName(String oldName, String newName, IPropertyHolder element) {
        if (oldName == null || newName == null) {
            return false;
        }
        boolean didIt = false;
        for (Property property : element.getProperties()) {
            if (!oldName.equals(property.getName())) continue;
            property.setName(newName);
            didIt = true;
        }
        return didIt;
    }

    private static void scheduleJob(MNode element) {
        Resource res = element.eResource();
        if (res == null) {
            return;
        }
        Debug.println((String)("Refresh requested for: " + element));
        refresh.addNode(element);
    }

    public static void setEdgeIndexByType(MNode source, MEdge edge) {
        int maxIndex = 0;
        MNode target = edge.getTarget();
        EList outputs = source.getOutput();
        for (MEdge possibleDup : outputs) {
            int possibleDupIndex;
            if (possibleDup == edge || !edge.getType().equals(possibleDup.getType()) || !target.equals(possibleDup.getTarget()) || (possibleDupIndex = Integer.parseInt(WebProvider.getStringProperty("web.dup.index", (IPropertyHolder)possibleDup))) < maxIndex) continue;
            maxIndex = possibleDupIndex;
        }
        Property property = DiagramModelFactory.eINSTANCE.createProperty();
        property.setName("web.dup.index");
        property.setValue(Integer.toString(++maxIndex));
        edge.getPersistedProperties().add((Object)property);
    }

    public static synchronized void suspendRefresh(boolean isSuspendRefresh) {
        suspendRefresh = isSuspendRefresh;
        if (!suspendRefresh && !defferedRefreshNodeList.isEmpty()) {
            for (MNode node : defferedRefreshNodeList) {
                WebProvider.scheduleJob(node);
            }
            defferedRefreshNodeList.clear();
        }
    }

    public static boolean updateStringProperty(String key, String path, IPropertyHolder element) {
        if (key == null) {
            return false;
        }
        boolean didIt = false;
        for (Property property : element.getProperties()) {
            if (!key.equals(property.getName())) continue;
            if (path == null && property.getValue() != null) {
                property.setValue(null);
            } else if (path != null && !path.equals(property.getValue())) {
                property.setValue(path);
            }
            didIt = true;
        }
        return didIt;
    }

    protected void fireProviderChange(ProviderChangeEvent event) {
        super.fireProviderChange(event);
    }

    public boolean provides(IOperation operation) {
        return false;
    }

    private static class RefreshJob
    extends UIJob {
        private final Map<IFile, Set<MNode>> nodes = new HashMap<IFile, Set<MNode>>();

        public RefreshJob() {
            super(Messages.WebProvider_RefreshNodes);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addNode(MNode node) {
            Map<IFile, Set<MNode>> map = this.nodes;
            synchronized (map) {
                IFile file;
                Resource r = node.eResource();
                if (r != null && (file = WorkspaceSynchronizer.getFile((Resource)r)) != null) {
                    Set<MNode> set = this.nodes.get(file);
                    if (set == null) {
                        set = new HashSet<MNode>();
                        this.nodes.put(file, set);
                    }
                    set.add(node);
                }
            }
            this.schedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IFile getNextIFile() {
            Map<IFile, Set<MNode>> map = this.nodes;
            synchronized (map) {
                if (!this.nodes.isEmpty()) {
                    Iterator<IFile> itr = this.nodes.keySet().iterator();
                    IFile file = itr.next();
                    return file;
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<MNode> getNodes(IFile file) {
            Map<IFile, Set<MNode>> map = this.nodes;
            synchronized (map) {
                Set<MNode> n = this.nodes.remove(file);
                if (n == null) {
                    return Collections.emptySet();
                }
                return new HashSet<MNode>(n);
            }
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            IFile file = this.getNextIFile();
            while (file != null) {
                final Set<MNode> nodes = this.getNodes(file);
                if (!nodes.isEmpty()) {
                    Resource res = nodes.iterator().next().eResource();
                    if (res == null || res.getResourceSet() == null) continue;
                    try {
                        ModelUpdateUtils.updateModelNoUndo(null, (Resource)res, (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                for (MNode node : nodes) {
                                    WebProvider.doRefresh(node);
                                }
                            }
                        }, (boolean)false);
                    }
                    catch (Exception exception) {
                        this.schedule(2000L);
                        break;
                    }
                }
                file = this.getNextIFile();
            }
            return Status.OK_STATUS;
        }
    }
}

