/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.nodes;

import com.ibm.etools.diagram.model.internal.DiagramCommandResult;
import com.ibm.etools.diagram.model.internal.commands.IWorkspaceLockMarker;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.model2.diagram.web.internal.WebPlugin;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.references.management.ILink;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;

public class RenameWebPageCommand
extends AbstractCommand
implements IWorkspaceLockMarker {
    private final SetRequest request;
    private IFile newfile;
    private IFile oldFile;
    private boolean undoable = false;

    public RenameWebPageCommand(String label, SetRequest request) {
        super(label);
        this.request = request;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        MNode node = (MNode)this.request.getElementToEdit().eContainer();
        String defaultPath = (String)this.request.getValue();
        this.newfile = WebProvider.getFileForNode(node, defaultPath);
        if (!this.newfile.exists()) {
            this.oldFile = WebProvider.getFileForNode(node);
            try {
                this.oldFile.move(this.newfile.getFullPath(), false, true, progressMonitor);
                node.removeAdapter(ILink.class);
                this.undoable = true;
            }
            catch (CoreException e) {
                WebPlugin.getDefault().getLog().log(e.getStatus());
                return DiagramCommandResult.newErrorCommandResult((Throwable)e);
            }
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return this.doExecuteWithResult(progressMonitor, info);
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.undoable && this.oldFile != null && !this.oldFile.exists() && this.newfile != null && this.newfile.exists()) {
            try {
                this.newfile.move(this.oldFile.getFullPath(), false, true, progressMonitor);
                MNode node = (MNode)this.request.getElementToEdit().eContainer();
                node.removeAdapter(ILink.class);
            }
            catch (CoreException e) {
                return DiagramCommandResult.newErrorCommandResult((Throwable)e);
            }
        }
        return CommandResult.newOKCommandResult();
    }
}

