/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.nodes;

import com.ibm.etools.diagram.model.internal.commands.IWorkspaceLockMarker;
import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.Compartment;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.CommandExecutionAprover;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.TargetAdapter;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.WebTargetTypeUtilities;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.edges.UpdateDupIndexProperty;
import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.edges.UpdateEdgeNameProperty;
import com.ibm.etools.model2.diagram.web.internal.nls.Messages;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.model2.diagram.web.internal.resource.cmds.RefreshEdgeRealizationCommand;
import com.ibm.etools.model2.diagram.web.internal.resource.cmds.items.CreateWebPageLinkResourceCommand;
import com.ibm.etools.model2.diagram.web.internal.resource.cmds.nodes.CreateWebPageResourceCommand;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.web.AbstractWebProvider;
import java.util.Iterator;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.IdentityCommand;

public class RealizeWebPageCommand
extends CompositeCommand
implements IWorkspaceLockMarker {
    public RealizeWebPageCommand(TransactionalEditingDomain domain, MNode node, Object newValue, boolean createResource) {
        super(Messages.RealizeWebPage);
        String tPath = this.getTargetPath(node, newValue);
        if (node != null) {
            node.removeAdapter(IFile.class);
        }
        if (createResource) {
            CreateWebPageResourceCommand cmd = new CreateWebPageResourceCommand(node);
            this.compose((IUndoableOperation)cmd);
        } else {
            node.removeAdapter(ILink.class);
            this.compose((IUndoableOperation)IdentityCommand.INSTANCE);
        }
        if (createResource) {
            EList inputEdges = node.getInput();
            for (MEdge edge : inputEdges) {
                if (!WebProvider.isHREFEdge((TypedElement)edge) || edge.isRealized() || !edge.getSource().isRealized()) continue;
                String targetPath = null;
                targetPath = tPath == null ? WebTargetTypeUtilities.getTargetNodePath(edge.getSource(), edge.getTarget()) : tPath;
                targetPath = WebProvider.externalPathModification(targetPath, WebProvider.getProjectForElement((CommonElement)edge.getTarget()));
                this.addEdgeRealizationCommands(domain, edge, targetPath);
            }
            EList outputEdges = node.getOutput();
            for (MEdge edge : outputEdges) {
                if (!WebProvider.isHREFEdge((TypedElement)edge) || edge.isRealized() || !edge.getTarget().isRealized()) continue;
                String targetPath = null;
                targetPath = tPath == null ? WebTargetTypeUtilities.getTargetNodePath(edge.getSource(), edge.getTarget()) : tPath;
                targetPath = WebProvider.externalPathModification(targetPath, WebProvider.getProjectForElement((CommonElement)edge.getTarget()));
                this.addEdgeRealizationCommands(domain, edge, targetPath);
            }
        }
    }

    private void addEdgeRealizationCommands(TransactionalEditingDomain domain, MEdge edge, String targetPath) {
        UpdateEdgeNameProperty updateEdgeProperties = new UpdateEdgeNameProperty(domain, edge, targetPath, null, false);
        this.compose((IUndoableOperation)updateEdgeProperties);
        boolean hasUntargetted = false;
        MNode source = edge.getSource();
        Iterator iter = source.getCompartments().iterator();
        while (iter.hasNext() && !hasUntargetted) {
            Compartment compartment = (Compartment)iter.next();
            if (!WebProvider.isLinkCompartment((TypedElement)compartment)) continue;
            Iterator itemItr = compartment.getItems().iterator();
            while (itemItr.hasNext() && !hasUntargetted) {
                ILink handle;
                Item item = (Item)itemItr.next();
                if (!WebProvider.isHREFItem((TypedElement)item) || !"".equals(AbstractWebProvider.trimQuotes((String)(handle = (ILink)item.getAdapter(ILink.class)).getLinkText()))) continue;
                hasUntargetted = true;
            }
        }
        if (hasUntargetted) {
            UpdateDupIndexProperty updateindex = new UpdateDupIndexProperty(domain, edge, "0", null, true);
            this.compose((IUndoableOperation)updateindex);
        }
        CreateWebPageLinkResourceCommand createLink = new CreateWebPageLinkResourceCommand(edge.getSource(), false, new CommandExecutionAprover(true), new TargetAdapter(targetPath));
        this.compose((IUndoableOperation)createLink);
        this.compose((IUndoableOperation)new RefreshEdgeRealizationCommand(edge));
    }

    private String getTargetPath(MNode node, Object newValue) {
        IPath docRootRelative;
        String targetPath = "";
        IFile file = null;
        if (newValue instanceof IAdaptable) {
            file = (IFile)((IAdaptable)newValue).getAdapter(IFile.class);
        } else if (newValue instanceof String) {
            IContainer container = WebProvider.getDocumentRootContainer(node.eResource());
            file = Model2Util.getFile((IContainer)container, (String)((String)newValue));
        } else if (newValue instanceof IFile) {
            file = (IFile)newValue;
        }
        if (file != null && (docRootRelative = Model2Util.getDocRootRelativePath((IFile)file)) != null) {
            targetPath = docRootRelative.makeRelative().toString();
        }
        return targetPath;
    }
}

