/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.edges.items;

import com.ibm.etools.model2.diagram.web.internal.nls.Messages;
import com.ibm.etools.webtools.model.ModelPackage;
import com.ibm.etools.webtools.model.api.JSP;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelper;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public class PageDataSelectionDialog
extends SelectionDialog {
    private final List<IElementType> elementTypes;
    private final JSP jsp;
    private final IEditHelper helper;
    private LocalResourceManager manager;
    private TableViewer viewer;

    protected PageDataSelectionDialog(Shell parentShell, List<IElementType> elementTypes, JSP jsp, IEditHelper helper) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.elementTypes = elementTypes;
        this.jsp = jsp;
        this.helper = helper;
    }

    public boolean close() {
        this.getResourceManager().dispose();
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.PageDataSelection);
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getOkButton().setEnabled(false);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite root = new Composite(dialogArea, 0);
        root.setLayoutData((Object)new GridData(1808));
        Label chooseText = new Label(root, 0);
        chooseText.setText(Messages.SelectDataToAddToPage);
        this.viewer = new TableViewer(root, 2052);
        this.viewer.getTable().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new ElementTypeContentProvider(this.jsp, this.helper));
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ElementTypeLabelProvider(this.getResourceManager()));
        this.viewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PageDataSelectionDialog.this.handleSelection(e);
            }
        });
        this.viewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (PageDataSelectionDialog.this.getOkButton().isEnabled()) {
                    PageDataSelectionDialog.this.okPressed();
                }
            }
        });
        GridLayoutFactory factory = GridLayoutFactory.fillDefaults();
        factory.applyTo(root);
        this.viewer.setInput(this.elementTypes);
        return dialogArea;
    }

    protected ResourceManager getResourceManager() {
        if (this.manager == null) {
            this.manager = new LocalResourceManager(JFaceResources.getResources((Display)this.getShell().getDisplay()));
        }
        return this.manager;
    }

    private void handleSelection(SelectionEvent event) {
        if (((IStructuredSelection)this.viewer.getSelection()).size() == 0) {
            this.getOkButton().setEnabled(false);
        } else {
            this.getOkButton().setEnabled(true);
        }
        this.setResult(Collections.singletonList(((IStructuredSelection)this.viewer.getSelection()).getFirstElement()));
    }

    private static class ElementTypeContentProvider
    implements IStructuredContentProvider {
        private final JSP jsp;
        private final IEditHelper helper;

        public ElementTypeContentProvider(JSP jsp, IEditHelper helper) {
            this.jsp = jsp;
            this.helper = helper;
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                List list = (List)inputElement;
                Object[] validTypes = this.getValidTypes(list);
                return validTypes;
            }
            return null;
        }

        public IElementType[] getValidTypes(List list) {
            Iterator listIter = list.iterator();
            ArrayList<IElementType> validList = new ArrayList<IElementType>();
            while (listIter.hasNext()) {
                IElementType type = (IElementType)listIter.next();
                CreateElementRequest req = new CreateElementRequest((EObject)this.jsp, type, ModelPackage.eINSTANCE.getJSP_Data());
                ICommand cmd = this.helper.getEditCommand((IEditCommandRequest)req);
                if (!cmd.canExecute()) continue;
                validList.add(type);
            }
            return validList.toArray(new IElementType[validList.size()]);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class ElementTypeLabelProvider
    extends LabelProvider {
        private final ResourceManager manager;

        public ElementTypeLabelProvider(ResourceManager manager) {
            this.manager = manager;
        }

        public Image getImage(Object element) {
            if (element instanceof IElementType) {
                URL iconURL = ((IElementType)element).getIconURL();
                ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)iconURL);
                return this.manager.createImageWithDefault(descriptor);
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof IElementType) {
                return ((IElementType)element).getDisplayName();
            }
            return super.getText(element);
        }
    }
}

