/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.internal.edithelper.cmds;

import com.ibm.etools.model2.diagram.web.internal.edithelper.cmds.factories.DivFactory;
import com.ibm.etools.model2.diagram.web.internal.nls.Messages;
import com.ibm.etools.references.web.URIUtil;
import com.ibm.etools.webedit.commands.RemoveTagCommand;
import com.ibm.etools.webedit.commands.factories.BRFactory;
import com.ibm.etools.webedit.common.commands.CompoundHTMLCommand;
import com.ibm.etools.webedit.common.commands.EditRangeCommand;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.commands.InsertContainerCommand;
import com.ibm.etools.webedit.common.commands.InsertSolidCommand;
import com.ibm.etools.webedit.common.commands.factories.AbstractNodeFactory;
import com.ibm.etools.webedit.common.commands.factories.NodeFactory;
import com.ibm.etools.webedit.common.editdomain.HTMLCommandTarget;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.utils.ReadOnlySupport;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.html.core.internal.modelquery.DocumentQuery;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;

public class WebDiagramCommandHelper {
    public static final String styleString = "margin: 20px; padding: 10px; border: 2px dashed #aaa; background-color: #eee";
    public static final String idString = "WebDiagramContributions";
    public static final String alignString = "center";
    public static final String faceString = "Arial";
    public static final String divSectionTitleLine1 = Messages.NewLinksFromWDEHEading;
    public static final String divSectionTitleLine2 = Messages.NewLinksFromWDEDesc;

    public static void addLink(HTMLEditDomain domain, AbstractNodeFactory factory, HTMLCommand taglibCommand) throws UnsupportedEncodingException, IOException, CoreException {
        Element divElement;
        CompoundHTMLCommand compoundCommand = new CompoundHTMLCommand("addLink");
        if (taglibCommand != null) {
            compoundCommand.append(taglibCommand);
        }
        IDOMDocument doc = domain.getActiveModel().getDocument();
        Range range = ((DocumentRange)doc).createRange();
        Element target = divElement = doc.getElementById(idString);
        if (divElement == null) {
            DocumentQuery query = (DocumentQuery)doc.getAdapterFor(DocumentQuery.class);
            Range insertionRange = query.getRenderRootRange((Document)doc);
            if (!((IDOMNode)(insertionRange = insertionRange.cloneRange()).getStartContainer()).isChildEditable()) {
                Element element = ReadOnlySupport.getChildEditableCommentElement((Node)insertionRange.getStartContainer(), (boolean)true);
                if (element != null) {
                    insertionRange.setStart(element, 0);
                } else {
                    throw new RuntimeException(Messages.CouldNotFindWritableLocation);
                }
            }
            insertionRange.collapse(true);
            range = insertionRange;
            InsertContainerCommand cc = new InsertContainerCommand((NodeFactory)new DivFactory(factory));
            cc.setCommandTarget((HTMLCommandTarget)domain);
            compoundCommand.append((HTMLCommand)cc);
        } else {
            if (!((IDOMElement)target).isChildEditable()) {
                throw new RuntimeException(Messages.CouldNotFindWritableLocation);
            }
            InsertSolidCommand cmd = new InsertSolidCommand((NodeFactory)factory);
            cmd.setCommandTarget((HTMLCommandTarget)domain);
            compoundCommand.append((HTMLCommand)cmd);
            MyEditRangeCommand cmdForCaret = new MyEditRangeCommand("");
            cmdForCaret.setCommandTarget((HTMLCommandTarget)domain);
            compoundCommand.append((HTMLCommand)cmdForCaret);
            InsertSolidCommand insert = new InsertSolidCommand((NodeFactory)new BRFactory());
            insert.setCommandTarget((HTMLCommandTarget)domain);
            compoundCommand.append((HTMLCommand)insert);
            range.setStart(target, target.getChildNodes().getLength());
            range.collapse(true);
        }
        domain.getSelectionMediator().setRange(range);
        compoundCommand.setCommandTarget((HTMLCommandTarget)domain);
        compoundCommand.execute();
        domain.getModel().save();
    }

    public static HTMLCommand getAddBRCommand(HTMLEditDomain domain) {
        CompoundHTMLCommand htmlCommand = new CompoundHTMLCommand(Messages.WebDiagramCommandHelper_2);
        htmlCommand.setCommandTarget((HTMLCommandTarget)domain);
        MyEditRangeCommand cmdForCaret = new MyEditRangeCommand("");
        cmdForCaret.setCommandTarget((HTMLCommandTarget)domain);
        InsertSolidCommand insert = new InsertSolidCommand((NodeFactory)new BRFactory());
        insert.setCommandTarget((HTMLCommandTarget)domain);
        htmlCommand.append((HTMLCommand)cmdForCaret);
        htmlCommand.append((HTMLCommand)insert);
        return htmlCommand;
    }

    public static boolean removeLink(int whichOne, HTMLEditDomain domain, String tagName, Collection attributeNames, String path) throws UnsupportedEncodingException, IOException, CoreException {
        int matched = 0;
        IDOMDocument doc = domain.getActiveModel().getDocument();
        NodeList list = doc.getElementsByTagName(tagName);
        boolean removed = false;
        int i = 0;
        while (i < list.getLength() && !removed) {
            Element e = (Element)list.item(i);
            if (attributeNames.isEmpty()) {
                boolean doit = true;
                if (whichOne >= 0 && whichOne != ++matched - 1) {
                    doit = false;
                }
                if (doit) {
                    Range range = ((DocumentRange)doc).createRange();
                    range.setStart(e, 0);
                    range.collapse(true);
                    RemoveTagCommand removeTag = new RemoveTagCommand();
                    removeTag.setCommandTarget((HTMLCommandTarget)domain);
                    domain.getSelectionMediator().setRange(range, range.getStartContainer());
                    removeTag.execute();
                    removed = true;
                }
            }
            for (String attributeName : attributeNames) {
                String compareName = e.getAttribute(attributeName);
                if (compareName == null) {
                    compareName = "";
                }
                if (!path.equals(compareName)) continue;
                boolean doit = true;
                if (whichOne >= 0 && whichOne != ++matched - 1) {
                    doit = false;
                }
                if (!doit) continue;
                Range range = ((DocumentRange)doc).createRange();
                range.setStart(e, 0);
                range.collapse(true);
                RemoveTagCommand removeTag = new RemoveTagCommand();
                removeTag.setCommandTarget((HTMLCommandTarget)domain);
                domain.getSelectionMediator().setRange(range, range.getStartContainer());
                removeTag.execute();
                removed = true;
                break;
            }
            ++i;
        }
        if (removed) {
            domain.getModel().save();
        }
        return removed;
    }

    public static boolean updateLink(int whichOne, HTMLEditDomain domain, String tagName, Collection oldAttributeName, String newAttributeName, String oldPath, String targetPath) throws UnsupportedEncodingException, IOException, CoreException {
        return WebDiagramCommandHelper.updateLink(whichOne, domain, tagName, oldAttributeName, newAttributeName, oldPath, targetPath, true);
    }

    public static boolean updateLink(int whichOne, HTMLEditDomain domain, String tagName, Collection oldAttributeName, String newAttributeName, String oldPath, String targetPath, boolean parseParams) throws UnsupportedEncodingException, IOException, CoreException {
        boolean performedUpdate = false;
        if (oldPath != null && oldPath.equals(targetPath)) {
            return performedUpdate;
        }
        IDOMDocument doc = domain.getActiveModel().getDocument();
        NodeList list = doc.getElementsByTagName(tagName);
        int matched = 0;
        int i = 0;
        while (i < list.getLength()) {
            Element e = (Element)list.item(i);
            boolean removeAttribute = false;
            for (String attributeToMatch : oldAttributeName) {
                String actionAttrib = e.getAttribute(attributeToMatch);
                String targetWithParams = targetPath;
                if (targetPath != null && targetPath.length() > 0 && parseParams && actionAttrib != null) {
                    URIUtil.ParsedURI uri = URIUtil.parse((String)actionAttrib);
                    actionAttrib = uri.path;
                    if (uri.query != null) {
                        targetWithParams = String.valueOf(targetWithParams) + "?" + uri.query;
                    }
                    if (uri.fragment != null) {
                        targetWithParams = String.valueOf(targetWithParams) + "#" + uri.fragment;
                    }
                }
                if ((oldPath != null || actionAttrib != null) && (oldPath == null || !oldPath.equals(actionAttrib))) continue;
                boolean doit = true;
                if (whichOne >= 0 && whichOne != ++matched - 1) {
                    doit = false;
                }
                if (doit) {
                    IDOMAttr attr;
                    if (!newAttributeName.equals(attributeToMatch)) {
                        removeAttribute = true;
                    }
                    if ((attr = (IDOMAttr)e.getAttributeNode(newAttributeName)) == null) {
                        Attr newAttr = doc.createAttribute(newAttributeName);
                        newAttr.setValue(targetWithParams);
                        e.setAttributeNode(newAttr);
                    } else {
                        int startOffset = attr.getValueRegionStartOffset();
                        int length = attr.getValueRegionText().length();
                        try {
                            doc.getStructuredDocument().replace(startOffset, length, "\"" + targetWithParams + "\"");
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                    performedUpdate = true;
                }
                if (!removeAttribute) continue;
                e.removeAttribute(attributeToMatch);
            }
            ++i;
        }
        if (performedUpdate) {
            domain.getModel().save();
        }
        return performedUpdate;
    }

    public static class MyEditRangeCommand
    extends EditRangeCommand {
        public MyEditRangeCommand(String name) {
            super(name);
        }

        protected void doExecute() {
            Range range = this.getRange();
            Node node = range.getEndContainer().getParentNode().getFirstChild();
            int i = 1;
            while (node != null) {
                if (node.equals(range.getEndContainer())) break;
                ++i;
                node = node.getNextSibling();
            }
            Node parentNode = range.getEndContainer().getParentNode();
            range.setEnd(parentNode, i);
            range.setStart(parentNode, i);
            this.setRange(range);
        }
    }
}

