/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.internal.adapters;

import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.services.EdgeGeneratorService;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.SpecializedType;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdapterFactory;

public class ILinkAdapterFactory
implements IAdapterFactory {
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof MNode) {
            if (adapterType == ILink.class) {
                return this.getILink((MNode)adaptableObject);
            }
        } else if (adaptableObject instanceof MEdge) {
            return this.getLinkHandle((MEdge)adaptableObject);
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{ILink.class};
    }

    private ILink getILink(MNode node) {
        IProject file;
        if ("com.ibm.etools.model2.diagram.web.WebPageNode".equals(node.getType())) {
            IFile file2 = WebProvider.getFileForNode(node);
            if (file2 != null) {
                LinkNode linkNode = ReferenceManager.getReferenceManager().getLinkNode(file2);
                SpecializedType linkType = ReferenceManager.getReferenceManager().getLinkType("builtin.file.nodeid");
                try {
                    Collection links = linkNode.getLinks(linkType, SpecializedType.Depth.ZERO, null);
                    if (!links.isEmpty()) {
                        return (ILink)links.iterator().next();
                    }
                }
                catch (ReferenceException e) {
                    e.printStackTrace();
                }
            }
        } else if ("com.ibm.etools.model2.diagram.web.WebApplicationNode".equals(node.getType()) && (file = WebProvider.getProjectForNode(node)) != null) {
            LinkNode linkNode = ReferenceManager.getReferenceManager().getLinkNode((IResource)file);
            SpecializedType linkType = ReferenceManager.getReferenceManager().getLinkType("builtin.project.nodeid");
            try {
                Collection links = linkNode.getLinks(linkType, SpecializedType.Depth.ZERO, null);
                if (!links.isEmpty()) {
                    return (ILink)links.iterator().next();
                }
            }
            catch (ReferenceException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private Object getLinkHandle(MEdge edge) {
        if (edge.getSource() == null || edge.getTarget() == null) {
            return null;
        }
        Item item = EdgeGeneratorService.getInstance().getEdgesItem((List)edge.getSource().getCompartments(), edge);
        if (item != null) {
            ILink handle = (ILink)item.getAdapter(ILink.class);
            return handle;
        }
        return null;
    }
}

