<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0" xmlns:xalan="http://xml.apache.org/xslt">

	<xsl:output method="xml" encoding="UTF-8"
		doctype-public="-//IBM//DTD Web Diagram 1.1//EN"
		doctype-system="http://www.ibm.com/dtd/web-diagram_1_1.dtd"
		indent="yes" omit-xml-declaration="no" />

	<xsl:template match="web-diagram">
		<xsl:element name="web-diagram">
			<xsl:element name="properties">
				<xsl:element name="property">
					<xsl:attribute name="name">
						<xsl:value-of select="string('Module Name')" />
					</xsl:attribute>
					<xsl:attribute name="value">
						<xsl:value-of
							select="string('&lt;default module&gt;')" />
					</xsl:attribute>
				</xsl:element>
			</xsl:element>
			<xsl:apply-templates></xsl:apply-templates>
		</xsl:element>
	</xsl:template>
	<xsl:template match="nodes">
		<xsl:element name="nodes">
			<xsl:apply-templates></xsl:apply-templates>
		</xsl:element>
	</xsl:template>
	<xsl:template match="node">
		<xsl:element name="node">
			<xsl:copy-of select="@id" />
			<xsl:choose>
				<xsl:when test="@type = 'action'">
					<xsl:apply-templates select="." mode="action"></xsl:apply-templates>
				</xsl:when>
				<xsl:when test="@type = 'page'">
					<xsl:apply-templates select="." mode="page"></xsl:apply-templates>
				</xsl:when>
				<xsl:when test="@type = 'form-bean'">
					<xsl:apply-templates select="." mode="form-bean"></xsl:apply-templates>
				</xsl:when>
				<xsl:when test="@type = 'note'">
					<xsl:apply-templates select="." mode="note"></xsl:apply-templates>
				</xsl:when>
				<xsl:when test="@type = 'webapp'">
					<xsl:apply-templates select="." mode="webapp"></xsl:apply-templates>
				</xsl:when>
				<xsl:when test="@type = 'module'">
					<xsl:apply-templates select="." mode="module"></xsl:apply-templates>
				</xsl:when>
				<xsl:when test="@beanId">
					<xsl:apply-templates select="." mode="javabean">
					</xsl:apply-templates>
				</xsl:when>
			</xsl:choose>
		</xsl:element>
	</xsl:template>
	<xsl:template match="description" mode="description">
		<xsl:element name="description">
			<xsl:value-of select="text()" />
		</xsl:element>
	</xsl:template>
	<xsl:template match="location" mode="location">
		<xsl:copy-of select="." />
	</xsl:template>
	<xsl:template match="node" mode="action">
		<xsl:attribute name="type">
			<xsl:value-of
				select="string('com.ibm.etools.struts.graphical.providers.model.ActionMappingProvider')" />
		</xsl:attribute>
		<xsl:apply-templates select="description" mode="description"></xsl:apply-templates>
		<xsl:element name="properties">
			<xsl:element name="property">
				<xsl:attribute name="name">
					<xsl:value-of
						select="string('Action Mapping Name')" />
				</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="normalize-space(@path)" />
				</xsl:attribute>
			</xsl:element>
			<!--  
			<xsl:element name="property">
				<xsl:attribute name="name">
					<xsl:value-of select="string('hidden')" />
				</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="string('false')" />
				</xsl:attribute>
			</xsl:element>
			 -->
		</xsl:element>
		<xsl:apply-templates select="location" mode="location"></xsl:apply-templates>
	</xsl:template>
	<xsl:template match="node" mode="page">
		<xsl:attribute name="type">
			<xsl:value-of
				select="string('com.ibm.etools.model2.web.providers.model.WebPageProvider')" />
		</xsl:attribute>
		<xsl:apply-templates select="description" mode="description"></xsl:apply-templates>
		<xsl:element name="properties">
			<xsl:element name="property">
				<xsl:attribute name="name">
					<xsl:value-of select="string('Web Page Path')" />
				</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="normalize-space(@path)" />
				</xsl:attribute>
			</xsl:element>
			<xsl:element name="property">
				<xsl:attribute name="name">
					<xsl:value-of select="string('hidden')" />
				</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="string('false')" />
				</xsl:attribute>
			</xsl:element>
		</xsl:element>
		<xsl:apply-templates select="location" mode="location"></xsl:apply-templates>
	</xsl:template>
	<xsl:template match="node" mode="form-bean">
		<xsl:attribute name="type">
			<xsl:value-of
				select="string('com.ibm.etools.struts.graphical.providers.model.FormBeanProvider')" />
		</xsl:attribute>
		<xsl:apply-templates select="description" mode="description"></xsl:apply-templates>
		<xsl:element name="properties">
			<xsl:element name="property">
				<xsl:attribute name="name">
					<xsl:value-of select="string('Form Bean Name')" />
				</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="normalize-space(@path)" />
				</xsl:attribute>
			</xsl:element>
			<xsl:element name="property">
				<xsl:attribute name="name">
					<xsl:value-of select="string('Form Bean Scope')" />
				</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="normalize-space(@scope)" />
				</xsl:attribute>
			</xsl:element>
			<xsl:element name="property">
				<xsl:attribute name="name">
					<xsl:value-of select="string('hidden')" />
				</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="string('false')" />
				</xsl:attribute>
			</xsl:element>
		</xsl:element>
		<xsl:apply-templates select="location" mode="location"></xsl:apply-templates>
	</xsl:template>
	<xsl:template match="node" mode="note">
		<xsl:attribute name="type">
			<xsl:value-of
				select="string('com.ibm.etools.web.diagram.core.providers.model.MultiLineLabelProvider')" />
		</xsl:attribute>
		<xsl:apply-templates select="description" mode="description"></xsl:apply-templates>
		<xsl:element name="properties">
			<xsl:element name="property">
				<xsl:attribute name="name">
					<xsl:value-of select="string('hidden')" />
				</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="string('false')" />
				</xsl:attribute>
			</xsl:element>
		</xsl:element>
		<xsl:apply-templates select="location" mode="location"></xsl:apply-templates>
	</xsl:template>
	<xsl:template match="node" mode="webapp">
		<xsl:attribute name="type">
			<xsl:value-of
				select="string('com.ibm.etools.model2.web.providers.model.WebAppProvider')" />
		</xsl:attribute>
		<xsl:apply-templates select="description" mode="description"></xsl:apply-templates>
		<xsl:element name="properties">
			<xsl:element name="property">
				<xsl:attribute name="name">
					<xsl:value-of select="string('Web App Path')" />
				</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="normalize-space(@path)" />
				</xsl:attribute>
			</xsl:element>
			<xsl:element name="property">
				<xsl:attribute name="name">
					<xsl:value-of select="string('hidden')" />
				</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="string('false')" />
				</xsl:attribute>
			</xsl:element>
		</xsl:element>
		<xsl:apply-templates select="location" mode="location"></xsl:apply-templates>
	</xsl:template>
	<xsl:template match="node" mode="module">
		<xsl:attribute name="type">
			<xsl:value-of
				select="string('com.ibm.etools.struts.graphical.providers.model.StrutsModuleProvider')" />
		</xsl:attribute>
		<xsl:apply-templates select="description" mode="description"></xsl:apply-templates>
		<xsl:element name="properties">
			<xsl:element name="property">
				<xsl:attribute name="name">
					<xsl:value-of select="string('Struts Module Name')" />
				</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="normalize-space(@path)" />
				</xsl:attribute>
			</xsl:element>
			<xsl:element name="property">
				<xsl:attribute name="name">
					<xsl:value-of
						select="string('Action Mapping Name')" />
				</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of
						select="normalize-space(@entryAction)" />
				</xsl:attribute>
			</xsl:element>
			<xsl:element name="property">
				<xsl:attribute name="name">
					<xsl:value-of select="string('hidden')" />
				</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="string('false')" />
				</xsl:attribute>
			</xsl:element>
		</xsl:element>
		<xsl:apply-templates select="location" mode="location"></xsl:apply-templates>
	</xsl:template>
	<xsl:template match="node" mode="javabean">
		<xsl:attribute name="type">
			<xsl:value-of
				select="string('com.ibm.etools.web.diagram.core.providers.model.JavaBeanProvider')" />
		</xsl:attribute>
		<xsl:apply-templates select="description" mode="description"></xsl:apply-templates>
		<xsl:element name="properties">
			<xsl:element name="property">
				<xsl:attribute name="name">
					<xsl:value-of select="string('Java Bean Scope')" />
				</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="normalize-space(@scope)" />
				</xsl:attribute>
			</xsl:element>
			<xsl:element name="property">
				<xsl:attribute name="name">
					<xsl:value-of select="string('Java Bean Path')" />
				</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="normalize-space(@path)" />
				</xsl:attribute>
			</xsl:element>
			<xsl:element name="property">
				<xsl:attribute name="name">
					<xsl:value-of select="string('Java Bean id')" />
				</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="normalize-space(@beanId)" />
				</xsl:attribute>
			</xsl:element>
			<xsl:element name="property">
				<xsl:attribute name="name">
					<xsl:value-of select="string('hidden')" />
				</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="string('false')" />
				</xsl:attribute>
			</xsl:element>
		</xsl:element>
		<xsl:apply-templates select="location" mode="location"></xsl:apply-templates>
	</xsl:template>
	<xsl:template match="wires">
		<xsl:element name="edges">
			<xsl:apply-templates></xsl:apply-templates>
		</xsl:element>
	</xsl:template>
	<xsl:template match="wire">
		<xsl:element name="edge">

			<xsl:variable name="sourceid" select="string(@source)"></xsl:variable>
			<xsl:variable name="targetid" select="string(@target)"></xsl:variable>
			<xsl:variable name="sourcetype"
				select="//node[@id=$sourceid]/@type">
			</xsl:variable>
			<xsl:variable name="targettype"
				select="//node[@id=$targetid]/@type">
			</xsl:variable>

			<xsl:choose>
				<xsl:when
					test="$sourcetype = 'form-bean' or $sourcetype = 'javabean'">
					<xsl:apply-templates select="."
						mode="getMappingForType">
						<xsl:with-param name="sourcetype"
							select="$targettype">
						</xsl:with-param>
					</xsl:apply-templates>
					<xsl:attribute name="source">
						<xsl:value-of select="@target" />
					</xsl:attribute>
					<xsl:attribute name="target">
						<xsl:value-of select="@source" />
					</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="."
						mode="getMappingForType">
						<xsl:with-param name="sourcetype"
							select="$sourcetype">
						</xsl:with-param>
					</xsl:apply-templates>
					<xsl:copy-of select="@source"></xsl:copy-of>
					<xsl:copy-of select="@target"></xsl:copy-of>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:element name="properties">
				<xsl:if test="@identifier = '&lt;new&gt;'">
					<xsl:element name="property">
						<xsl:attribute name="name">
							<xsl:value-of
								select="string('Forward name')">
							</xsl:value-of>
						</xsl:attribute>
						<xsl:attribute name="value">
							<xsl:value-of
								select="string('&lt;new&gt;')">
							</xsl:value-of>
						</xsl:attribute>
					</xsl:element>
				</xsl:if>
			</xsl:element>
			<xsl:apply-templates select="bendpoints"></xsl:apply-templates>
		</xsl:element>
	</xsl:template>
	<xsl:template match="wire" mode="getMappingForType">
		<xsl:param name="sourcetype"></xsl:param>

		<xsl:choose>
			<xsl:when test="$sourcetype = 'webapp'">
				<xsl:attribute name="type">
					<xsl:message>This is an error</xsl:message>
				</xsl:attribute>
			</xsl:when>
			<xsl:when test="$sourcetype = 'module'">
				<xsl:attribute name="type">
					<xsl:value-of
						select="string('com.ibm.etools.struts.graphical.providers.model.StrutsModuleProvider')" />
				</xsl:attribute>
			</xsl:when>
			<xsl:when test="$sourcetype = 'page'">
				<xsl:attribute name="type">
					<xsl:value-of
						select="string('com.ibm.etools.model2.web.providers.edge.WebPageLinkEdgeProvider')" />
				</xsl:attribute>
			</xsl:when>
			<xsl:when test="$sourcetype = 'action'">
				<xsl:attribute name="type">
					<xsl:value-of
						select="string('com.ibm.etools.struts.graphical.providers.edge.ActionMappingLocalForwardEdgeProvider')" />
				</xsl:attribute>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="bendpoints">
		<xsl:element name="bendpoints">
			<xsl:apply-templates></xsl:apply-templates>
		</xsl:element>
	</xsl:template>
	<xsl:template match="bendpoint">
		<xsl:element name="bendpoint">
			<xsl:copy-of select="@weight" />
			<xsl:element name="dimensions">
				<xsl:apply-templates></xsl:apply-templates>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="dimension">
		<xsl:copy-of select="." />
	</xsl:template>
</xsl:stylesheet>
