/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.wizards;

import com.ibm.etools.model2.base.facet.ProjectFacetUtil;
import com.ibm.etools.model2.diagram.web.ui.internal.ide.WebDiagramFileCreator;
import com.ibm.etools.model2.diagram.web.ui.internal.ide.WebEditorUtil;
import com.ibm.etools.model2.diagram.web.ui.internal.nls.Messages;
import com.ibm.etools.model2.diagram.web.ui.internal.wizards.DiagramCreationWizard;
import com.ibm.etools.model2.diagram.web.ui.internal.wizards.WebWizardPage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.wizards.EditorWizardPage;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.util.DiagramFileCreator;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;

public class DiagramWizardPage
extends EditorWizardPage {
    public DiagramWizardPage(IWorkbench aWorkbench, IStructuredSelection selection) {
        super("com.ibm.etools.model2.diagram.web.WebDiagram", aWorkbench, selection);
        this.setTitle(Messages.WebDiagramFile);
        this.setDescription(Messages.CreateNewWebDiagramFile);
    }

    public IFile createAndOpenDiagram(IPath containerPath, String fileName, InputStream initialContents, String kind, IWorkbenchWindow dWindow, IProgressMonitor progressMonitor, boolean saveDiagram) {
        Collection<WebWizardPage> pages = ((DiagramCreationWizard)this.getWizard()).getWebWizardPages();
        try {
            return WebEditorUtil.createAndOpenWebDiagram(this.getDiagramFileCreator(), containerPath, fileName, initialContents, kind, dWindow, progressMonitor, this.isOpenNewlyCreatedDiagramEditor(), saveDiagram, pages, false);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.ibm.etools.model2.diagram.web.ui.wde_wizard");
    }

    public boolean doFinish(final IProgressMonitor monitor) {
        final boolean[] bolHolder = new boolean[1];
        SafeRunnable runnable = new SafeRunnable(){

            public void run() throws Exception {
                DiagramWizardPage.this.diagramFile = DiagramWizardPage.this.createAndOpenDiagram(DiagramWizardPage.this.getContainerFullPath(), DiagramWizardPage.this.getFileName(), DiagramWizardPage.this.getInitialContents(), DiagramWizardPage.this.getDiagramKind(), DiagramWizardPage.this.workbench.getActiveWorkbenchWindow(), monitor, true);
                bolHolder[0] = DiagramWizardPage.this.diagramFile != null;
            }
        };
        SafeRunner.run((ISafeRunnable)runnable);
        return bolHolder[0];
    }

    protected String getDefaultFileName() {
        return "WebDiagram";
    }

    public DiagramFileCreator getDiagramFileCreator() {
        return WebDiagramFileCreator.getInstance();
    }

    protected String getDiagramKind() {
        return "com.ibm.etools.model2.diagram.web.WebDiagram";
    }

    protected boolean validatePage() {
        boolean valid = super.validatePage();
        if (valid) {
            String fileName = this.getFileName();
            if (fileName == null) {
                return false;
            }
            IPath path = this.getContainerFullPath().append(fileName);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            IFacetedProject project = ProjectFacetUtil.getFacetedProject((IProject)file.getProject());
            boolean bl = valid = project != null;
            if (valid) {
                boolean bl2 = valid = ProjectFacetUtil.getInstalledFacetVersion((IFacetedProject)project, (String)"jst.web") != null;
            }
            if (!valid) {
                this.setErrorMessage(Messages.LocationMustBeWithinDynamicWebProject);
            } else {
                this.setErrorMessage(null);
                ((DiagramCreationWizard)this.getWizard()).updateWizardPages(file.getProject());
            }
        }
        return valid;
    }
}

