/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.resourcelisteners;

import com.ibm.etools.diagram.model.internal.emf.Compartment;
import com.ibm.etools.diagram.model.internal.emf.MDiagram;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.NodeItem;
import com.ibm.etools.diagram.model.internal.emf.SubItem;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.model2.diagram.web.ui.internal.nls.Messages;
import com.ibm.etools.references.events.IReferenceListener;
import com.ibm.etools.references.events.ReferenceEvent;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.ReferenceManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.progress.UIJob;

public class ImageToDiagramUpdateManager {
    private static ImageListener LISTENER = null;
    private static final Set<DiagramEditDomain> domains = new HashSet<DiagramEditDomain>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void registerEditDomain(DiagramEditDomain domain) {
        if (domain != null) {
            Set<DiagramEditDomain> set = domains;
            synchronized (set) {
                domains.add(domain);
                ImageToDiagramUpdateManager.startup();
            }
        }
    }

    private static final void shutdown() {
        if (domains.size() == 0 && LISTENER != null) {
            ReferenceManager.getReferenceManager().removeReferenceListener((IReferenceListener)LISTENER);
            LISTENER = null;
        }
    }

    private static final void startup() {
        if (domains.size() > 0 && LISTENER == null) {
            LISTENER = new ImageListener();
            ReferenceManager.getReferenceManager().addReferenceListener((IReferenceListener)LISTENER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void unregisterEditDomain(DiagramEditDomain domain) {
        if (domain != null) {
            Set<DiagramEditDomain> set = domains;
            synchronized (set) {
                domains.remove(domain);
                ImageToDiagramUpdateManager.shutdown();
            }
        }
    }

    private static class ImageListener
    implements IReferenceListener {
        final RefreshUI job = new RefreshUI();

        public void handleReferenceEvents(List<ReferenceEvent> events) {
            this.job.addEvents(events);
        }
    }

    private static class RefreshUI
    extends Job {
        private final List queue = new ArrayList();

        RefreshUI() {
            super(Messages.ImageToDiagramUpdateManager_1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addEvents(Collection events) {
            if (events.isEmpty()) {
                return;
            }
            List list = this.queue;
            synchronized (list) {
                this.queue.addAll(events);
                this.queue.notify();
            }
            this.schedule();
        }

        public boolean belongsTo(Object family) {
            return RefreshUI.class == family;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set getAllEvents() {
            List list = this.queue;
            synchronized (list) {
                if (this.queue.isEmpty()) {
                    return Collections.EMPTY_SET;
                }
                HashSet s = new HashSet(this.queue);
                this.queue.clear();
                return s;
            }
        }

        private List getParts(DiagramEditDomain domain, EObject object) {
            String id = ((XMLResource)object.eResource()).getID(object);
            List parts = domain.getDiagramEditorPart().getDiagramGraphicalViewer().findEditPartsForElement(id, INodeEditPart.class);
            return parts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            if (WebProvider.isSuspended()) {
                monitor.beginTask(Messages.ImageToDiagramUpdateManager_2, 1);
                this.schedule(500L);
                monitor.worked(1);
                monitor.done();
                return Status.OK_STATUS;
            }
            monitor.beginTask(Messages.ImageToDiagramUpdateManager_7, -1);
            Set events = this.getAllEvents();
            while (!events.isEmpty()) {
                HashSet domainsCopy = null;
                Set set = domains;
                synchronized (set) {
                    domainsCopy = new HashSet(domains);
                }
                for (DiagramEditDomain domain : domainsCopy) {
                    MDiagram diagram;
                    DiagramEditPart diagramEditPart;
                    IDiagramWorkbenchPart diagramEditorPart = domain.getDiagramEditorPart();
                    if (diagramEditorPart == null || diagramEditorPart.getDiagram() == null || diagramEditorPart.getDiagram().getElement() == null || !"http://www.ibm.com/etools/7.0/DiagramModel".equals(diagramEditorPart.getDiagram().getElement().eClass().getEPackage().getNsURI()) || (diagramEditPart = diagramEditorPart.getDiagramEditPart()) == null || (diagram = (MDiagram)diagramEditPart.resolveSemanticElement()) == null) continue;
                    ArrayList nodes = new ArrayList(diagram.getNodes());
                    int size = nodes.size();
                    int count = 0;
                    for (MNode node : nodes) {
                        monitor.subTask(NLS.bind((String)Messages.ImageToDiagramUpdateManager_nodeXofY, (Object)(++count), (Object)size));
                        ArrayList compartments = new ArrayList(node.getCompartments());
                        for (Compartment compartment : compartments) {
                            ArrayList items = new ArrayList(compartment.getItems());
                            for (NodeItem item : items) {
                                if (item.eResource() == null) continue;
                                HashSet itemsToRefresh = new HashSet();
                                for (ReferenceEvent handleChangedEvent : events) {
                                    EList children;
                                    IReferenceElement element = handleChangedEvent.getReferenceElement();
                                    if (element.getElementType() != IReferenceElement.ElementType.LINK) continue;
                                    ILink originalHandle = (ILink)element;
                                    ILink handle = (ILink)item.getAdapter(ILink.class);
                                    if (originalHandle.equals(handle)) {
                                        itemsToRefresh.addAll(this.getParts(domain, (EObject)item));
                                        children = item.getChildren();
                                        for (SubItem sItem : children) {
                                            if (sItem.eResource() == null) continue;
                                            itemsToRefresh.addAll(this.getParts(domain, (EObject)sItem));
                                        }
                                        continue;
                                    }
                                    children = new ArrayList(item.getChildren());
                                    for (SubItem sItem : children) {
                                        ILink kidHandle;
                                        if (sItem.eResource() == null || !originalHandle.equals(kidHandle = (ILink)sItem.getAdapter(ILink.class))) continue;
                                        itemsToRefresh.addAll(this.getParts(domain, (EObject)sItem));
                                    }
                                }
                                if (itemsToRefresh.size() <= 0) continue;
                                UpdateEditPartsJob job = new UpdateEditPartsJob(itemsToRefresh);
                                job.schedule();
                            }
                        }
                    }
                }
                if (monitor.isCanceled()) {
                    return Status.OK_STATUS;
                }
                events = this.getAllEvents();
            }
            return Status.OK_STATUS;
        }
    }

    private static class UpdateEditPartsJob
    extends UIJob {
        private final Set itemsToRefresh;

        public UpdateEditPartsJob(Set itemsToRefresh) {
            super(Messages.ImageToDiagramUpdateManager_0);
            this.itemsToRefresh = itemsToRefresh;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            for (EditPart part : this.itemsToRefresh) {
                if (!part.isActive() || part.getModel() == null) continue;
                part.refresh();
            }
            return Status.OK_STATUS;
        }
    }
}

