/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.providers.config;

import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.NodeItem;
import com.ibm.etools.diagram.model.internal.providers.IConfiguratorProvider;
import com.ibm.etools.diagram.ui.internal.adapters.OpenAdapter;
import com.ibm.etools.diagram.ui.internal.adapters.ResourceSelectionDialogAdapter;
import com.ibm.etools.j2ee.common.dialogs.ProjectSelectionDialog;
import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.model2.diagram.web.ui.internal.WebUIPlugin;
import com.ibm.etools.model2.diagram.web.ui.internal.dialogs.SelectWebPageTreeDialog;
import com.ibm.etools.model2.diagram.web.ui.internal.nls.Messages;
import com.ibm.etools.references.management.ILink;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.servlet.ui.project.facet.WebProjectWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class WebUIConfiguratorProvider
extends WebProvider
implements IConfiguratorProvider {
    private void addAdapters(CommonElement element) {
        if ("com.ibm.etools.model2.diagram.web.WebPageNode".equals(element.getType())) {
            WebPageOpenAdapter openAdapter = new WebPageOpenAdapter((MNode)element);
            element.addAdapter((Object)openAdapter, OpenAdapter.class);
            WebPageDialogAdapter dialogAdapter = new WebPageDialogAdapter((MNode)element);
            element.addAdapter((Object)dialogAdapter, ResourceSelectionDialogAdapter.class);
        } else if ("com.ibm.etools.model2.diagram.web.WebApplicationNode".equals(element.getType())) {
            WebProjectOpenAdapter openAdapter = new WebProjectOpenAdapter(element);
            element.addAdapter((Object)openAdapter, OpenAdapter.class);
            WebProjectDialogAdapter dialogAdapter = new WebProjectDialogAdapter((MNode)element);
            element.addAdapter((Object)dialogAdapter, ResourceSelectionDialogAdapter.class);
        } else if ("com.ibm.etools.model2.diagram.web.WebPageLinkNodeItem".equals(element.getType())) {
            element.addAdapter((Object)new LinkBasedOpenAdapter((Item)((NodeItem)element)), OpenAdapter.class);
        }
    }

    public void configureExisting(CommonElement element, Object existing, Map options) {
        this.addAdapters(element);
    }

    public void configureLoad(CommonElement element) {
        this.addAdapters(element);
    }

    public void configureNew(CommonElement element) {
        this.addAdapters(element);
    }

    private class LinkBasedOpenAdapter
    extends OpenAdapter {
        private final Item item;

        public LinkBasedOpenAdapter(Item item) {
            this.item = item;
        }

        public IFile getFileToOpen() {
            return WebUIConfiguratorProvider.getFileForNode((MNode)this.item.getNode());
        }

        public IMarker getMarker() {
            try {
                ILink link = (ILink)this.item.getAdapter(ILink.class);
                if (link != null) {
                    HashMap options = new HashMap();
                    MarkerUtilities.setLineNumber(options, (int)link.getContextLocation().getLinenumber());
                    MarkerUtilities.setCharStart(options, (int)link.getContextLocation().getOffset());
                    MarkerUtilities.setCharEnd(options, (int)(link.getContextLocation().getOffset() + link.getContextLocation().getLength()));
                    IMarker marker = this.getFileToOpen().createMarker("org.eclipse.core.resources.marker");
                    marker.setAttributes(options);
                    return marker;
                }
            }
            catch (CoreException e) {
                WebUIPlugin.getDefault().getLog().log(e.getStatus());
            }
            return super.getMarker();
        }
    }

    private static class WebPageDialogAdapter
    extends ResourceSelectionDialogAdapter {
        private final MNode node;

        public WebPageDialogAdapter(MNode node) {
            this.node = node;
        }

        public SelectionDialog getDialog(Shell shell, Map params) {
            if (this.node.isRealized()) {
                return null;
            }
            SelectWebPageTreeDialog dialog = new SelectWebPageTreeDialog(shell, this.node);
            return dialog;
        }

        public String getStringForResult(Object value) {
            if (value instanceof IFile) {
                String name = ((IFile)value).getProjectRelativePath().lastSegment();
                return name;
            }
            return super.getStringForResult(value);
        }
    }

    private static class WebPageOpenAdapter
    extends OpenAdapter {
        private final MNode node;

        public WebPageOpenAdapter(MNode node) {
            this.node = node;
        }

        public IFile getFileToOpen() {
            return (IFile)this.node.getAdapter(IFile.class);
        }
    }

    private static class WebProjectDialogAdapter
    extends ResourceSelectionDialogAdapter {
        private final MNode node;

        public WebProjectDialogAdapter(MNode node) {
            this.node = node;
        }

        public SelectionDialog getDialog(Shell shell, Map params) {
            if (this.node.isRealized()) {
                return null;
            }
            ProjectSelectionDialog dialog = new ProjectSelectionDialog(shell){

                protected Control createContents(Composite parent) {
                    Composite composite = new Composite(parent, 0);
                    GridLayout layout = new GridLayout();
                    layout.marginHeight = 0;
                    layout.marginWidth = 0;
                    layout.verticalSpacing = 0;
                    composite.setLayout((Layout)layout);
                    composite.setLayoutData((Object)new GridData(1808));
                    1.applyDialogFont((Control)composite);
                    this.initializeDialogUnits((Control)composite);
                    Composite col2 = new Composite(composite, 0);
                    col2.setLayoutData((Object)new GridData(1808));
                    GridLayout col2Layout = new GridLayout();
                    col2Layout.numColumns = 2;
                    col2Layout.marginTop = 0;
                    col2Layout.marginBottom = 0;
                    col2Layout.marginLeft = 0;
                    col2Layout.marginRight = 10;
                    col2.setLayout((Layout)col2Layout);
                    Composite dialog = new Composite(col2, 0);
                    dialog.setLayoutData((Object)new GridData(1808));
                    GridLayout dialogLayout = new GridLayout();
                    dialogLayout.marginTop = 0;
                    dialogLayout.marginBottom = 0;
                    dialogLayout.marginLeft = 0;
                    dialogLayout.marginRight = 0;
                    dialogLayout.horizontalSpacing = 0;
                    dialogLayout.verticalSpacing = 0;
                    dialog.setLayout((Layout)dialogLayout);
                    Label text = new Label(dialog, 0);
                    text.setText(Messages.ChooseAWebProject);
                    this.dialogArea = this.createDialogArea(dialog);
                    Button newButton = new Button(col2, 8);
                    newButton.setText(Messages.New_dotdotdot);
                    GridData bData = new GridData(1, 1, false, false);
                    bData.verticalIndent = 30;
                    newButton.setLayoutData((Object)bData);
                    newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            WebProjectWizard wizard = new WebProjectWizard();
                            wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection());
                            WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)wizard);
                            int status = dialog.open();
                            if (status == 0) {
                                Vector v = this.calculateProjects();
                                projectList.setInput((Object)v);
                            }
                        }
                    });
                    this.buttonBar = this.createButtonBar(composite);
                    return composite;
                }

                protected void createTableControl(Composite dialogArea) {
                    super.createTableControl(dialogArea);
                }

                protected boolean includeProject(IProject project) {
                    return Model2Util.isWebProject((IProject)project);
                }
            };
            dialog.setTitle(Messages.WebProjectSelection);
            dialog.setMessage(Messages.PickAWebProject);
            dialog.setMessage(null);
            return dialog;
        }

        public String getStringForResult(Object value) {
            if (value instanceof IFile) {
                String name = ((IFile)value).getProjectRelativePath().lastSegment();
                return name;
            }
            if (value instanceof IProject) {
                return ((IProject)value).getName();
            }
            return super.getStringForResult(value);
        }
    }

    private static class WebProjectOpenAdapter
    extends OpenAdapter {
        private final CommonElement node;

        public WebProjectOpenAdapter(CommonElement node) {
            this.node = node;
        }

        public IFile getFileToOpen() {
            IProject project;
            String projectName = WebUIConfiguratorProvider.getStringProperty((String)"web.project.key", (IPropertyHolder)this.node);
            if (projectName != null && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)).exists()) {
                DiagramLocator locator = new DiagramLocator();
                try {
                    project.accept((IResourceVisitor)locator);
                }
                catch (CoreException coreException) {}
                return locator.getDiagramFile();
            }
            return null;
        }

        private static class DiagramLocator
        implements IResourceVisitor {
            private IFile diagramFile;

            private DiagramLocator() {
            }

            public IFile getDiagramFile() {
                return this.diagramFile;
            }

            public boolean visit(IResource resource) throws CoreException {
                if (this.diagramFile != null) {
                    return false;
                }
                if (resource.getType() == 2 || resource.getType() == 4) {
                    return true;
                }
                if (resource.getType() == 1 && resource.getFileExtension().equals("gph")) {
                    this.diagramFile = (IFile)resource;
                }
                return false;
            }
        }
    }
}

