/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.providers;

import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.diagram.ui.internal.services.IPropertyDisplayProvider;
import com.ibm.etools.model2.diagram.web.internal.providers.WebProvider;
import com.ibm.etools.model2.diagram.web.ui.internal.nls.Messages;
import com.ibm.etools.references.web.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;

public class WebPropertyDisplayProvider
extends WebProvider
implements IPropertyDisplayProvider {
    public String getEditString(Property property) {
        if ("web.path.key".equals(property.getName())) {
            String nodePath = property.getValue();
            if (nodePath != null) {
                Path p = new Path(nodePath);
                p = p.removeFileExtension();
                return p.lastSegment();
            }
            return this.getPrintString(property);
        }
        return null;
    }

    public int getFontColor(Property property) {
        if ("wde.no.items.placeholder".equals(property.getName())) {
            int red = 184;
            int green = 181;
            int blue = 168;
            Integer colorInteger = new Integer(blue << 16 | green << 8 | red);
            return colorInteger;
        }
        if (Messages.NoTarget.equals(this.getPrintString(property))) {
            int red = 184;
            int green = 181;
            int blue = 168;
            Integer colorInteger = new Integer(blue << 16 | green << 8 | red);
            return colorInteger;
        }
        return -1;
    }

    public String getFontName(Property property) {
        return null;
    }

    public String getPrintString(Property property) {
        if ("web.path.key".equals(property.getName())) {
            String nodePath;
            if (property.eContainer() instanceof MNode && (nodePath = property.getValue()) != null) {
                Path p = new Path(nodePath);
                String lastSegment = p.lastSegment();
                return "".equals(lastSegment) || lastSegment == null ? Messages.NoTarget : TextProcessor.process((String)lastSegment);
            }
        } else if ("web.itemname.key".equals(property.getName())) {
            String value = property.getValue();
            if (value == null || value.length() == 0) {
                return Messages.NoTarget;
            }
            URIUtil.ParsedURI uri = URIUtil.parse((String)value);
            String path = uri.path;
            if (path != null) {
                int lastIndex = path.lastIndexOf(47);
                if (lastIndex >= 0 && lastIndex < path.length() - 1) {
                    path = new String(path.substring(lastIndex + 1, path.length()));
                } else if (lastIndex >= 0 && lastIndex < path.length()) {
                    path = new String(path.substring(lastIndex, path.length()));
                }
            }
            return path;
        }
        return null;
    }

    public String getTooltip(Property property) {
        if ("web.path.key".equals(property.getName())) {
            if (property.eContainer() instanceof MNode) {
                String value = property.getValue();
                if (value == null || value.length() == 0) {
                    value = Messages.NoTarget;
                }
                String resultString = NLS.bind((String)Messages.NodeTypeWebPageTooltipX, (Object)TextProcessor.process((String)value));
                MNode node = (MNode)property.eContainer();
                if (!node.isRealized()) {
                    resultString = String.valueOf(resultString) + "\n" + Messages.WebPageDoesNotExist;
                }
                return resultString;
            }
        } else if ("web.project.key".equals(property.getName())) {
            if (property.eContainer() instanceof MNode) {
                String value = property.getValue();
                String resultString = NLS.bind((String)Messages.NodeTypeWebProjectTooltipX, (Object)TextProcessor.process((String)value));
                MNode node = (MNode)property.eContainer();
                if (!node.isRealized()) {
                    resultString = String.valueOf(resultString) + "\n" + NLS.bind((String)Messages.WebProjectDoesNotExist, (Object)TextProcessor.process((String)value));
                }
                return resultString;
            }
        } else if ("web.itemname.key".equals(property.getName()) && property.eContainer() instanceof Item && WebProvider.isHREFItem((TypedElement)((Item)property.eContainer()))) {
            String value = property.getValue();
            if (value == null || value.length() == 0) {
                value = Messages.NoTarget;
            }
            return NLS.bind((String)Messages.NodeTypeHREFLinkTooltipX, (Object)TextProcessor.process((String)value));
        }
        return null;
    }

    public boolean hasHandles(Property hint) {
        if ("wde.no.items.placeholder".equals(hint.getName())) {
            return false;
        }
        EObject container = hint.eContainer();
        return !(container instanceof MNode) || !"com.ibm.etools.model2.diagram.web.welcomeInfo".equals(((MNode)container).getType());
    }

    public boolean isFontBold(Property property) {
        return false;
    }

    public boolean isFontItalic(Property property) {
        if ("wde.no.items.placeholder".equals(property.getName())) {
            return true;
        }
        return Messages.NoTarget.equals(this.getPrintString(property));
    }

    public IStatus isValid(Property hint, String userString) {
        MNode node;
        if (userString.indexOf(47) >= 0 || userString.indexOf(92) >= 0 || userString.indexOf(58) >= 0) {
            return new Status(4, "com.ibm.etools.model2.diagram.web.ui", Messages.NamesCannotSpecifyPathInformation);
        }
        IStatus status = ResourcesPlugin.getWorkspace().validateName(userString, 1);
        if (!status.isOK()) {
            return status;
        }
        if (hint.eContainer() instanceof MNode && (node = (MNode)hint.eContainer()).isRealized()) {
            IFile resource;
            IContainer root = WebPropertyDisplayProvider.getDocumentRootContainer((Resource)hint.eResource());
            String parsedString = this.parseEditedString(hint, userString);
            if (parsedString != null && (resource = root.getFile((IPath)new Path(parsedString))) != null && resource.exists()) {
                return new Status(4, "com.ibm.etools.model2.diagram.web.ui", NLS.bind((String)Messages.WebPropertyDisplayProvider_0, (Object)resource.getFullPath()));
            }
        }
        return null;
    }

    public String parseEditedString(Property property, String stringToParse) {
        String nodePath;
        if ("web.path.key".equals(property.getName()) && (nodePath = property.getValue()) != null) {
            Path p = new Path(nodePath);
            String fileExt = p.getFileExtension();
            p = p.removeFileExtension();
            p = p.removeLastSegments(1);
            Path incomingPath = new Path(stringToParse);
            String ext = incomingPath.getFileExtension();
            if (ext != null) {
                if (p.segmentCount() == 0) {
                    p = incomingPath;
                } else {
                    incomingPath = incomingPath.removeFileExtension();
                    p = p.append((IPath)incomingPath).addFileExtension(ext);
                }
            } else {
                p = p.append(stringToParse);
                if (fileExt != null) {
                    p = p.addFileExtension(fileExt);
                }
            }
            return p.toString();
        }
        return null;
    }
}

