/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.properties.sections;

import com.ibm.etools.model2.diagram.web.ui.internal.nls.Messages;
import com.ibm.etools.references.web.javaee.taglib.WebEEUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.AbstractNotationPropertiesSection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class WebDiagramPropertySection
extends AbstractNotationPropertiesSection {
    private Hyperlink link;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
    }

    private IFile getWebXML() {
        IGraphicalEditPart part = this.getSingleInput();
        EObject o = part.resolveSemanticElement();
        if (o.eResource() == null) {
            return null;
        }
        IFile file = WorkspaceSynchronizer.getFile((Resource)o.eResource());
        IProject project = file.getProject();
        IPath path = WebEEUtil.getWebXmlPath((IProject)project);
        if (path == null) {
            return null;
        }
        IFile webxml = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        return webxml;
    }

    protected void initializeControls(Composite parent) {
        Composite sectionComposite = this.getWidgetFactory().createComposite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)sectionComposite, "com.ibm.etools.model2.diagram.web.ui.wde_properties");
        sectionComposite.setLayout((Layout)new GridLayout());
        ExpandableComposite web = this.getWidgetFactory().createExpandableComposite(sectionComposite, 64);
        web.setLayout((Layout)new GridLayout());
        web.setText(Messages.Web);
        Composite c = this.getWidgetFactory().createComposite((Composite)web);
        GridLayout col2 = new GridLayout();
        col2.numColumns = 2;
        c.setLayout((Layout)col2);
        web.setClient((Control)c);
        this.getWidgetFactory().createLabel(c, Messages.WebDeploymentDescriptor);
        this.link = this.getWidgetFactory().createHyperlink(c, "", 0);
        this.link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IFile webxml = WebDiagramPropertySection.this.getWebXML();
                if (webxml != null) {
                    try {
                        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)webxml);
                    }
                    catch (PartInitException e1) {
                        StatusManager.getManager().handle(e1.getStatus(), 3);
                    }
                }
            }
        });
    }

    public void refresh() {
        super.refresh();
        IFile webxml = this.getWebXML();
        if (webxml == null) {
            this.link.setText(Messages.Unknown);
        } else {
            String s = webxml.getProjectRelativePath().makeAbsolute().toString();
            if (s == null) {
                s = "";
            }
            this.link.setText(TextProcessor.process((String)s));
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.refresh();
    }

    public boolean shouldUseExtraSpace() {
        return false;
    }
}

