/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.properties.sections;

import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.Compartment;
import com.ibm.etools.diagram.model.internal.emf.DiagramModelPackage;
import com.ibm.etools.diagram.model.internal.emf.IRealizable;
import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.diagram.ui.internal.DiagramPlugin;
import com.ibm.etools.diagram.ui.internal.adapters.ResourceSelectionDialogAdapter;
import com.ibm.etools.diagram.ui.internal.services.PropertyDisplayService;
import com.ibm.etools.model2.diagram.web.ui.internal.WebUIPlugin;
import com.ibm.etools.model2.diagram.web.ui.internal.nls.Messages;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserService;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.AbstractNotationPropertiesSection;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractWebDiagramPropertySection
extends AbstractNotationPropertiesSection {
    private String nameTextString;
    private Text nameText;
    private Label errorLabel;
    private IFile diagramFile;
    private CommonElement selectedElement;
    private Composite topComposite;
    private TabbedPropertySheetPage page;
    private Composite textPlusButtonHolder;
    private Composite errorComposite;
    private String errorText;

    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        if (this.isEditable()) {
            this.commitChanges();
        }
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
    }

    public void commitChanges() {
        if (this.selectedElement == null) {
            return;
        }
        if (this.selectedElement.eResource() == null) {
            return;
        }
        if (this.selectedElement.getTitleProperty() == null) {
            return;
        }
        if (this.nameTextString.equals(this.initialValue())) {
            return;
        }
        this.validateText();
        this.refreshError();
        if (this.errorText == null) {
            String oldValue = this.selectedElement.getTitleProperty().getValue();
            String newValue = this.getNewValue();
            if (oldValue == null || !oldValue.equals(newValue)) {
                SetRequest request = new SetRequest(this.getEditingDomain(), (EObject)this.selectedElement.getTitleProperty(), (EStructuralFeature)DiagramModelPackage.eINSTANCE.getProperty_Value(), (Object)this.getNewValue());
                ICommand cmd = this.selectedElement.getElementType().getEditCommand((IEditCommandRequest)request);
                IOperationHistory history = OperationHistoryFactory.getOperationHistory();
                IStatus status = null;
                try {
                    status = history.execute((IUndoableOperation)cmd, (IProgressMonitor)new NullProgressMonitor(), null);
                    this.refresh();
                }
                catch (ExecutionException ex) {
                    status = new Status(4, WebUIPlugin.getDefault().getBundle().getSymbolicName(), 0, Messages.ErrorPerformingCommand, (Throwable)ex);
                    cmd.dispose();
                }
                if (status != null && !status.isOK()) {
                    StatusManager.getManager().handle(status, 3);
                }
            }
        } else {
            if (!this.nameText.isDisposed()) {
                if (this.initialValue() == null) {
                    this.nameText.setText("");
                } else {
                    this.nameText.setText(this.initialValue());
                }
            }
            this.errorText = null;
            this.refreshError();
        }
    }

    public void createAdditionalUI(Composite parent) {
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.page = aTabbedPropertySheetPage;
        this.topComposite = this.getWidgetFactory().createComposite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.topComposite.setLayout((Layout)layout);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.topComposite, "com.ibm.etools.model2.diagram.web.ui.wde_properties");
        String label = this.getLabel();
        if (label != null) {
            this.getWidgetFactory().createLabel(this.topComposite, this.getLabel());
        }
        this.textPlusButtonHolder = this.getWidgetFactory().createComposite(this.topComposite, 0);
        GridLayout layout2 = new GridLayout(2, false);
        this.textPlusButtonHolder.setLayoutData((Object)new GridData(768));
        layout2.marginWidth = 0;
        layout2.marginHeight = 0;
        this.textPlusButtonHolder.setLayout((Layout)layout2);
        this.nameText = this.getWidgetFactory().createText(this.textPlusButtonHolder, "");
        this.nameText.setLayoutData((Object)new GridData(768));
        if (this.isEditable()) {
            this.nameText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if (e.keyCode == 27) {
                        if (AbstractWebDiagramPropertySection.this.initialValue() == null) {
                            AbstractWebDiagramPropertySection.this.nameText.setText("");
                        } else {
                            AbstractWebDiagramPropertySection.this.nameText.setText(AbstractWebDiagramPropertySection.this.initialValue());
                        }
                        AbstractWebDiagramPropertySection.this.errorText = null;
                        AbstractWebDiagramPropertySection.this.refreshError();
                    } else {
                        AbstractWebDiagramPropertySection.this.nameTextString = AbstractWebDiagramPropertySection.this.nameText.getText();
                        AbstractWebDiagramPropertySection.this.validateText();
                        AbstractWebDiagramPropertySection.this.refreshError();
                        if (e.character == '\r') {
                            if (AbstractWebDiagramPropertySection.this.errorText != null) {
                                String eText = AbstractWebDiagramPropertySection.this.errorText.replace("&", "&&");
                                Status status = new Status(4, DiagramPlugin.getPluginId(), 4, eText, null);
                                StatusManager.getManager().handle((IStatus)status, 4);
                            }
                            AbstractWebDiagramPropertySection.this.commitChanges();
                        }
                    }
                }
            });
        } else {
            this.nameText.setEditable(false);
            this.nameText.setEnabled(false);
        }
        this.createAdditionalUI(this.topComposite);
        this.errorComposite = new Composite(this.topComposite, 0);
        this.errorComposite.setLayout((Layout)new GridLayout(2, false));
        this.errorComposite.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.errorComposite.setBackground(this.topComposite.getBackground());
        Label errorImage = new Label(this.errorComposite, 0);
        errorImage.setLayoutData((Object)new GridData(1, 2, false, false));
        errorImage.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
        errorImage.setBackground(this.topComposite.getBackground());
        this.errorLabel = new Label(this.errorComposite, 0);
        this.errorLabel.setLayoutData((Object)new GridData(1, 2, true, false));
        this.errorLabel.setForeground(this.topComposite.getShell().getDisplay().getSystemColor(3));
        this.errorLabel.setBackground(this.topComposite.getBackground());
    }

    protected Composite createPaintedSectionComposite(Composite parent) {
        return parent;
    }

    protected void customizeButtonHolder(Composite buttonHolder) {
    }

    public void dispose() {
        super.dispose();
    }

    protected final IFile getDiagramFile() {
        return this.diagramFile;
    }

    public ResourceSelectionDialogAdapter getDialog() {
        CommonElement selectedElement = this.getSelectedElement();
        if (selectedElement != null) {
            return (ResourceSelectionDialogAdapter)selectedElement.getAdapter(ResourceSelectionDialogAdapter.class);
        }
        return null;
    }

    public abstract String getLabel();

    protected final String getNewValue() {
        String parsedString;
        Property title = this.getSelectedElement().getTitleProperty();
        if (title != null && (parsedString = PropertyDisplayService.getInstance().parseEditedString(title, this.nameTextString)) != null) {
            return parsedString;
        }
        return this.nameTextString;
    }

    public CommonElement getSelectedElement() {
        return this.selectedElement;
    }

    protected void initializeControls(Composite parent) {
    }

    public String initialValue() {
        CommonElement selectedElement = this.getSelectedElement();
        String string = null;
        string = PropertyDisplayService.getInstance().getPrintString(selectedElement.getTitleProperty());
        return string;
    }

    public boolean isEditable() {
        EObject o;
        if (this.getSelection() == null) {
            return false;
        }
        Object input = ((IStructuredSelection)this.getSelection()).getFirstElement();
        if (input instanceof IAdaptable && (o = (EObject)((IAdaptable)input).getAdapter(EObject.class)) instanceof IRealizable) {
            IRealizable r = (IRealizable)o;
            return !r.isRealized();
        }
        return false;
    }

    public void refresh() {
        ISelection selection;
        super.refresh();
        if (this.page != null) {
            LabelProviderChangedEvent e = new LabelProviderChangedEvent((IBaseLabelProvider)new LabelProvider());
            this.page.labelProviderChanged(e);
        }
        if (!((selection = this.getSelection()) instanceof IStructuredSelection)) {
            return;
        }
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof INodeEditPart) {
            EObject node;
            Resource res;
            Object model = ((INodeEditPart)input).getModel();
            if (model instanceof EObject && (res = ((EObject)model).eResource()) != null) {
                this.diagramFile = WorkspaceSynchronizer.getFile((Resource)res);
            }
            if (model instanceof Node && (node = ((Node)model).getElement()) instanceof CommonElement) {
                this.selectedElement = (CommonElement)node;
                if (this.initialValue() == null) {
                    this.nameText.setText("");
                } else {
                    this.nameText.setText(this.initialValue());
                }
                this.nameTextString = this.initialValue();
            }
        } else if (input instanceof IGraphicalEditPart) {
            Resource res;
            IGraphicalEditPart inputPart = (IGraphicalEditPart)input;
            EObject object = inputPart.resolveSemanticElement();
            if (object instanceof Compartment) {
                this.selectedElement = ((Compartment)object).getParent();
                this.nameText.setText(this.initialValue());
                this.nameTextString = this.initialValue();
            }
            if (object != null && (res = object.eResource()) != null) {
                this.diagramFile = WorkspaceSynchronizer.getFile((Resource)res);
            }
        }
        if (this.textPlusButtonHolder.getChildren().length == 1) {
            final ResourceSelectionDialogAdapter dialogAdapter = this.getDialog();
            if (dialogAdapter != null && dialogAdapter.getDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Collections.EMPTY_MAP) != null) {
                Button browseButton = this.getWidgetFactory().createButton(this.textPlusButtonHolder, Messages.AbstractWebDiagramPropertySection_ReplaceWith, 0);
                if (this.isEditable()) {
                    browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            SelectionDialog dialog = dialogAdapter.getDialog(e.display.getActiveShell(), Collections.EMPTY_MAP);
                            if (dialog.open() == 0) {
                                String result = dialogAdapter.getStringForResult(dialog.getResult()[0]);
                                AbstractWebDiagramPropertySection.this.nameTextString = result;
                                AbstractWebDiagramPropertySection.this.nameText.setText(result);
                                AbstractWebDiagramPropertySection.this.commitChanges();
                            }
                        }
                    });
                } else {
                    browseButton.setEnabled(false);
                }
            }
            this.customizeButtonHolder(this.textPlusButtonHolder);
        }
        this.refreshError();
    }

    protected void refreshError() {
        if (!this.errorComposite.isDisposed()) {
            String eText = null;
            if (this.errorText != null) {
                eText = this.errorText.replace("&", "&&");
            }
            this.errorLabel.setText(eText == null ? "" : eText);
            this.errorLabel.pack(true);
            this.errorComposite.setVisible(eText != null);
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.refresh();
    }

    public void updateAfterCommand() {
    }

    protected void validateText() {
        CommonElement element = this.getSelectedElement();
        if (element != null) {
            IParser parser = ParserService.getInstance().getParser((IAdaptable)element);
            if (parser != null) {
                this.errorText = parser.isValidEditString((IAdaptable)element, this.nameTextString).getMessage();
                if (this.errorText == "") {
                    this.errorText = null;
                }
            } else {
                this.errorText = null;
            }
        } else {
            this.errorText = null;
        }
    }
}

