/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.projnav;

import com.ibm.etools.model2.diagram.web.ui.internal.WebUIPlugin;
import com.ibm.etools.model2.diagram.web.ui.internal.nls.Messages;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class WebDiagramProjNavElement
implements IAdaptable {
    public IVirtualComponent parent;
    public ArrayList<IResource> children;
    public boolean isCategoryElement = false;
    private static final int UNKNOWN_STATE = -1;

    public WebDiagramProjNavElement(IVirtualComponent parent, ArrayList<IResource> children) {
        this.parent = parent;
        this.children = children;
        this.isCategoryElement = children != null && children.size() > 1;
    }

    public Object getAdapter(Class adapter) {
        if ((adapter.equals(IFile.class) || adapter.equals(IResource.class)) && this.getGphFileCount() == 1) {
            return this.children.get(0);
        }
        return null;
    }

    public Object[] getChildren() {
        if (this.isCategoryElement) {
            return this.children.toArray();
        }
        return new Object[0];
    }

    public int getGphFileCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getHighestSeverityLevel(IMarker[] markers) {
        boolean hasWarning = false;
        boolean hasInfo = false;
        int i = 0;
        while (i < markers.length) {
            try {
                Integer sevLevel = (Integer)markers[i].getAttribute("severity");
                if (sevLevel != null) {
                    switch (sevLevel) {
                        case 2: {
                            return 2;
                        }
                        case 1: {
                            hasWarning = true;
                        }
                        case 0: {
                            hasInfo = true;
                            break;
                        }
                        default: {
                            break;
                        }
                    }
                }
            }
            catch (CoreException ce) {
                WebUIPlugin.getDefault().getLog().log(ce.getStatus());
            }
            ++i;
        }
        if (hasWarning) {
            return 1;
        }
        if (hasInfo) {
            return 0;
        }
        return -1;
    }

    public Image getImage() {
        if (this.isCategoryElement) {
            return this.getWebDiagramCategoryNodeImage();
        }
        return WebUIPlugin.getImage("icons/obj16/diagram_obj.gif");
    }

    public Object getParent() {
        return this.parent;
    }

    public String getText() {
        if (this.isCategoryElement) {
            return Messages.WebDiagrams;
        }
        return Messages.WebDiagramNode;
    }

    private Image getWebDiagramCategoryNodeImage() {
        if (!this.isCategoryElement) {
            return null;
        }
        boolean hasWarning = false;
        for (IFile iFile : this.children) {
            IMarker[] fileMarkers = null;
            if (iFile != null && iFile.isAccessible()) {
                try {
                    fileMarkers = iFile.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
                }
                catch (CoreException ce) {
                    WebUIPlugin.getDefault().getLog().log(ce.getStatus());
                }
            }
            if (fileMarkers == null || fileMarkers.length <= 0) continue;
            int severity = this.getHighestSeverityLevel(fileMarkers);
            if (severity == 2) {
                return WebUIPlugin.getImage("icons/obj16/diagram_folder_err.gif");
            }
            if (severity != 1) continue;
            hasWarning = true;
        }
        if (hasWarning) {
            return WebUIPlugin.getImage("icons/obj16/diagram_folder_warn.gif");
        }
        return WebUIPlugin.getImage("icons/obj16/diagram_folder.gif");
    }

    public boolean hasChildren() {
        return this.isCategoryElement;
    }
}

