/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.projnav;

import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.model2.diagram.web.ui.internal.WebUIPlugin;
import com.ibm.etools.model2.diagram.web.ui.internal.projnav.WebDiagramContentProvider;
import com.ibm.etools.model2.diagram.web.ui.internal.projnav.WebDiagramProjNavElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class WebDiagramContributionContentManager {
    private IResourceChangeListener fWorkspaceResourceChangeListener = new LocalResourceChangedListener();
    private HashMap projectElementMap = new HashMap();
    private WebDiagramContentProvider contentProvider;

    public WebDiagramContributionContentManager(WebDiagramContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    private Object[] createProjectChildren(IProject project) {
        ArrayList<WebDiagramProjNavElement> children = new ArrayList<WebDiagramProjNavElement>();
        IVirtualComponent component = Model2Util.findComponent((IResource)project);
        ArrayList<IResource> childrenList = this.getAllGphFiles(project);
        if (childrenList.size() > 0) {
            WebDiagramProjNavElement element = new WebDiagramProjNavElement(component, childrenList);
            children.add(element);
        }
        this.projectElementMap.put(project, children.toArray());
        return children.toArray();
    }

    public void dispose() {
        this.projectElementMap.clear();
    }

    private ArrayList<IResource> getAllGphFiles(Object parent) {
        ArrayList<IResource> childrenList = new ArrayList<IResource>();
        if (parent instanceof IProject) {
            IProject project = (IProject)parent;
            if (!project.isAccessible() || !project.exists()) {
                return childrenList;
            }
            try {
                project.accept((IResourceVisitor)new LocalResourceVisitor(childrenList, "gph"));
            }
            catch (CoreException ce) {
                WebUIPlugin.getLogger().log((Throwable)ce);
            }
        }
        return childrenList;
    }

    public Object getParentForFile(IFile file) {
        IProject project = file.getProject();
        Object[] element = (Object[])this.projectElementMap.get(project);
        if (element == null || element.length == 0) {
            return null;
        }
        return element[0];
    }

    public Object[] getProjectChildren(IProject project) {
        Object[] children = (Object[])this.projectElementMap.get(project);
        if (children == null) {
            children = this.createProjectChildren(project);
        }
        return children;
    }

    public IResourceChangeListener getResourceChangeListener() {
        return this.fWorkspaceResourceChangeListener;
    }

    private void handleResourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        HashSet<IResource> affectedProjectSet = new HashSet<IResource>();
        try {
            delta.accept((IResourceDeltaVisitor)new LocalResourceDeltaVisitor(affectedProjectSet));
        }
        catch (CoreException ce) {
            WebUIPlugin.getDefault().getLog().log(ce.getStatus());
        }
        ArrayList<Object> removedTargets = null;
        ArrayList<IResource> addedProjects = null;
        if (!affectedProjectSet.isEmpty()) {
            for (IResource affectedProject : affectedProjectSet) {
                Object[] value = (Object[])this.projectElementMap.remove(affectedProject);
                if (value == null) continue;
                if (value.length != 0) {
                    if (removedTargets == null) {
                        removedTargets = new ArrayList<Object>();
                    }
                    removedTargets.add(value[0]);
                    continue;
                }
                if (addedProjects == null) {
                    addedProjects = new ArrayList<IResource>();
                }
                this.createProjectChildren((IProject)affectedProject);
                addedProjects.add(affectedProject);
            }
            this.contentProvider.notifyRefresh();
        }
    }

    private boolean isValidFilteredFile(IFile file, String filterExt) {
        String fileExt = file.getFileExtension();
        return filterExt.equalsIgnoreCase(fileExt);
    }

    public class LocalResourceChangedListener
    implements IResourceChangeListener {
        public void resourceChanged(IResourceChangeEvent event) {
            int type = event.getType();
            if (type == 1) {
                WebDiagramContributionContentManager.this.handleResourceChanged(event);
            }
        }
    }

    private class LocalResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private HashSet<IResource> affectedProjectSet;

        public LocalResourceDeltaVisitor(HashSet<IResource> affectedProjectSet) {
            this.affectedProjectSet = affectedProjectSet;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IFile file;
            IResource resource = delta.getResource();
            if (resource.getType() == 4) {
                switch (delta.getKind()) {
                    case 4: {
                        return true;
                    }
                    case 2: {
                        this.affectedProjectSet.add(resource);
                    }
                }
                return false;
            }
            if (resource.getType() == 1 && WebDiagramContributionContentManager.this.isValidFilteredFile(file = (IFile)resource, "gph")) {
                switch (delta.getKind()) {
                    case 1: 
                    case 2: {
                        IProject project = file.getProject();
                        this.affectedProjectSet.add((IResource)project);
                    }
                }
            }
            return true;
        }
    }

    private class LocalResourceVisitor
    implements IResourceVisitor {
        private ArrayList<IResource> list;
        private String extension;

        public LocalResourceVisitor(ArrayList<IResource> list, String extension) {
            this.list = list;
            this.extension = extension;
            if (extension == null) {
                extension = "";
            }
        }

        public boolean visit(IResource resource) throws CoreException {
            if (!resource.isAccessible() || !resource.exists()) {
                return false;
            }
            switch (resource.getType()) {
                case 1: {
                    IFile file = (IFile)resource;
                    if (WebDiagramContributionContentManager.this.isValidFilteredFile(file, this.extension)) {
                        this.list.add(resource);
                    }
                    return false;
                }
                case 2: {
                    IFolder folder = (IFolder)resource;
                    return !folder.getName().equals(".deployables");
                }
            }
            return true;
        }
    }
}

