/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.operations;

import com.ibm.etools.model2.diagram.web.ui.internal.WebUIPlugin;
import com.ibm.etools.model2.diagram.web.ui.internal.ide.WebDiagramFileCreator;
import com.ibm.etools.model2.diagram.web.ui.internal.ide.WebEditorUtil;
import com.ibm.etools.model2.diagram.web.ui.internal.nls.Messages;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProjectWorkingCopy;

public class CreateWebDiagramOperation
extends AbstractDataModelOperation {
    public static final String ENTERPRISE_APPLICATION = "jst.ear";
    public static final String APPLICATION_CLIENT = "jst.appclient";
    public static final String EJB = "jst.ejb";
    public static final String DYNAMIC_WEB = "jst.web";
    public static final String UTILITY = "jst.utility";
    public static final String JCA = "jst.connector";
    public static final String STATIC_WEB = "wst.web";

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        String projName = (String)this.model.getProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        this.model.isProperty("IJ2EEArtifactImportDataModelProperties.NESTED_MODEL_J2EE_COMPONENT_CREATION");
        boolean isPortlet = false;
        boolean hasStrutsPortlet = false;
        boolean hasFacesPortlet = false;
        FacetedProjectWorkingCopy p = (FacetedProjectWorkingCopy)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        Set projectFacets = p.getProjectFacets();
        for (IProjectFacetVersion facet : projectFacets) {
            String facetId = facet.getProjectFacet().getId();
            if (ENTERPRISE_APPLICATION.equals(facetId) || APPLICATION_CLIENT.equals(facetId) || EJB.equals(facetId) || UTILITY.equals(facetId) || JCA.equals(facetId)) {
                return OK_STATUS;
            }
            if ("jsf.composite".equals(facetId)) {
                return OK_STATUS;
            }
            if ("ibmportlet.base".equals(facetId) || "jsr.base".equals(facetId)) {
                isPortlet = true;
                continue;
            }
            if ("ibmportlet.struts".equals(facetId) || "jsr.struts".equals(facetId)) {
                hasStrutsPortlet = true;
                continue;
            }
            if (!"jsf.base".equals(facetId)) continue;
            hasFacesPortlet = true;
        }
        if (isPortlet && !hasStrutsPortlet && !hasFacesPortlet) {
            return OK_STATUS;
        }
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        CheckPreferenceJob openEditorJob = new CheckPreferenceJob(proj);
        openEditorJob.schedule();
        return OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return OK_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return OK_STATUS;
    }

    static /* synthetic */ IStatus access$0() {
        return AbstractDataModelOperation.OK_STATUS;
    }

    private static class CheckPreferenceJob
    extends UIJob {
        private final IProject project;

        public CheckPreferenceJob(IProject project) {
            super(Messages.WebEditorUtil_0);
            this.setUser(true);
            this.project = project;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            boolean openEditor = WebUIPlugin.getDefault().getPreferenceStore().getBoolean("open.wde.auto");
            CreateOpenDiagramUIJob openJob = new CreateOpenDiagramUIJob(this.project, openEditor);
            openJob.schedule();
            return Status.OK_STATUS;
        }
    }

    public static class CreateDiagramDataModelProvider
    extends AbstractDataModelProvider {
        public static final String MODEL_NAME = "com.ibm.etools.model2.diagram.web.CreateDiagramDataModelProvider";
        public static final String FILE = "CreateDiagramDataModelProvider.FILE";

        public Object getDefaultProperty(String propertyName) {
            if (FILE.equals(propertyName)) {
                return null;
            }
            return super.getDefaultProperty(propertyName);
        }

        public Set<String> getPropertyNames() {
            Set propertyNames = super.getPropertyNames();
            propertyNames.add(FILE);
            return propertyNames;
        }
    }

    private static class CreateOpenDiagramUIJob
    extends Job {
        private final IProject project;
        private final boolean open;

        public CreateOpenDiagramUIJob(IProject project, boolean open) {
            super(Messages.CreateWebDiagramOperation_CreateNewDiagram);
            this.setUser(false);
            IFile file = project.getFile("WebDiagram.gph");
            ISchedulingRule rule = ResourcesPlugin.getWorkspace().getRuleFactory().createRule((IResource)file);
            ISchedulingRule rule2 = ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)file);
            ISchedulingRule multi = MultiRule.combine((ISchedulingRule)rule, (ISchedulingRule)rule2);
            this.setRule(multi);
            this.project = project;
            this.open = open;
        }

        public IStatus run(IProgressMonitor mon) {
            try {
                IWorkspaceRunnable op = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        try {
                            WebEditorUtil.createAndOpenWebDiagram(WebDiagramFileCreator.getInstance(), CreateOpenDiagramUIJob.this.project.getFullPath(), "WebDiagram.gph", new ByteArrayInputStream(new byte[0]), "wde.element", PlatformUI.getWorkbench().getWorkbenchWindows()[0], monitor, CreateOpenDiagramUIJob.this.open, false, null);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
                ResourcesPlugin.getWorkspace().run(op, this.getRule(), 1, mon);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            return CreateWebDiagramOperation.access$0();
        }
    }
}

