/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.migration;

import com.ibm.etools.diagram.model.internal.services.MigrationService;
import com.ibm.etools.diagram.model.util.ModelUpdateUtils;
import com.ibm.etools.model2.diagram.web.ui.internal.WebUIPlugin;
import com.ibm.etools.model2.diagram.web.ui.internal.migration.LegacyWDEMigrationSAXHandler;
import com.ibm.etools.model2.diagram.web.ui.internal.migration.LegacyWDEVersionPeeker;
import com.ibm.etools.model2.diagram.web.ui.internal.migration.WebDiagramEntityResolver;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.osgi.framework.Bundle;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class LegacyWDEMigrator {
    private final MigratorError listener = new MigratorError();

    private List<TransformerHandler> getTransformHandlers(int peekerVersion) throws TransformerFactoryConfigurationError, TransformerConfigurationException {
        SAXTransformerFactory transformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
        transformerFactory.setErrorListener(this.listener);
        ArrayList<TransformerHandler> transformers = new ArrayList<TransformerHandler>();
        switch (peekerVersion) {
            case 1: {
                StreamSource source = new StreamSource(FileLocator.find((Bundle)WebUIPlugin.getDefault().getBundle(), (IPath)new Path("dtd/web-diagram-1.0-to-1.1.xsl"), null).toExternalForm());
                TransformerHandler handler = transformerFactory.newTransformerHandler(source);
                handler.getTransformer().setErrorListener(this.listener);
                transformers.add(handler);
            }
            case 2: {
                StreamSource source = new StreamSource(FileLocator.find((Bundle)WebUIPlugin.getDefault().getBundle(), (IPath)new Path("dtd/web-diagram-1.1-to-1.2-pass-1.xsl"), null).toExternalForm());
                TransformerHandler handler = transformerFactory.newTransformerHandler(source);
                handler.getTransformer().setErrorListener(this.listener);
                transformers.add(handler);
                source = new StreamSource(FileLocator.find((Bundle)WebUIPlugin.getDefault().getBundle(), (IPath)new Path("dtd/web-diagram-1.1-to-1.2-pass-2.xsl"), null).toExternalForm());
                handler = transformerFactory.newTransformerHandler(source);
                handler.getTransformer().setErrorListener(this.listener);
                transformers.add(handler);
                source = new StreamSource(FileLocator.find((Bundle)WebUIPlugin.getDefault().getBundle(), (IPath)new Path("dtd/web-diagram-1.1-to-1.2-pass-3.xsl"), null).toExternalForm());
                handler = transformerFactory.newTransformerHandler(source);
                handler.getTransformer().setErrorListener(this.listener);
                transformers.add(handler);
            }
            case 3: {
                transformers.add(transformerFactory.newTransformerHandler());
            }
        }
        return transformers;
    }

    public Diagram loadDiagram(IStorage contents, Resource resource) throws CoreException {
        Diagram diagram;
        block14: {
            String originalProperty;
            block13: {
                originalProperty = null;
                try {
                    Diagram diagram2;
                    if (System.getProperty("java.vendor").startsWith("IBM") && System.getProperty("java.version").startsWith("1.6")) {
                        originalProperty = System.getProperty("javax.xml.transform.TransformerFactory");
                        System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
                    }
                    LegacyWDEVersionPeeker peeker = new LegacyWDEVersionPeeker(contents);
                    final int peekerVersion = peeker.getVersion();
                    List<TransformerHandler> transformers = this.getTransformHandlers(peekerVersion);
                    TransformerHandler handler = null;
                    final LegacyWDEMigrationSAXHandler modelcreator = new LegacyWDEMigrationSAXHandler(peekerVersion);
                    modelcreator.setResource(resource);
                    SAXResult result = new SAXResult(modelcreator);
                    ListIterator<TransformerHandler> iter = transformers.listIterator(transformers.size());
                    while (iter.hasPrevious()) {
                        handler = iter.previous();
                        handler.setResult(result);
                        result = new SAXResult(handler);
                    }
                    SAXParserFactory parserfactory = SAXParserFactory.newInstance();
                    parserfactory.setNamespaceAware(true);
                    SAXParser parser = parserfactory.newSAXParser();
                    final XMLReader reader = parser.getXMLReader();
                    reader.setEntityResolver(new WebDiagramEntityResolver());
                    reader.setContentHandler(handler);
                    InputStream stream = contents.getContents();
                    try {
                        final InputSource sourceFile = new InputSource(stream);
                        sourceFile.setSystemId(new File(System.getProperty("user.dir")).toURL().toString());
                        final Throwable[] holder = new Exception[1];
                        Runnable readerRunnable = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    reader.parse(sourceFile);
                                    String version = Integer.toString(peekerVersion);
                                    MigrationService.getInstance().postProcessDiagram(modelcreator.getDiagram(), version);
                                }
                                catch (Exception e) {
                                    holder[0] = LegacyWDEMigrator.this.unwrapException(e);
                                }
                            }
                        };
                        ModelUpdateUtils.updateModelNoUndo((Resource)resource, (Runnable)readerRunnable, (boolean)true);
                        if (holder[0] != null) {
                            throw holder[0];
                        }
                    }
                    finally {
                        stream.close();
                    }
                    diagram = diagram2 = modelcreator.getDiagram();
                    if (originalProperty != null) break block13;
                }
                catch (Throwable e) {
                    try {
                        Status status = new Status(4, "com.ibm.etools.web.diagram", 0, "Errors reading web diagram file: ", e);
                        throw new CoreException((IStatus)status);
                    }
                    catch (Throwable throwable) {
                        if (originalProperty == null) {
                            System.clearProperty("javax.xml.transform.TransformerFactory");
                        } else {
                            System.setProperty("javax.xml.transform.TransformerFactory", originalProperty);
                        }
                        throw throwable;
                    }
                }
                System.clearProperty("javax.xml.transform.TransformerFactory");
                break block14;
            }
            System.setProperty("javax.xml.transform.TransformerFactory", originalProperty);
        }
        return diagram;
    }

    private Throwable unwrapException(Exception e) {
        Throwable cause = e;
        do {
            if (cause instanceof SAXException) {
                cause = ((SAXException)cause).getException();
                continue;
            }
            if (!(cause instanceof TransformerException)) break;
            cause = ((TransformerException)cause).getCause();
        } while (cause != null);
        return cause;
    }

    private static class MigratorError
    implements ErrorListener {
        private MigratorError() {
        }

        @Override
        public void error(TransformerException exception) throws TransformerException {
        }

        @Override
        public void fatalError(TransformerException exception) throws TransformerException {
        }

        @Override
        public void warning(TransformerException exception) throws TransformerException {
        }
    }
}

