/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.model2.diagram.web.ui.internal.ide;

import com.ibm.etools.diagram.ui.internal.editparts.ProviderTitleEditPart;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.render.editparts.RenderedDiagramRootEditPart;
import org.eclipse.swt.events.KeyEvent;

public class SelectIntoNestedChildKeyHandler
extends KeyHandler {
    private GraphicalViewer viewer;

    public SelectIntoNestedChildKeyHandler(GraphicalViewer viewer) {
        this.viewer = viewer;
    }

    boolean acceptIntoContainer(KeyEvent event) {
        return (event.stateMask & 0x10000) != 0 && event.keyCode == 0x1000002;
    }

    boolean acceptLeaveConnection(KeyEvent event) {
        int key = event.keyCode;
        return this.getFocusEditPart() instanceof ConnectionEditPart && (key == 0x1000001 || key == 0x1000004 || key == 0x1000002 || key == 0x1000003);
    }

    private boolean acceptOpen(KeyEvent event) {
        return event.character == '\r';
    }

    boolean acceptOutOf(KeyEvent event) {
        return (event.stateMask & 0x10000) != 0 && event.keyCode == 0x1000001;
    }

    /*
     * WARNING - void declaration
     */
    GraphicalEditPart findSibling(List<EditPart> siblings, Point pStart, int direction, EditPart exclude) {
        GraphicalEditPart epFinal = null;
        int distance = Integer.MAX_VALUE;
        for (GraphicalEditPart graphicalEditPart : siblings) {
            int d;
            void var5_8;
            Point pCurrent;
            IFigure figure;
            if (graphicalEditPart == exclude) continue;
            if (!graphicalEditPart.isSelectable()) {
                List children = graphicalEditPart.getChildren();
                boolean foundChild = false;
                int distance2 = Integer.MAX_VALUE;
                for (GraphicalEditPart nestedChild : children) {
                    int d2;
                    if (nestedChild == exclude || !nestedChild.isSelectable()) continue;
                    figure = nestedChild.getFigure();
                    pCurrent = this.getNavigationPoint(figure);
                    figure.translateToAbsolute((Translatable)pCurrent);
                    if (pStart.getPosition(pCurrent) != direction || (d2 = pCurrent.getDistanceOrthogonal(pStart)) >= distance2) continue;
                    distance2 = d2;
                    GraphicalEditPart graphicalEditPart2 = nestedChild;
                    foundChild = true;
                }
                if (!foundChild) continue;
            }
            figure = var5_8.getFigure();
            pCurrent = this.getNavigationPoint(figure);
            figure.translateToAbsolute((Translatable)pCurrent);
            if (pStart.getPosition(pCurrent) != direction || (d = pCurrent.getDistanceOrthogonal(pStart)) >= distance) continue;
            distance = d;
            epFinal = var5_8;
        }
        return epFinal;
    }

    protected GraphicalEditPart getFocusEditPart() {
        GraphicalEditPart part = (GraphicalEditPart)this.getViewer().getFocusEditPart();
        if (part instanceof RenderedDiagramRootEditPart && part.getChildren().size() > 0) {
            return (GraphicalEditPart)part.getChildren().get(0);
        }
        return (GraphicalEditPart)this.getViewer().getFocusEditPart();
    }

    Point getNavigationPoint(IFigure figure) {
        return figure.getBounds().getCenter();
    }

    List<EditPart> getNavigationSiblings() {
        GraphicalEditPart focusPart = this.getFocusEditPart();
        EditPart parent = focusPart.getParent();
        if (parent instanceof CompartmentEditPart) {
            EditPart realParent = focusPart.getParent().getParent();
            if (realParent != null) {
                return realParent.getChildren();
            }
        } else {
            if (parent instanceof ProviderTitleEditPart) {
                EditPart realParent = focusPart.getParent().getParent();
                if (realParent != null) {
                    return realParent.getChildren();
                }
                return focusPart.getParent().getChildren();
            }
            if (parent != null) {
                return parent.getChildren();
            }
        }
        ArrayList<EditPart> list = new ArrayList<EditPart>();
        list.add((EditPart)focusPart);
        return list;
    }

    protected GraphicalViewer getViewer() {
        return this.viewer;
    }

    boolean isViewerMirrored() {
        return (this.viewer.getControl().getStyle() & 0x8000000) != 0;
    }

    public boolean keyPressed(KeyEvent event) {
        if (this.acceptIntoContainer(event)) {
            this.navigateIntoContainer(event);
            return true;
        }
        if (this.acceptOutOf(event)) {
            this.navigateOut(event);
            return true;
        }
        if (this.acceptOpen(event)) {
            this.performOpen(event);
            return true;
        }
        switch (event.keyCode) {
            case 0x1000003: {
                if (!this.navigateNextSibling(event, this.isViewerMirrored() ? 16 : 8)) break;
                return true;
            }
            case 0x1000004: {
                if (!this.navigateNextSibling(event, this.isViewerMirrored() ? 8 : 16)) break;
                return true;
            }
            case 0x1000001: {
                if (!this.navigateNextSibling(event, 1)) break;
                return true;
            }
            case 0x1000002: {
                if (!this.navigateNextSibling(event, 4)) break;
                return true;
            }
        }
        return super.keyPressed(event);
    }

    void navigateIntoContainer(KeyEvent event) {
        GraphicalEditPart focus = this.getFocusEditPart();
        List childList = focus.getChildren();
        Point tl = focus.getContentPane().getBounds().getTopLeft();
        int minimum = Integer.MAX_VALUE;
        GraphicalEditPart closestPart = null;
        int i = 0;
        while (i < childList.size()) {
            block9: {
                GraphicalEditPart ged;
                block8: {
                    ged = (GraphicalEditPart)childList.get(i);
                    if (ged.isSelectable()) break block8;
                    boolean foundNested = false;
                    List nestedChildList = ged.getChildren();
                    int j = 0;
                    while (j < nestedChildList.size() && !foundNested) {
                        GraphicalEditPart nestedChild = (GraphicalEditPart)nestedChildList.get(j);
                        if (nestedChild.isSelectable()) {
                            ged = nestedChild;
                            foundNested = true;
                        }
                        ++j;
                    }
                    if (!foundNested) break block9;
                }
                Rectangle childBounds = ged.getFigure().getBounds();
                int current = childBounds.x - tl.x + (childBounds.y - tl.y);
                if (current < minimum) {
                    minimum = current;
                    closestPart = ged;
                }
            }
            ++i;
        }
        if (closestPart != null) {
            this.navigateTo((EditPart)closestPart, event);
        }
    }

    boolean navigateNextSibling(KeyEvent event, int direction) {
        return this.navigateNextSibling(event, direction, this.getNavigationSiblings());
    }

    boolean navigateNextSibling(KeyEvent event, int direction, List<EditPart> list) {
        GraphicalEditPart epStart = this.getFocusEditPart();
        if (this.getFocusEditPart() == this.getViewer().getContents()) {
            List children = epStart.getChildren();
            for (GraphicalEditPart child : children) {
                if (child == null) continue;
                this.navigateTo((EditPart)child, event);
                return true;
            }
        }
        IFigure figure = epStart.getFigure();
        Point pStart = this.getNavigationPoint(figure);
        figure.translateToAbsolute((Translatable)pStart);
        GraphicalEditPart next = this.findSibling(list, pStart, direction, (EditPart)epStart);
        if (next == null) {
            return false;
        }
        this.navigateTo((EditPart)next, event);
        return true;
    }

    void navigateOut(KeyEvent event) {
        if (this.getFocusEditPart() == null || this.getFocusEditPart() == this.getViewer().getContents() || this.getFocusEditPart().getParent() == this.getViewer().getContents()) {
            return;
        }
        GraphicalEditPart part = (GraphicalEditPart)this.getFocusEditPart().getParent();
        boolean selectable = part.isSelectable();
        while (!selectable) {
            part = (GraphicalEditPart)part.getParent();
            selectable = part.isSelectable();
        }
        this.navigateTo((EditPart)part, event);
    }

    protected void navigateTo(EditPart part, KeyEvent event) {
        if (part == null) {
            return;
        }
        if ((event.stateMask & 0x20000) != 0) {
            this.getViewer().appendSelection(part);
            this.getViewer().setFocus(part);
        } else if ((event.stateMask & 0x40000) != 0) {
            this.getViewer().setFocus(part);
        } else {
            this.getViewer().select(part);
        }
        this.getViewer().reveal(part);
    }

    private void performOpen(KeyEvent event) {
        SelectionRequest request = new SelectionRequest();
        request.setLocation(this.getFocusEditPart().getFigure().getClientArea().getCenter());
        request.setModifiers(event.stateMask);
        request.setType((Object)"open");
        this.getFocusEditPart().performRequest((Request)request);
    }
}

